// $Id: gui.cpp,v 1.3 2003/01/31 06:07:38 yuya Exp $

////////////////////////////////////////////////////////////////////////////////

#include "exerb.h"

////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE current_instance, HINSTANCE prev_instance, LPSTR cmd_line, int show_cmd);

static void ExOnError(LPSTR message);
static void ExOnFail(VALUE errinfo);
static LRESULT CALLBACK ExFailDialogProc(HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam);

////////////////////////////////////////////////////////////////////////////////

int WINAPI
WinMain(HINSTANCE current_instance, HINSTANCE prev_instance, LPSTR cmd_line, int show_cmd)
{
	return ExMain(0, NULL, ExOnError, ExOnFail);
}


static void
ExOnError(LPSTR message)
{
	char self_filename[MAX_PATH] = "";
	::ExGetSelfFileName(self_filename, sizeof(self_filename));
	::MessageBox(NULL, message, self_filename, MB_ICONERROR);
}

static void
ExOnFail(VALUE errinfo)
{
	::DialogBoxParam(
		::GetModuleHandle(NULL),
		MAKEINTRESOURCE(IDD_EXCEPTION),
		NULL,
		(DLGPROC)::ExFailDialogProc,
		(LPARAM)errinfo);
}

static LRESULT CALLBACK
ExFailDialogProc(HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam)
{
	switch ( message ) {
		case WM_INITDIALOG:
			if ( lparam ) {
				const VALUE errinfo       = (VALUE)lparam;
				const VALUE type          = ::rb_funcall(errinfo, ::rb_intern("type"), 0);
				const VALUE type_str      = ::rb_funcall(type, ::rb_intern("name"), 0);
				const VALUE message       = ::rb_funcall(errinfo, ::rb_intern("message"), 0);
				const VALUE message_str   = ::rb_funcall(message, ::rb_intern("gsub"), 2, ::rb_str_new2("\n"), ::rb_str_new2("\r\n"));
				const VALUE backtrace     = ::rb_funcall(errinfo, ::rb_intern("backtrace"), 0);
				const VALUE backtrace_str = ::rb_str_concat(::rb_ary_join(backtrace, ::rb_str_new2("\r\n")), rb_str_new2("\r\n"));

				::SetDlgItemText(hwnd, IDC_EDIT_TYPE,      STR2CSTR(type_str));
				::SetDlgItemText(hwnd, IDC_EDIT_MESSAGE,   STR2CSTR(message_str));
				::SetDlgItemText(hwnd, IDC_EDIT_BACKTRACE, STR2CSTR(backtrace_str));
			}

			{
				char self_filename[MAX_PATH]       = "";
				char window_title_format[MAX_PATH] = "";
				char window_title[MAX_PATH]        = "";
				::ExGetSelfFileName(self_filename, sizeof(self_filename));
				::GetWindowText(hwnd, window_title_format, sizeof(window_title_format));
				::wsprintf(window_title, window_title_format, self_filename);
				::SetWindowText(hwnd, window_title);
			}

			{
				const HFONT font = ::CreateFont(14, 0, 0, 0, FW_REGULAR, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH | FF_MODERN, "Terminal");
				SetWindowFont(::GetDlgItem(hwnd, IDC_EDIT_TYPE),      font, false);
				SetWindowFont(::GetDlgItem(hwnd, IDC_EDIT_MESSAGE),   font, false);
				SetWindowFont(::GetDlgItem(hwnd, IDC_EDIT_BACKTRACE), font, false);
			}

			::MessageBeep(MB_ICONHAND);

			return TRUE;
		case WM_CLOSE:
			::EndDialog(hwnd, ID_CLOSE);
			return TRUE;
		case WM_COMMAND:
			if ( LOWORD(wparam) == ID_CLOSE ) {
				::EndDialog(hwnd, ID_CLOSE);
				return TRUE;
			}
			break;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
