// $Id: gui.cpp,v 1.7 2003/10/27 08:51:05 yuya Exp $

#include <windows.h>
#include <windowsx.h>
#include <ruby.h>
#include "resource.h"

////////////////////////////////////////////////////////////////////////////////

int exerb_main(int argc, char** argv, void (*on_fail)(VALUE)); // exerb.cpp

int WINAPI WinMain(HINSTANCE current_instance, HINSTANCE prev_instance, LPSTR cmd_line, int show_cmd);
static void on_fail(VALUE errinfo);
static LRESULT CALLBACK dialog_proc(HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam);

////////////////////////////////////////////////////////////////////////////////

int WINAPI
WinMain(HINSTANCE current_instance, HINSTANCE prev_instance, LPSTR cmd_line, int show_cmd)
{
	return ::exerb_main(0, NULL, on_fail);
}

static void
on_fail(VALUE errinfo)
{
	::DialogBoxParam(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_EXCEPTION), NULL, (DLGPROC)::dialog_proc, (LPARAM)errinfo);
}

static LRESULT CALLBACK
dialog_proc(HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam)
{
	static HFONT font = NULL;

	switch ( message ) {
		case WM_INITDIALOG:
			if ( lparam ) {
				const VALUE errinfo       = (VALUE)lparam;
				const VALUE message       = ::rb_funcall(errinfo, ::rb_intern("message"), 0);
				const VALUE message_str   = ::rb_funcall(message, ::rb_intern("gsub"), 2, ::rb_str_new2("\n"), ::rb_str_new2("\r\n"));
				const VALUE backtrace     = ::rb_funcall(errinfo, ::rb_intern("backtrace"), 0);
				const VALUE backtrace_str = ::rb_str_concat(::rb_ary_join(backtrace, ::rb_str_new2("\r\n")), rb_str_new2("\r\n"));

				::SetDlgItemText(hwnd, IDC_EDIT_TYPE,      ::rb_obj_classname(errinfo));
				::SetDlgItemText(hwnd, IDC_EDIT_MESSAGE,   STR2CSTR(message_str));
				::SetDlgItemText(hwnd, IDC_EDIT_BACKTRACE, STR2CSTR(backtrace_str));
			}

			{
				char self_filename[MAX_PATH]       = "";
				char window_title_format[MAX_PATH] = "";
				char window_title[MAX_PATH]        = "";
				::GetModuleFileName(NULL, self_filename, sizeof(self_filename));
				::GetWindowText(hwnd, window_title_format, sizeof(window_title_format));
				::wsprintf(window_title, window_title_format, self_filename);
				::SetWindowText(hwnd, window_title);
			}

			font = ::CreateFont(14, 0, 0, 0, FW_REGULAR, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH | FF_MODERN, "Terminal");
			SetWindowFont(::GetDlgItem(hwnd, IDC_EDIT_TYPE),      font, false);
			SetWindowFont(::GetDlgItem(hwnd, IDC_EDIT_MESSAGE),   font, false);
			SetWindowFont(::GetDlgItem(hwnd, IDC_EDIT_BACKTRACE), font, false);

			::MessageBeep(MB_ICONHAND);
			
			return TRUE;
		case WM_DESTROY:
			::DeleteObject(font);
			return TRUE;
		case WM_CLOSE:
			::EndDialog(hwnd, ID_CLOSE);
			return TRUE;
		case WM_COMMAND:
			if ( LOWORD(wparam) == ID_CLOSE ) {
				::EndDialog(hwnd, ID_CLOSE);
				return TRUE;
			}
			break;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
