/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.nosql.NoSqlSessionDataStore;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class MongoSessionDataStore
extends NoSqlSessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private static final String __METADATA = "__metadata__";
    private static final String __CONTEXT = "context";
    public static final String __VERSION = "__metadata__.version";
    public static final String __LASTSAVED = "__metadata__.lastSaved";
    public static final String __LASTNODE = "__metadata__.lastNode";
    public static final String __ACCESSED = "accessed";
    public static final String __EXPIRY = "expiry";
    public static final String __MAX_IDLE = "maxIdle";
    private static final String __CREATED = "created";
    public static final String __VALID = "valid";
    public static final String __ID = "id";
    private DBObject _version_1;
    private DBCollection _dbSessions;

    public void setDBCollection(DBCollection collection) {
        this._dbSessions = collection;
    }

    @ManagedAttribute(value="DBCollection", readonly=true)
    public DBCollection getDBCollection() {
        return this._dbSessions;
    }

    public SessionData load(final String id) throws Exception {
        final AtomicReference reference = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    DBObject sessionDocument = MongoSessionDataStore.this._dbSessions.findOne((DBObject)new BasicDBObject(MongoSessionDataStore.__ID, (Object)id));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("id={} loaded={}", new Object[]{id, sessionDocument});
                    }
                    if (sessionDocument == null) {
                        return;
                    }
                    Boolean valid = (Boolean)sessionDocument.get(MongoSessionDataStore.__VALID);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("id={} valid={}", new Object[]{id, valid});
                    }
                    if (valid == null || !valid.booleanValue()) {
                        return;
                    }
                    Object version = MongoSessionDataStore.this.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextSubfield(MongoSessionDataStore.__VERSION));
                    Long lastSaved = (Long)MongoSessionDataStore.this.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextSubfield(MongoSessionDataStore.__LASTSAVED));
                    String lastNode = (String)MongoSessionDataStore.this.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextSubfield(MongoSessionDataStore.__LASTNODE));
                    Long created = (Long)sessionDocument.get(MongoSessionDataStore.__CREATED);
                    Long accessed = (Long)sessionDocument.get(MongoSessionDataStore.__ACCESSED);
                    Long maxInactive = (Long)sessionDocument.get(MongoSessionDataStore.__MAX_IDLE);
                    Long expiry = (Long)sessionDocument.get(MongoSessionDataStore.__EXPIRY);
                    NoSqlSessionDataStore.NoSqlSessionData data = null;
                    DBObject sessionSubDocumentForContext = (DBObject)MongoSessionDataStore.this.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextField());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("attrs {}", new Object[]{sessionSubDocumentForContext});
                    }
                    if (sessionSubDocumentForContext != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Session {} present for context {}", new Object[]{id, MongoSessionDataStore.this._context});
                        }
                        data = (NoSqlSessionDataStore.NoSqlSessionData)MongoSessionDataStore.this.newSessionData(id, created, accessed, accessed, maxInactive);
                        data.setVersion(version);
                        data.setExpiry(expiry);
                        data.setContextPath(MongoSessionDataStore.this._context.getCanonicalContextPath());
                        data.setVhost(MongoSessionDataStore.this._context.getVhost());
                        data.setLastSaved(lastSaved);
                        data.setLastNode(lastNode);
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        for (String name : sessionSubDocumentForContext.keySet()) {
                            if (MongoSessionDataStore.__METADATA.equals(name)) continue;
                            String attr = MongoSessionDataStore.this.decodeName(name);
                            Object value = MongoSessionDataStore.this.decodeValue(sessionSubDocumentForContext.get(name));
                            attributes.put(attr, value);
                        }
                        data.putAllAttributes(attributes);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Session  {} not present for context {}", new Object[]{id, MongoSessionDataStore.this._context});
                    }
                    reference.set(data);
                }
                catch (Exception e) {
                    exception.set(e);
                }
            }
        };
        this._context.run(r);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return (SessionData)reference.get();
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove:session {} for context ", new Object[]{id, this._context});
        }
        BasicDBObject mongoKey = new BasicDBObject(__ID, (Object)id);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id));
        if (sessionDocument != null) {
            DBObject c = (DBObject)this.getNestedValue(sessionDocument, __CONTEXT);
            if (c == null) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            Set contexts = c.keySet();
            if (contexts.isEmpty()) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            if (contexts.size() == 1 && ((String)contexts.iterator().next()).equals(this.getCanonicalContextId())) {
                this._dbSessions.remove((DBObject)new BasicDBObject(__ID, (Object)id), WriteConcern.SAFE);
                return true;
            }
            BasicDBObject remove = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            unsets.put(this.getContextField(), (Object)1);
            remove.put("$unset", (Object)unsets);
            WriteResult result = this._dbSessions.update((DBObject)mongoKey, (DBObject)remove, false, false, WriteConcern.SAFE);
            return true;
        }
        return false;
    }

    public boolean exists(String id) throws Exception {
        BasicDBObject fields = new BasicDBObject();
        fields.put(__EXPIRY, (Object)1);
        fields.put(__VALID, (Object)1);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id), (DBObject)fields);
        if (sessionDocument == null) {
            return false;
        }
        Boolean valid = (Boolean)sessionDocument.get(__VALID);
        if (!valid.booleanValue()) {
            return false;
        }
        Long expiry = (Long)sessionDocument.get(__EXPIRY);
        if (expiry <= 0L) {
            return true;
        }
        return expiry > System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> doGetExpired(Set<String> candidates) {
        long now;
        long upperBound = now = System.currentTimeMillis();
        HashSet<String> expiredSessions = new HashSet<String>();
        BasicDBObject query = new BasicDBObject();
        query.append(__ID, (Object)new BasicDBObject("$in", candidates));
        query.append(__EXPIRY, (Object)new BasicDBObject("$gt", (Object)0).append("$lt", (Object)upperBound));
        try (DBCursor verifiedExpiredSessions = null;){
            verifiedExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)new BasicDBObject(__ID, (Object)1));
            for (DBObject session : verifiedExpiredSessions) {
                String id = (String)session.get(__ID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Mongo confirmed expired session {}", new Object[]{this._context, id});
                }
                expiredSessions.add(id);
            }
        }
        upperBound = this._lastExpiryCheckTime <= 0L ? now - 3L * (1000L * (long)this._gracePeriodSec) : this._lastExpiryCheckTime - 1000L * (long)this._gracePeriodSec;
        query = new BasicDBObject();
        BasicDBObject gt = new BasicDBObject(__EXPIRY, (Object)new BasicDBObject("$gt", (Object)0));
        BasicDBObject lt = new BasicDBObject(__EXPIRY, (Object)new BasicDBObject("$lt", (Object)upperBound));
        BasicDBList list = new BasicDBList();
        list.add((Object)gt);
        list.add((Object)lt);
        query.append("and", (Object)list);
        try (DBCursor oldExpiredSessions = null;){
            BasicDBObject bo = new BasicDBObject(__ID, (Object)1);
            bo.append(__EXPIRY, (Object)1);
            oldExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)bo);
            for (DBObject session : oldExpiredSessions) {
                String id = (String)session.get(__ID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Mongo found old expired session {}", new Object[]{this._context, id + " exp=" + session.get(__EXPIRY)});
                }
                expiredSessions.add(id);
            }
        }
        return expiredSessions;
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        NoSqlSessionDataStore.NoSqlSessionData nsqd = (NoSqlSessionDataStore.NoSqlSessionData)data;
        BasicDBObject key = new BasicDBObject(__ID, (Object)id);
        BasicDBObject update = new BasicDBObject();
        boolean upsert = false;
        BasicDBObject sets = new BasicDBObject();
        BasicDBObject unsets = new BasicDBObject();
        Object version = ((NoSqlSessionDataStore.NoSqlSessionData)data).getVersion();
        if (lastSaveTime <= 0L) {
            upsert = true;
            version = new Long(1L);
            sets.put(__CREATED, (Object)nsqd.getCreated());
            sets.put(__VALID, (Object)true);
            sets.put(this.getContextSubfield(__VERSION), version);
            sets.put(this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put(this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            sets.put(__MAX_IDLE, (Object)nsqd.getMaxInactiveMs());
            sets.put(__EXPIRY, (Object)nsqd.getExpiry());
            nsqd.setVersion(version);
        } else {
            sets.put(this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put(this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            version = new Long(((Number)version).longValue() + 1L);
            nsqd.setVersion(version);
            update.put("$inc", (Object)this._version_1);
            BasicDBObject fields = new BasicDBObject();
            fields.append(__MAX_IDLE, (Object)true);
            fields.append(__EXPIRY, (Object)true);
            DBObject o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id), (DBObject)fields);
            if (o != null) {
                long currentExpiry;
                Long tmpLong = (Long)o.get(__MAX_IDLE);
                long currentMaxIdle = tmpLong == null ? 0L : tmpLong;
                tmpLong = (Long)o.get(__EXPIRY);
                long l = currentExpiry = tmpLong == null ? 0L : tmpLong;
                if (currentMaxIdle != nsqd.getMaxInactiveMs()) {
                    sets.put(__MAX_IDLE, (Object)nsqd.getMaxInactiveMs());
                }
                if (currentExpiry != nsqd.getExpiry()) {
                    sets.put(__EXPIRY, (Object)nsqd.getExpiry());
                }
            } else {
                LOG.warn("Session {} not found, can't update", new Object[]{id});
            }
        }
        sets.put(__ACCESSED, (Object)nsqd.getAccessed());
        Set<String> names = nsqd.takeDirtyAttributes();
        if (lastSaveTime <= 0L) {
            names.addAll(nsqd.getAllAttributeNames());
        }
        for (String name : names) {
            Object value = data.getAttribute(name);
            if (value == null) {
                unsets.put(this.getContextField() + "." + this.encodeName(name), (Object)1);
                continue;
            }
            sets.put(this.getContextField() + "." + this.encodeName(name), this.encodeName(value));
        }
        if (!sets.isEmpty()) {
            update.put("$set", (Object)sets);
        }
        if (!unsets.isEmpty()) {
            update.put("$unset", (Object)unsets);
        }
        WriteResult res = this._dbSessions.update((DBObject)key, (DBObject)update, upsert, false, WriteConcern.SAFE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Save:db.sessions.update( {}, {},{} )", new Object[]{key, update, res});
        }
    }

    protected void doStart() throws Exception {
        if (this._dbSessions == null) {
            throw new IllegalStateException("DBCollection not set");
        }
        this._version_1 = new BasicDBObject(this.getContextSubfield(__VERSION), (Object)1);
        this.ensureIndexes();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected void ensureIndexes() throws MongoException {
        DBObject idKey = BasicDBObjectBuilder.start().add(__ID, (Object)1).get();
        this._dbSessions.createIndex(idKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        DBObject versionKey = BasicDBObjectBuilder.start().add(__ID, (Object)1).add("version", (Object)1).get();
        this._dbSessions.createIndex(versionKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1_version_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
    }

    private String getContextField() {
        return "context." + this.getCanonicalContextId();
    }

    private String getCanonicalContextId() {
        return this.canonicalizeVHost(this._context.getVhost()) + ":" + this._context.getCanonicalContextPath();
    }

    private String canonicalizeVHost(String vhost) {
        if (vhost == null) {
            return "";
        }
        return vhost.replace('.', '_');
    }

    private String getContextSubfield(String attr) {
        return this.getContextField() + "." + attr;
    }

    protected Object decodeValue(Object valueToDecode) throws IOException, ClassNotFoundException {
        if (valueToDecode == null || valueToDecode instanceof Number || valueToDecode instanceof String || valueToDecode instanceof Boolean || valueToDecode instanceof Date) {
            return valueToDecode;
        }
        if (valueToDecode instanceof byte[]) {
            byte[] decodeObject = (byte[])valueToDecode;
            ByteArrayInputStream bais = new ByteArrayInputStream(decodeObject);
            ClassLoadingObjectInputStream objectInputStream = new ClassLoadingObjectInputStream((InputStream)bais);
            return objectInputStream.readUnshared();
        }
        if (valueToDecode instanceof DBObject) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : ((DBObject)valueToDecode).keySet()) {
                String attr = this.decodeName(name);
                map.put(attr, this.decodeValue(((DBObject)valueToDecode).get(name)));
            }
            return map;
        }
        throw new IllegalStateException(valueToDecode.getClass().toString());
    }

    protected String decodeName(String name) {
        return name.replace("%2E", ".").replace("%25", "%");
    }

    protected String encodeName(String name) {
        return name.replace("%", "%25").replace(".", "%2E");
    }

    protected Object encodeName(Object value) throws IOException {
        if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            return value;
        }
        if (value.getClass().equals(HashMap.class)) {
            BasicDBObject o = new BasicDBObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    o = null;
                    break;
                }
                o.append(this.encodeName(entry.getKey().toString()), this.encodeName(entry.getValue()));
            }
            if (o != null) {
                return o;
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.reset();
        out.writeUnshared(value);
        out.flush();
        return bout.toByteArray();
    }

    private Object getNestedValue(DBObject dbObject, String nestedKey) {
        String[] keyChain = nestedKey.split("\\.");
        DBObject temp = dbObject;
        for (int i = 0; i < keyChain.length - 1; ++i) {
            if ((temp = (DBObject)temp.get(keyChain[i])) != null) continue;
            return null;
        }
        return temp.get(keyChain[keyChain.length - 1]);
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    public String toString() {
        return String.format("%s[collection=%s]", super.toString(), this.getDBCollection());
    }
}

