/*
 * Copyright, 2009 Koichi Takahashi. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.nec.exi.editor.preference;

import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.nec.exi.editor.Activator;
import com.nec.exi.editor.Resources;

/**
 * @author Koichi Takahashi
 */
public class PreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

	public PreferencePage() {
		super(GRID);
		setPreferenceStore(Activator.getDefault().getPreferenceStore());
		setDescription(Resources.get("PreferencePage.1")); //$NON-NLS-1$
	}
	
	public void createFieldEditors() {
		ComboFieldEditor codingMode = new ComboFieldEditor(Activator.CODING_MODE_N, Resources.get("PreferencePage.2"), Activator.CODING_MODE_NV, getFieldEditorParent()); //$NON-NLS-1$
		addField(codingMode);
	}
	
	public void init(IWorkbench workbench) {
	}
	
}