<?php
/*
 Copyright (c) 2003-2004, minahito
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the nor the names of its contributors may be used to 
  endorse or promote products derived from this software without specific 
  prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 SUCH DAMAGE.
*/
	define("CSRFToken_PREFIX","CSRF__");

	class CSRFToken {
		var $action_name_=null;
		var $lifelimit_ =0;
		var $value_=null;
		
		/**
		@param $salt value_ ˺
		*/
		function CSRFToken($action_name,$limit=300,$salt='') {
			$this->action_name_=$action_name;
			$this->lifelimit_=time()+$limit;
			$this->value_=md5($salt.microtime()*100000);
		}
		
		function setSession() {
			// ֤ĤǽΤprefix
			Session::register(CSRFToken_PREFIX.$this->action_name_,$this);
		}
		
		function inquiryValue($value="") {
			Session::unregister(CSRFToken_PREFIX.$this->action_name_);

			if ($value=="") {
				$value= isset($_POST[$this->action_name_]) ?
					$_POST[$this->action_name_] : "";
				if ( $value=="" ) {
					debug("POSTƤʤ");
					print_r($_POST);
					return false;
				}
			}
			
			if ($this->lifelimit_<time()) return false;
			
			if ($this->value_!=$value) return false;

			return true;
		}

		function inquiry ($action_name) {
			debug("{$action_name}ǾȲ򳫻Ϥޤ");
			if (Session::is_registered(CSRFToken_PREFIX.$action_name)) {
				debug("쥸Ȥȯޤ");
				$obj =& Session::get(CSRFToken_PREFIX.$action_name);
				debug(get_class($obj));
				if (get_class($obj)=="csrftoken") {
					return $obj->inquiryValue();
				} else
					return false;
			} else {
				return false;
			}
		}

	}

	/** exBlog ԹΤ褤 CSRFToken 뤿 Factory */
	class exbCSRFTokenFactory {
		/**
		@brief CSRFToken 󥹥󥹤ޤ
		@param action_name ȡ̾
		@param limit ¸³֡á
		@return Ŭڤ˽줿CSRFToken󥹥󥹤֤ޤ
		*/
		function getInstance($action_name,$limit=0) {
			$salt="";
			if ( defined("EXBLOG_TOKEN_SALT"))
				$salt=EXBLOG_TOKEN_SALT;

			if ( !$limit ) {
				if (defined("EXBLOG_TOKEN_LIFETIME"))
					$limit=EXBLOG_TOKEN_LIFETIME;
				else
					$limit=300;
			}

			$prefix="";
			if (defined("EXBLOG_TOKEN_PREFIX"))
				$prefix = EXBLOG_TOKEN_PREFIX;

			$obj = new CSRFToken($prefix.$action_name,$limit,$salt);
			return $obj;
		}
		
		/**
		@brief ǥեȻ̵ͭ˴ؤ餺¸³֣ʬΥȡ֤ޤ
		*/
		function getLongInstance($action_name,$salt='') {
			return $this->getInstance($action_name,30*60,$salt);
		}

		/**
		@brief  prefix ǥȲԤΥ饹᥽å
		@note Υ᥽åɤѻߤ줿ᡢߥåѡȤʤäƤޤ
		*/
		function inquiry($action_name) {
			return CSRFToken::inquiry($action_name);
		}

	}



?>