<?php
/**
@brief XoopsObject & Handler ηѾ/ߴ class Ƥե( class.object.php)
@version $Id: object.php,v 1.1 2004/07/28 11:25:50 minahito Exp $
*/

class exTableInfomation {
	var $tablenames_;
	var $primarykeys_;
	var $extras_;
	var $pk_num_;
	var $merge_;	/**< ɽ */

	function exTableInfomation ( $tbl, $pk, $merge=null, $exts=null ) {
		if(is_array($tbl))
			$this->tablenames_=&$tbl;
		else {
			$this->tablenames_=array();
			$this->tablenames_[]=&$tbl;
		}

		if(is_array($pk))
			$this->primarykeys_=&$pk;
		else {
			$this->primarykeys_=array();
			$this->primarykeys_[]=&$pk;
		}

		if($this->merge_!==null)
			$this->merge_=$merge;

		if($exts!==null) {
			if(is_array($exts)) {
				$this->extras_=&$exts;
			}
			else {
				$this->extras_=array();
				$this->extras_[]=&$exts;
			}
		}

		$this->pk_num_=count($this->primarykeys_);
	}
}


	/**
	@brief ˥åΥ饹᥽åɤä XoopsObject Ѿ饹
	*/
	class exXoopsObject extends XoopsObject {
		/**
		@brief ץѥƥϢ˳Ǽ֤
		@return array
		*/
		function &getArray($type='s') {
			$ret=array();
			foreach (array_keys($this->vars) as $key ) {
				if($type)
					$ret[$key]=$this->getVar($key,$type);
				else
					$ret[$key]=$this->getVar($key,$type);
			}
			return $ret;
		}

		/**
		@brief ǡ¤Ū֤ȤԤ᥽å
		@return array
		@note Ѿ֥ȤǤϡäƤեɤ򡢤ΥǡϢ
		\par ֤ưʤФʤ
		\par ĤޤꡢǼǥ졼ʥǡ١Σ쥳ɤİǤ
		\par ʤФʤȤ褦˼롣
		*/
		function &getStructure($type='s') {
			$ret =& $this->getArray($type);
			return $ret;
		}

		/**
		@brief ϢϤͤ򥻥åȤ᥽åɡXoopsObject  stripSlashesGPC νɲäƤ롣
		@note 󥹥ȥ饯 cleanVars() ¹ԤƤ褤Τ⤷ʤ $strip  false ˤХꥸʥƱưˤʤΤǻȤʬ
		@param $var_arr
		@param $strip bool
		*/
		function assignVars($var_arr,$strip=true)
		{
			foreach($var_arr as $key=>$value) {
				if(get_magic_quotes_gpc() && $strip) {
					$value=&stripslashes($value);
					$this->assignVar($key,$value);
				}
				else {
					$this->assignVar($key,$value);
				}
			}
			
			// $this->cleanVars();
		}
	}

/**
@brief exXoopsObjectHandler ̤ڤǼ뤿Υ饹
@note ܿ꼡ʾ夲
*/
class exXoopsObjectHandler extends XoopsObjectHandler {
	var $db_;
	var $_classname_=null;
	var $_tableinfo_=null;

	function exXoopsObjectHandler($db,$classname=null) {
		$this->db_=&$db;

		if($this->_classname_==null)
			$this->_classname_=$classname;
		if($this->_tableinfo_==null)
			$this->_tableinfo_=&call_user_func(array($classname,'getTableInfo'));
	}

	/**
	@brief 󥹥󥹤򥭥å夹
	FIXME:: null ȤǤȤôݡ getObjects ȤƤϤʤ
	*/
	function _cacheInstance($obj) {
		global $__exobject__cache__;
		if(is_object($obj)){
			$classname=get_class($obj);
			$pk_count=count($this->_tableinfo_->primarykeys_);
			if($pk_count==1)
				$__exobject__cache__[$classname][$obj->getVar($this->_tableinfo_->primarykeys_[0])]=&$obj;
			else {
				// ץ饤ޥ꤬ʣξν
				// FIXME: ̩ʥǥХ
				if(!is_array($__exobject_cache__[$classname]))
					$__exobject_cache__[$classname]=array();

				$p =& $__exobject__cache__[$classname];
				for($i=0;$i<$pk_count;$i++) {
					$keyname=$obj->getVar($this->_tableinfo_->primarykeys_[$i]);
					if($i==($pl_count-1)) {	// ǸǤ
						$p[$keyname]=&$obj;
					}
					else {
						if(!is_array($p[$keyname]))
							$p[$keyname]=array();
						$p=&$p[$keyname];
					}
				}
			}
		}
/*		exFrame::debug("饹̾:".$classname);
		exFrame::debug("ץ饤ޥꥭ:".$pk_count);
		exFrame::debug("Ϥ줿ץ饤ޥꥭ:".$this->_tableinfo_->primarykeys_[0]);
		exFrame::debug($obj->getVar($this->_tableinfo_->primarykeys_[0]));
		exFrame::debug($__exobject__cache__);*/
	}

	function _resetCacheAll() {
		global $__exobject__cache__;
		$__exobject__cache__=array();
	}
	
	function &create($isNew=true) {
		$obj=null;
		if(class_exists($this->_classname_)) {
			$obj=new $this->_classname_();
			if($isNew)
				$obj->setNew();
		}
		return $obj;
	}
	
	function &get() {
		global $__exobject__cache__;

		// 顼
		if($this->_tableinfo_->pk_num_!=func_num_args())
			return null;

		// ץ饤ޥ꡼ҤȤĤΤȤν
		if($this->_tableinfo_->pk_num_==1) {
			$value=func_get_arg(0);
//			exFrame::debug( "Ϳ줿".$value);
			if(isset($__exobject__cache__[$this->_classname_][$value])) {
				return $__exobject__cache__[$this->_classname_][$value];
			}
			else {
				$criteria=new Criteria($this->_tableinfo_->primarykeys_[0],
					$value, "=");
				$obj=&$this->_get($this->_tableinfo_,$criteria);
				$this->_cacheInstance($obj);
				return $obj;
			}
		}
		else {	// դİʾξ
			if(is_array($__exobject__cache__[$this->_classname_])) {
				$p=&$__exobject__cache__[$this->_classname_];
				for($i=0;$i<$this->_tableinfo_->pk_num_;$i++) {
					if($i==($this->_tableinfo_->pk_num_ - 1)) {
						if(isset($p[func_get_arg($i)]))
							return $p[func_get_arg($i)];
					}
					else {
						if(is_array($p[func_get_arg($i)]))
							$p=&$p[func_get_arg($i)];
						else
							break;
					}
				}
			}

			if(!$cache_flag) {
				$criteria = new CriteriaCompo();
				for($i=0;$i<$this->_tableinfo_->pk_num_;$i++) {
					$criteria->add(new Criteria($this->_tableinfo_->primarykeys[$i],
						func_get_arg($i), "="));
				}
				$obj=&$this->_get($this->_tableinfo_,$criteria);
				$this->_cacheInstance($obj);
			}
		}
	}

	function &_get($tinfo,$criteria) {
		$sql="SELECT * FROM ".implode(",",array_map(array($this->db_,'prefix'),$tinfo->tablenames_));
		if($tinfo->merge_)
			$sql.=" WHERE ".$tinfo->merge_." AND ".$criteria->render();
		else
			$sql.=" ".$criteria->renderWhere();

//		exFrame::debug($sql);

		if(!$result=$this->db_->query($sql))
			return false;

		if($this->db_->getRowsNum($result)==1) {
			if($row=$this->db_->fetchArray($result)) {
				$obj = new $this->_classname_();
				$obj->assignVars($row);
				$obj->unsetNew();
				return $obj;
			}
		}

		return null;
	}

	function &getObjects($criteria=null,$id_as_key='',$order=null) {
		global $__exobject__cache__;
		
		$objects =& $this->_getObjects($this->_tableinfo_,$criteria,$order);
		foreach($objects as $o) {
			$this->_cacheInstance($o);
		}
		
		// åϤ id_as_key Ȥʤ?
		if($id_as_key)
			return $__exobject__cache__[$this->classname_];
		else
			return $objects;
	}

	function &getOne($criteria) {
		$objs=&$this->getObjects($criteria);
		if(count($objs)==1)
			if(is_object($objs[0])) return $objs[0];

		return false;
	}

	function &getCount($criteria=null) {
		global $__exobject__cache__;
		
		return $this->_getCount($this->_tableinfo_,$criteria);
	}

	function &_getObjects($tinfo,$criteria,$order) {
		$ret=array();
		$whereflag=false;

		$limit = $start = 0;

		$sql="SELECT * FROM ".implode(",",array_map(array($this->db_,'prefix'),$tinfo->tablenames_));
		if($tinfo->merge_) {
			$sql.=" WHERE ".$tinfo->merge_;
			$whereflag=true;
		}

		if(isset($criteria) && is_subclass_of($criteria,'criteriaelement')) {
			if($whereflag)
				$sql.=" AND ".$criteria->render();
			else
				$sql.=' '.$criteria->renderWhere();
			
			if($criteria->getSort()!='')
				$sql.=' ORDER BY '.$criteria->getSort().' '.$criteria->getOrder();
			elseif($order!=null)
				$sql.=' ORDER BY '.$order;

			$limit=$criteria->getLimit();
			$start=$criteria->getStart();
		}
		elseif($order!=null)
			$sql.=' ORDER BY '.$order;

		$result=$this->db_->query($sql,$limit,$start);
		if(!$result){ return $ret; }

		while($row=$this->db_->fetchArray($result)) {
			$obj = new $this->_classname_();
			$obj->assignVars($row);
			$obj->unsetNew();
			$ret[]=&$obj;
			unset($obj);
		}
		
		return $ret;
	}

	function &_getCount($tinfo,$criteria=null) {
		$whereflag=false;

		$sql="SELECT COUNT(*) c FROM ".implode(",",array_map(array($this->db_,'prefix'),$tinfo->tablenames_));
		if($tinfo->merge_) {
			$sql.=" WHERE ".$tinfo->merge_;
			$whereflag=true;
		}

		if(isset($criteria) && is_subclass_of($criteria,'criteriaelement')) {
			if($whereflag)
				$sql.=" AND ".$criteria->render();
			else
				$sql.=" ".$criteria->renderWhere();
		}

		$result=$this->db_->query($sql);
		if(!$result){ return false; }

		$ret=$this->db_->fetchArray($result);
		
		return $ret['c'];
	}

	function insert(&$obj,$force=false) {
		return $this->_insert($this->_tableinfo_,$obj,$force);
	}
	
	function _insert(&$tinfo,&$obj,$force=false) {
		if(get_class($obj)!=strtolower($this->_classname_))
			return false;

		if(!$obj->isDirty()) return true;
		if(!$obj->cleanVars()) return true;

		foreach($obj->cleanVars as $key => $value) {
			$vars{$key} = $value;
		}
		
		$new_flag=false;
		
		if($obj->isNew()) {
			$new_flag=true;
			$sql = $this->_insert_new($tinfo,$obj,$vars);
		}
		else {
			$sql = $this->_insert_update($tinfo,$obj,$vars);
		}

		if($force!=false) {
			$result=$this->db_->queryF($sql);
		}
		else {
			$result=$this->db_->query($sql);
		}

		if(!$result){
			return false;
		}
		
		// PK ҤȤĤξ˸¤
		if($new_flag && $tinfo->pk_num_>0 ) {
			$id = $this->db_->getInsertId();
			$obj->setVar($tinfo->primarykeys_[0],$id);
		}

		return true;
	}

	function _insert_new(&$tinfo,&$obj,&$vars) {
		$fileds=array();
		$values=array();
		$arr = $this->_makeVars4sql($obj,$vars);
		foreach(array_keys($arr) as $name) {
			$fields[]=$name;
			$values[]=$arr[$name];
		}
		$q=sprintf("INSERT INTO %s ( %s ) VALUES ( %s )",
			$this->db_->prefix($tinfo->tablenames_[0]),
			implode(",",$fields),
			implode(",",$values));

		return $q;
	}

	function _insert_update(&$tinfo,&$obj,&$vars) {
		$set_lists=array();
		$pk_lists=array();
		$values=array();
		$arr = $this->_makeVars4sql($obj,$vars);
		foreach(array_keys($arr) as $name) {
			if(in_array($name,$tinfo->primarykeys_)) {
				$pk_lists[]=$name."=".$arr[$name];
			}
			else {
				$set_lists[]=$name."=".$arr{$name};
			}
		}
		$q=sprintf("UPDATE %s SET %s WHERE %s",
			$this->db_->prefix($tinfo->tablenames_[0]),
			implode(",",$set_lists),
			implode(" AND ",$pk_lists));

		return $q;
	}

	function &_makeVars4sql(&$obj,&$vars) {
		$ret=array();
		foreach(array_keys($obj->vars) as $v) {
			switch($obj->vars[$v]['data_type']) {
				case XOBJ_DTYPE_TXTBOX:
				case XOBJ_DTYPE_TXTAREA:
				case XOBJ_DTYPE_URL:
				case XOBJ_DTYPE_EMAIL:
					$ret[$v]=$this->db_->quoteString($vars[$v]);
					break;
				default:
					$ret[$v]=$vars[$v];
			}
		}
		return $ret;
	}

	/**
	@brief Ϥ줿֥Ȥκ
	@note åΥԥݥȥꥢɬ
	*/
	function delete(&$obj,$force=false) {
		// criteria 
		$criteria = new CriteriaCompo();
		foreach($this->_tableinfo_->primarykeys_ as $pk) {
			$criteria->add(new Criteria($pk,$obj->getVar($pk)));
		}
		return $this->deletes($criteria,$force);
	}
	
	/**
	@brief Criteria Ѥ
	@param $criteria
	*/
	function deletes($criteria,$force=false) {
		$sql = "DELETE FROM ".$this->db_->prefix($this->_tableinfo_->tablenames_[0])." ".$criteria->renderWhere();

		if($force)
			return $this->db_->queryF($sql);
		else
			return $this->db_->query($sql);
	}

} 


?>
