<?php
/**
@brief Notepadѥե
@version $Id: NotepadEditForm.php,v 1.2 2004/07/29 02:26:44 minahito Exp $
*/

// ޤɤ
require_once "exForm/Form.php";

// ץåȥݡͥȤɤǤ
// ɤ߹ޤƤ뤳Ȥ¿Τ require_once Ƥ
require_once "exComponent/Input.php";

// ƤĤȤˤʤΤǡXoopsForm ɤ
require_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

class NotepadEditForm extends exAbstractActionForm
{
	function load($data=null)
	{
		global $xoopsUser;
		
		// ʳϤ
		if(!is_object($xoopsUser)) {
			$this->msg_[]=_MD_BXNOTEPAD_MESSAGE_GUESTCANCEL;
			return;
		}

		$handler=&bxNotepad::getHandler('note');
		$id = isset($_REQUEST['id']) ? $this->getPositive($_REQUEST['id']) : 0;

		// ɤ
		if($id>0)
			$this->data_=&$handler->get($id);

		// Ԥʤ顢 create ǥ󥹥󥹤
		if(!is_object($this->data_)) {
			$this->data_=&$handler->create();

			// 桼ID Υå
			$this->data_->setVar('uid',is_object($xoopsUser) ? $xoopsUser->uid() : 0);
		}
	}

	function doGet($data)
	{
		$this->load();
	}
	
	function doPost($data)
	{
		global $xoopsUser;

		// ɤ⤷ϥ󥹥󥹤κ
		$this->load();

		// fid
		$fid = $this->getPositive($_POST['fid']);
		if($fid>0) {	// 
			$handler=&bxNotepad::getHandler('folder');
			$folder=&$handler->get($fid);
			if(!is_object($folder)) {
				$this->msg_[]="_MD_BXNOTEPAD_ERROR_FOLDER_NOEXISTS";
			}
			else {	// ʬΥեɤ򸡺ޤ
				if(!$xoopsUser->isAdmin() and $xoopsUser->uid()!=$folder->getVar('uid'))
					$this->msg_[]=_MD_BXNOTEPAD_ERROR_FOLDER_DENY;
			}
		}
		$this->data_->setVar('fid',$fid);

		// update_date ɬѹ
		$this->data_->setVar('update_date',time());

		// public ˤ 0  1 ʤ
		$this->data_->setVar('public',($_POST['public']) ? 1 : 0);

		// priority ϳĥͽʤΤǥѥ

		// XoopsObject ǤƤޤ
		$this->data_->setVar('title',$_POST['title']);
		$this->data_->setVar('contents',$_POST['contents']);

		// XoopObject ˤ cleanVars 򤫤
		if(!$this->data_->cleanVars()) {
			// ⤷顼äʤ顢ˤΤǡ$this->msg_ ˥ޡ
			$this->msg_=array_merge($this->msg_,$this->data_->getErrors());
		}
	}
}

class NotepadInputComponentRender extends exInputComponentRender {
	function render()
	{
		global $xoopsUser;

		$form = new XoopsThemeForm('NOTEPAD','notepad',$_SERVER['SCRIPT_NAME'],'POST');

		$form->addElement(new XoopsFormHidden('id',$this->component_->form_->data_->getVar('id')));
		$form->addElement(new XoopsFormText(_MD_BXNOTEPAD_LANG_TITLE,'title',35,35,$this->component_->form_->data_->getVar('title')));

		$folder = new XoopsFormSelect(_MD_BXNOTEPAD_LANG_FOLDER,'fid',$this->component_->form_->data_->getVar('fid'));
		$folder->addOption(0,_MD_BXNOTEPAD_LANG_DEF_FOLDER);

		// եɤǥå
		$handler=&bxNotepad::getHandler('folder');
		$criteria=new Criteria('uid',$xoopsUser->uid());
		$criteria->setSort('priority');
		$folders=&$handler->getObjects($criteria);
		foreach($folders as $f) {
			$folder->addOption($f->getVar('fid'),$f->getVar('name'));
		}
		$form->addElement($folder);

		$public=new XoopsFormSelect(_MD_BXNOTEPAD_LANG_PUBLIC,"public",$this->component_->form_->data_->getVar('public'));
		$public->addOption(0,_MD_BXNOTEPAD_LANG_PRIVATE);
		$public->addOption(1,_MD_BXNOTEPAD_LANG_PUBLIC);
		$form->addElement($public);

		$form->addElement(new XoopsFormDhtmlTextArea(_MD_BXNOTEPAD_LANG_CONTENTS,'contents',$this->component_->form_->data_->getVar('contents','e'),20));

		$form->addElement(new XoopsFormButton('SAVE',"submit","submit","submit"));
		$form->addElement($tray);

		$form->display();
	}
}

?>