<?php
/**
@brief ե륿
@version $Id: NotepadFilter.php,v 1.3 2004/07/29 02:57:51 minahito Exp $
*/

require_once "exForm/Filter.php";

class GuestNotepadFilter extends exAbstractFilterForm
{
	var $uid_=0;
	var $fid_=0;

	function fetch()
	{
		$this->fid_=$this->getPositiveIntger('fid');
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria=$this->getDefaultCriteria($start,$limit);
		$criteria->add(new Criteria('public',1));
		if($this->fid_)
			$criteria->add(new Criteria('fid',$this->fid_));
		return $criteria;
	}

	function getDefaultCriteria($start=0,$limit=0)
	{
		$criteria=new CriteriaCompo();
		$criteria->setSort('update_date');
		$criteria->setOrder('DESC');
		return $criteria;
	}
	
	function getExtra()
	{
		$ret =array();
		$ret['fid']=$this->fid_;
		return $ret;
	}
}

class UserNotepadFilter extends GuestNotepadFilter
{
	function fetch()
	{
		global $xoopsUser;
		parent::fetch();
		$this->uid_=$xoopsUser->uid();
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria=$this->getDefaultCriteria($start,$limit);
		$criteria->add(new Criteria('uid',$this->uid_));
		$criteria->add(new Criteria('fid',$this->fid_));
		return $criteria;
	}
}

?>