<?php
/**
@version $Id: Form.php,v 1.7 2004/07/22 13:55:09 minahito Exp $
*/

define ( "ACTIONFORM_INIT_FAIL", '__error__actionform_init_fail__' );
define ( "ACTIONFORM_INIT_SUCCESS", '__actionform_init_success__' );
define ( "ACTIONFORM_POST_SUCCESS", '__actionform_post_success__' );

/**
@brief 
@note exAbstractForm Ⱥ礹ǽ礤ˤΤǤĥʤǲ
*/
class exAbstractFormObject {
	var $msg_;
	var $err_render_=null;

	function exAbstractFormObject() {
		$this->msg_=array();
		$this->err_render_=new exFormErrorRender();
	}

	function isError() {
		return count($this->msg_);
	}

	function getHtmlErrors() {
		$this->err_render_->init($this);
		return $this->err_render_->render();
	}
}

/**
@brief ( AbstractBase)
*/
class exAbstractForm extends exAbstractFormObject {
	var $data_;
	
	function init($data=null) {
		if($data) {
			$this->data_=&$data;
		}
		if($_SERVER['REQUEST_METHOD']=='POST') {
			$this->doPost($data);
			return count($this->msg_) ? ACTIONFORM_INIT_FAIL : ACTIONFORM_POST_SUCCESS;
		}
		elseif($_SERVER['REQUEST_METHOD']=='GET') {
			$this->doGet($data);
			return count($this->msg_) ? ACTIONFORM_INIT_FAIL : ACTIONFORM_INIT_SUCCESS;
		}
		else {
			return ACTIONFORM_INIT_FAIL;
		}
		
	}

	function doGet($data) { }

	function doPost($data) { }

	function initSelf() {
		$dmy=null;
		return $this->init($dmy);
	}
}

class exAbstractActionForm extends exAbstractForm {

	function validateInRange($intValue,$min,$max) {
		return ($intValue>=$min && $intValue<=$max);
	}

	function validateMaxLength($value,$max) {
		return (strlen($value)<=$max);
	}

	function validateMinLength($value,$min) {
		return (strlen($value)>=$min);
	}

	function validatePositive($value) {
		return (intval($value)>0);
	}

	function validateHttpUrl($value) {
		return (strpos($value,"http://")===0 or strpos($value,"https://")===0);
	}

	function getPositive($value) {
		$ret=intval($value);
		if($ret<=0)
			return 0;
		else
			return $ret;
	}
}

/**
@brief AbstractForm ϤΥ󥹥󥹤ץѥƥ msg Ѥåɽʤ󶡤 class
*/
class exFormErrorRender {
	var $form_=null;

	function init($form) {
		$this->form_=$form;
	}

	function render() {
		$ret ="<ul>";
		foreach($this->form_->msg_ as $m) {
			$ret.=@sprintf("<li><font color='red'>%s</font></li>\n",$m);
		}
		$ret .="</ul>";
		return $ret;
	}
}

?>