<?php
/**
@version $Id
*/

class exXMLHandler
{
	var $version_;
	var $encode_;
	var $child_;
	
	function exXMLHandler($encode='iso-8859-1', $version='1.0')
	{
		$this->encode_=$encode;
		$this->version_=$version;
		$this->child_=array();
	}

	function add($node)
	{
		$this->child_[]=$node;
	}

	function &render()
	{
		$ret=array();
		$ret[]='<?xml version="'.$this->version_.'" encoding="'.$this->encode_.'"?>';

		if(count($this->child_)>0) {
			$tmp=array();
    		foreach($this->child_ as $c) {
    			$tmp=$c->render();
        		foreach($tmp as $t) {
        			$ret[]="\t".$t;
        		}
    		}
		}

		return implode("\n",$ret);
	}
}

class exXMLNode
{
	var $name_;
	var $elements_;
	var $child_;
	var $value_;
	
	function exXMLNode($name,$elements=null,$value=null)
	{
		$this->name_=$name;
		$this->child_=array();
		$this->value_=$value;
	}
	
	function add($node)
	{
		$this->child_[]=$node;
	}

	function &render()
	{
		$ret=array();

		// ҥΡɤн
		if(count($this->child_)>0) {
			$ret[]="<".$this->name_.">";
			$tmp=array();
    		foreach($this->child_ as $c) {
    			$tmp=$c->render();
        		foreach($tmp as $t) {
        			$ret[]="\t".$t;
        		}
    		}
			$ret[]="</".$this->name_.">";
		}
		elseif($this->value_) {	// ʤ value 
			$ret[]="<".$this->name_.">".$this->value_."</".$this->name_.">";
		}
		else {
			$ret[]="<".$this->name_." />";
		}


		return $ret;
	}
}

?>