<?php
/**
XML Ƥ
*/

require_once "include/XMLLoader.php";

/* @{ @name פ򼨤 */
define("TBANY_SEND_MAPPING_DATABASE",1);
define("TBANY_SEND_MAPPING_PLUGIN",2);
/* @} */

class tbanyXMLLoader extends AbstractXMLLoader
{
	var $pathflag_=false;
	var $pathfind_flag_=false;
	var $path_=null;
	var $params_=array();

	function propertyOepnTagHandler($arr)
	{
		if($arr['path']==$this->path_) {
			$this->pathfind_flag_=true;
			$this->pathflag_=true;
		}
	}

	function propertyCloseTagHandler($arr)
	{
		$this->pathflag_=false;
	}

	function paramOepnTagHandler($arr)
	{
		if($this->pathflag_)
			$this->params_[$arr['name']]=$arr['value'];
	}

}

/**
@brief ɤ߹ XML 
*/
class tbanySendXMLLoader extends AbstractXMLLoader
{
	var $pathflag_=false;
	var $pathfind_flag_=false;

	var $type_=TBANY_SEND_MAPPING_DATABASE;
	
	var $tables_=array();
	var $merge_=array();

	var $title_="";
	var $excerpt_="";

	var $query_map_flag_=false;
	var $query_field_mappings_ = array();	///< ꡼ȥ󥰤 SQL Υޥåԥ󥰾

	function propertyOepnTagHandler($arr)
	{
		if($arr['path']==$this->path_) {
			$this->pathfind_flag_=true;
			$this->pathflag_=true;
		}
	}

	function propertyCloseTagHandler($arr)
	{
		$this->pathflag_=false;
	}
	
	function query_field_mappingOpenTagHandler($arr)
	{
		$this->query_map_flag_ = true;
	}

	function query_field_mappingCloseTagHandler($arr)
	{
		$this->query_map_flag_ = false;
	}
	
	function paramOpenTagHandler($arr)
	{
		if($this->query_map_flag_) {
			$table = isset($arr['table']) ? $arr['table'] : null;
			$this->query_field_mappings_[$arr['query']] = array (
				'table' => $table,
				'field' => $arr['field'] );
		}
	}

	function typeOepnTagHandler($arr)
	{
		if($this->pathflag_) {
			switch(strtolower($arr['value'])) {
				case "database_mapping":
					$this->type_=TBANY_SEND_MAPPING_DATABASE;
					break;
			}
		}
	}

	function tableOepnTagHandler($arr)
	{
		if($this->pathflag_)
			$this->tables_[] = $arr['name'];
	}

	function mergeOepnTagHandler($arr)
	{
		if($this->pathflag_) {
			$tmp = array();
			$count=0;
			foreach($arr as $name=>$val) {
				$tmp[$count++]=$name.".".$val;
			}
			$this->merge_[] = $tmp;
		}
	}

	function titleOepnTagHandler($arr)
	{
		if($this->pathflag_)
			$this->title_ = $arr;
	}

	function excerptOepnTagHandler($arr)
	{
		if($this->pathflag_)
			$this->excerpt_ = $arr;
	}

	function extraOepnTagHandler($arr)
	{
		if($this->pathflag_) {
			$this->extra_[] = $arr;
		}
	}
}

?>