<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     myalbumtitle
 * Version:  1.0
 * Date:     Mar 17, 2005
 * Author:   minahito <minahito@users.sourceforge.jp>
 * Purpose:  return category title by 'cid'
 * Input:    cid = category id
 *           mod_url = please set <{$mod_url}>, this function need it for myalbum duplicatable feature.
 * 
 * Examples: {myalbumtitle mod_url=<{$mod_url}> cid=<{$category_id}>}
 * -------------------------------------------------------------
 */
function smarty_function_myalbumtitle($params, &$smarty)
{
	global $xoopsDB;
	$modulename ="myalbum";	// module name
	$ret = "";	// return value ( display value )

	// check module name for duplicatable feature.
	if(isset($params['mod_url'])) {
		if(preg_match("#".XOOPS_URL."/modules/(\w+)/#",$params['mod_url'],$match)) {
			$modulename = $match[1];
		}
	}

	// if set cid then execute SQL Query.
	if(isset($params['cid'])) {
		$tablename = $xoopsDB->prefix($modulename."_cat");
		$sql = "SELECT title FROM $tablename WHERE cid=".intval($params['cid']);
		$res = $xoopsDB->query($sql);
		if($res) {
			$row = $xoopsDB->fetchArray($res);
			if($row)
				$ret = $row['title'];
		}
	}

	print $ret;
}

?>
