<?php
/**
@file
@brief ץԽΤΥեե
@author minahito
@version $Id$
*/

require_once "exForm/Form.php";

/**
@brief ץԽΤΥե
*/
class EditProjectForm extends exActionForm
{
	var $id_;				///< ץ ID
	var $title_;			///< ץ̾
	var $path_;			///< ץȤΥѥ
	var $use_mbstring_;	///< ޥХȴؿѤ뤫ɤ
	var $to_encode_;		///< Ѵʸ
	var $form_encode_;		///< Ѵʸ
	var $description_;		///< 

	function fetch() {
		$this->id_ = intval($_POST['id']);

		$this->title_ = trim($_POST['title']);
		if(!$this->validateMinLength($this->title_,1))
			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_REQUIRED,_MD_A_XOXYGEN_LANG_TITLE));

		if(!$this->validateMaxLength($this->title_,255))
			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_SIZEOVER,_MD_A_XOXYGEN_LANG_TITLE,255));
		
		$this->path_ = trim($_POST['path']);
		if(!$this->validateMinLength($this->path_,1))
			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_REQUIRED,_MD_A_XOXYGEN_LANG_PATH));

		// եå
		if($this->path_) {
			$path = "";
			if(substr($this->path_,0,1)!="/")
				$path = XOOPS_ROOT_PATH."/".$this->path_;
			else
				$path = $this->path_;
			
			if(!file_exists($path."/index.html"))
				$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_INVALID_PATH,$path));
		}

		if(!$this->validateMaxLength($this->path_,255))
			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_SIZEOVER,_MD_A_XOXYGEN_LANG_PATH,255));

		$this->use_mbstring_ = $_POST['use_mbstring'] ? 1 : 0;

		$this->to_encode_ = trim($_POST['to_encode']);
		if(!$this->validateMaxLength($this->to_encode_,64))
			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_SIZEOVER,_MD_A_XOXYGEN_LANG_TO_ENCODE,64));

		$this->from_encode_ = trim($_POST['from_encode']);
		if(!$this->validateMaxLength($this->from_encode_,64))
			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_SIZEOVER,_MD_A_XOXYGEN_LANG_FROM_ENCODE,64));

		// ޥХȴؿȤʤ to_encode  from_encode ɬϤǤ
		if($this->use_mbstring_) {
    		if(!$this->validateMinLength($this->to_encode_,1))
    			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_REQUIRED,_MD_A_XOXYGEN_LANG_TO_ENCODE));
    		if(!$this->validateMinLength($this->from_encode_,1))
    			$this->addError(@sprintf(_MD_A_XOXYGEN_MESSAGE_REQUIRED,_MD_A_XOXYGEN_LANG_FROM_ENCODE));
		}

		$this->description_ = $_POST['description'];
	}

	/**
	@brief Project DataObject ꤳΥեΥФۤ
	@param $master XoxygenProjectObject Υ󥹥
	*/
	function load(&$master) {
		$this->id_ = $master->getVar("id");
		$this->title_ = $master->getVar("title");
		$this->path_ = $master->getVar("path");
		$this->use_mbstring_ = $master->getVar("use_mbstring");
		$this->to_encode_ = $master->getVar("to_encode");
		$this->from_encode_ = $master->getVar("from_encode");
		$this->description_ = $master->getVar("description",'e');
	}

	/**
	@brief Project DataObject ˤΥեξ򥻥åȤ
	@param $master XoxygenProjectObject Υ󥹥
	*/
	function update(&$master) {
		$master->setVar("id",$this->id_);
		$master->setVar("title",$this->title_);
		$master->setVar("path",$this->path_);
		$master->setVar("use_mbstring",$this->use_mbstring_);
		$master->setVar("to_encode",$this->to_encode_);
		$master->setVar("from_encode",$this->from_encode_);
		$master->setVar("description",$this->description_);
	}
}


?>