<?php

require_once "exForm/Filter.php";

class xpToDoIndexFilter extends exAbstractFilterForm
{
	var $id_;
	var $uid_=0;
	var $active_=null;
	var $sort_=array("id","uid","subject","description","input_date","active");

	var $action_;	// for mojaLE.

	function fetch()
	{
		$this->action_=isset($_REQUEST['action']) ? trim($_REQUEST['action']) : "";
		$this->uid_ = isset($_GET['uid']) ? intval ( $_GET['uid'] ) : null;
		$this->active_ = isset($_GET['active']) ? intval ( $_GET['active'] ) : null;
		
		if(!$this->validateInRange($this->active_,0,1))
			$this->active_=null;
	}

	function &getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria=&$this->getSortCriteria($start,$limit,$sort);
		
		if ( $this->uid_ )
			$criteria->add(new Criteria('uid',$this->uid_));

		if ( $this->active_!==null )
			$criteria->add(new Criteria('active',$this->active_));

		return $criteria;
	}

	function &getDefaultCriteria($start,$limit)
	{
		$criteria =& parent::getDefaultCriteria($start,$limit);
		$criteria->setSort('input_date');
		$criteria->setOrder('DESC');

		return $criteria;
	}
	
	function &getExtra()
	{
		// set array
		//  GET ꥯȤǥե륿郎Ѥ褦Ϣ򥻥åȤޤ
		$ret=array();
		$ret['action']=$this->action_;
		if($this->uid_)
			$ret['uid'] = $this->uid_;
		if($this->active_)
			$ret['active'] = $this->active_;

		return $ret;
	}

}


?>