<?php

require_once "xoops/object.php";

class xpToDoTodoObject extends exXoopsObject {
	function xpToDoTodoObject($id=null)
	{
		$this->initVar('id', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('subject', XOBJ_DTYPE_TXTBOX, null, true, 255);
		$this->initVar('description', XOBJ_DTYPE_TXTAREA, null, false, null);
		$this->initVar('input_date', XOBJ_DTYPE_INT, time(), false);
		$this->initVar('total_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('active', XOBJ_DTYPE_INT, 1, false);
		$this->initVar('lock_id', XOBJ_DTYPE_INT, 0, false);

		if ( is_array ( $id ) )
			$this->assignVars ( $id );
	}

	/**
	@brief ȡ֤׻ޤ
	@remark SQL Ѥޤ
	@return boolean
	*/
	function updateTotalTime()
	{
		global $xoopsDB;
		$sql = "SELECT sum(work_time) as total FROM ".$xoopsDB->prefix('xptodo_log')." WHERE id=".$this->getVar('id');
		$res=$xoopsDB->query($sql);
		if(!$res)
			return false;

		if($row=$xoopsDB->fetchArray($res))
			$this->setVar("total_time", $row['total']);

		return true;
	}

	/**
	@brief ȡ֤֤ޤ
	*/
	function getTotalTime()
	{
		$ret =array();
		$total_time = $this->getVar('total_time');
		$ret['day'] = intval($total_time / 3600);
		$ret['hour'] = intval(($total_time-$ret['day']*3600*60)/3600);
		$ret['min'] = intval(($total_time-$ret['day']*3600*60-$ret['hour']*3600)/60);
		return $ret;
	}

	function &getStructure($type='s',$format="%d Day(s) %d:%d")
	{
		$ret = parent::getStructure($type);
		if(defined('_MD_XPTODO_LANG_ACTIVE'))
			$ret['status_str'] = $ret['active'] ? _MD_XPTODO_LANG_ACTIVE : _MD_XPTODO_LANG_DEACTIVE;
		else
			$ret['status_str'] = $ret['active'] ? _MD_A_XPTODO_LANG_ACTIVE : _MD_A_XPTODO_LANG_DEACTIVE;

   		$tmp=$this->getTotalTime();
   		$ret['total_time_str']=@sprintf($format,$tmp['day'],$tmp['hour'],$tmp['min']);

		return $ret;
	}

	/// Database Connect Model
	function &getTableInfo()
	{
		$tinfo = new exTableInfomation('xptodo_todo','id');
		return ($tinfo);
	}
}
?>