<?php
/**
 * @author minahito
 * version $Id: ContactMailBuilder.class.php,v 1.3 2005/05/24 16:23:49 minahito Exp $
 */

/**
 * 󥿥Ȥ줿 XoopsMailer 󥹥󥹤˹ۤӥ
 */
class AbstractContactMailBuilder
{
	function &createMail()
	{
		$mail =& getMailer();
		$mail->setTemplateDir($this->_getTemplateDir());
		$this->settingMail($mail);
		return $mail;
	}
	

	/**
	 * ᡼Żҥ᡼뤫 PM 뤫ꤹ
	 */
	function settingMail(&$mail)
	{
		$mail->useMail();
	}
	
	function writeMail(&$mail,&$editform)
	{
		$this->writeToInfomation($mail,$editform);
		$this->writeFromInfomation($mail,$editform);
		$this->writeSubject($mail,$editform);
		$this->writeBody($mail,$editform);
	}

	function _getTemplateDir()
	{
		global $xoopsModule, $xoopsConfig;
		return XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname()."/language/".$xoopsConfig['language']."/mail_template/";
	}
	
	function _getTemplateFilename()
	{
		return "";
	}

	/**
	 * 򥻥åȤ
	 */	
	function writeToInfomation(&$mail,&$editform)
	{
	}

	/**
	 * 򥻥åȤ
	 */
	function writeFromInfomation(&$mail,&$editform)
	{
	}
	
	function writeSubject(&$mail,&$editform)
	{
	}

	function writeBody(&$mail,&$editform)
	{
		global $xoopsConfig;
		
		// Mail 󥹥󥹤Υƥץ졼Ȥꤹ
		$mail->setTemplate($this->_getTemplateFilename());
		$mail->assign('SITENAME', $xoopsConfig['sitename']);
		$mail->assign('ADMINMAIL',$xoopsConfig['adminmail']);
		$mail->assign('SITEURL', XOOPS_URL."/");
		$mail->assign('USER_AGENT', $_SERVER['HTTP_USER_AGENT']);

		// ե򥢥󤵤󥹥󥹤ΥˤбƤʤΤǡ
		// Ϣǥ󤹤
		$mail->assign($editform->getArray());
	}
}

/**
 * ԸΥ᡼ۤӥ
 */
class ContactAdminMailBuilder extends AbstractContactMailBuilder
{
	function writeToInfomation(&$mail,&$editform)
	{
		global $xoopsConfig;
		$mail->setToEmails($xoopsConfig['adminmail']);
	}

	function writeFromInfomation(&$mail,&$editform)
	{
		global $xoopsConfig;
		$mail->setFromEmail($editform->email_);
		$mail->setFromName($xoopsConfig['sitename']);
	}
	
	function writeSubject(&$mail,&$editform)
	{
		global $xoopsConfig;
		$mail->setSubject($xoopsConfig['sitename']." - "._CT_CONTACTFORM);
	}
	
	/**
	 * get mail_template file name
	 * 
	 * @return string
	 */
	function _getTemplateFilename()
	{
		return "admin_mail.tpl";
	}
}

/**
 * 桼ֿ᡼ۤӥ
 */
class ContactUserMailBuilder extends ContactAdminMailBuilder
{
	function writeToInfomation (&$mail,$editform)
	{
		$mail->setToEmails($editform->email_);
	}

	function writeSubject(&$mail,&$editform)
	{
		$mail->setSubject(_CT_THANKYOU);
	}

	function _getTemplateFilename()
	{
		return "user_mail.tpl";
	}
}

?>