<?php

require_once $_ENV['XOOPS_ROOT_PATH']."/modules/exFrame/include/XMLLoader.php";

class DBObjectXML
{
	var $name_;
	var $type_;
	var $fields_;
	var $table_name_;

	function DBObjectXML($name=null,$type="exXoopsObject")
	{
		$this->fields_=array();
		$this->name_ = $name;
		$this->type_=$type;
	}
	
	function getTableName()
	{
		return $this->table_name_;
	}
	
	/**
	@biref ʰŪˡȤ
	@note ʣбƤޤ
	*/
	function getPrimaryKey()
	{
		foreach($this->fields_ as $field)  {
			if($field->primary_)
				return $field->name_;
		}
		return null;
	}
	
	/**
	@brief ꤵ줿 XML եɤ߹ߤޤ
	*/
	function load($file)
	{
		$xml = new DBObjectXMLParser();
		$xml->load($file);
		if($xml->isError()) {
			die ("Error XML");
		}
		
		$this->name_ = $xml->name_ ? $xml->name_ : $this->name_;
		$this->type_ = $xml->type_ ? $xml->type_ : $this->type_;
		$this->fields_ = $xml->fields_;

		if($xml->table_name_)
			$this->table_name_ = $xml->table_name_;
	}

	function fetchXML()
	{
		$ret=array();
		$ret[]=@sprintf("<object name=\"%s\" type=\"%s\">",
					$this->name_, $this->type_);
		
		$ret[]=@sprintf("\t<tablename>%s</tablename>",$this->table_name_);

		foreach($this->fields_ as $field) {
			if($field->isActive()) {
    			$freeze="";
    			if($field->freeze_)
    				$freeze = ' freeze="'.$field->freeze_.'"';
    			$ret[]=@sprintf("\t<field name=\"%s\" type=\"%s\"%s>",$field->name_,$field->type_,$freeze);
    
    			if($field->size_!==null) {
    				$ret[]="\t\t<size>".$field->size_."</size>";
    			}
    
    			if($field->primary_) {
    				$ret[]="\t\t<primarykey>yes</primarykey>";
    			}
    			if($field->required_) {
    				$ret[]="\t\t<required>yes</required>";
    			}
    			
    			if($field->default_) {
    				$ret[]=sprintf("\t\t<default type=\"%s\">%s</default>",$field->default_type_,$field->default_);
    			}
    			elseif($field->default_type_=="numeric") {
    				$ret[]=sprintf("\t\t<default type=\"%s\">0</default>",$field->default_type_);
    			}
			}

			$ret[]="\t</field>";
		}

		$ret[]="</object>";
		
		return $ret;
	}
	
	function addField($field)
	{
		$this->fields_[] = $field;
	}
	
	/**
	@brief Ʊ̾Υեɤʤ˸¤ꡢaddField ޤ
	@param $override ΤȤ̾󥯥ޤ
	*/
	function addFieldIfNotExist($field,$override=false)
	{
		$filed = $this->getFieldByName($field->name_);
		if(!$field) {
			print"addField ... ".$field->name_."\n";
			$this->addField($field);
		}
		elseif($override){
			$this->syncField($field);
		}
	}
	
	/**
	@brief ꤷ¸Υեɤѹޤ¸ߤʤ addField 򥳡뤷ޤ
	@remark required/default Ѳޤ󡣤ޤ¸ߤƤ硢Υեɤ setActive ˤѤޤ
	*/
	function syncField(&$field)
	{
		$my_field=&$this->getFieldByName($field->name_);
		if(!$my_field) {
			$this->addField($field);
		}
		else {
   			$my_field->setActive();
    		if(!$my_field->freeze_) {
    			$my_field->type_=$field->type_;
    			$my_field->size_=$field->size_;
    			$my_field->primary_=$field->primary_;
    		}
		}
	}

	function setDeactiveAllField()
	{
		foreach(array_keys($this->fields_) as $key)
			$this->fields_[$key]->setDeactive();
	}

	function &getFieldByName($name)
	{
		$ret =null;
		foreach(array_keys($this->fields_) as $key)
		{
			if($this->fields_[$key]->name_ == $name)
				return $this->fields_[$key];
		}

		return $ret;
	}
}

class DBObjectField
{
	var $lock_ = null;

	var $name_ =null;
	var $type_ =null;
	var $size_ =null;
	var $required_ =null;
	var $required_from_ =null;
	var $primary_ =null;
	var $default_ =null;
	var $default_type_ ="numeric";
	
	var $active_ = true;
	
	var $freeze_ = false;

	function buildByMysqlRow(&$row)
	{
		$this->name_ = $row['Field'];
		$this->type_ = MysqlStructure::convertXoopsObjectType($row['Type']);
		$this->size_ = MysqlStructure::fetchSizeFromField($row['Type']);
		$this->value_ = "";
		if($row['Key']=="PRI")
			$this->primary_ = true;
		$this->required_ = ($row['Null']=="YES") ? false : true;
			
		$this->default_type_ = DBObjectUtil::getDefaultType($this->type_);
		if($this->default_type_=="numeric")
			$this->default_=intval($row['Default']);
		else
			$this->default_=$row['Default'];
	}
	
	function isActive()
	{
		return $this->active_;
	}
	
	function setActive()
	{
		$this->active_=true;
	}

	function setDeactive()
	{
		$this->active_=false;
	}

	function generateInitCode()
	{
		$generater=null;
		switch($this->type_) {
			case "XOBJ_DTYPE_INT":
				$generater = new IntFieldCodeGenerater($this);
				break;

			case "XOBJ_DTYPE_TXTBOX":
				$generater = new TextboxFieldCodeGenerater($this);
				break;

			case "XOBJ_DTYPE_TXTAREA":
				$generater = new TextareaFieldCodeGenerater($this);
				break;
		}
		
		return $generater ? $generater->generateInitVar() : null;
	}
}

class AbstractFieldCodeGenerater
{
	var $master_;
	
	function AbstractFieldCodeGenerater(&$field)
	{
		$this->master_=$field;
	} 
	
	function generateInitVar()
	{
	}
}

class IntFieldCodeGenerater extends AbstractFieldCodeGenerater
{
	function generateInitVar()
	{
		$ret=@sprintf("\$this->initVar('%s', XOBJ_DTYPE_INT, %s, %s);",
			$this->master_->name_,
			$this->master_->default_ ? $this->master_->default_ : 0,
			$this->master_->required ? "true" : "false" );
		return $ret;
	}
}

class TextareaFieldCodeGenerater extends AbstractFieldCodeGenerater
{
	function generateInitVar()
	{
		$ret=sprintf("\$this->initVar('%s', XOBJ_DTYPE_TXTAREA, %s, %s, null);",
			$this->master_->name_,
			$this->master_->default_ ? '"'.$this->master_->default_.'"' : "null",	// ʸˤʤäƤ
			$this->master_->required_ ? "true" : "false" );
		return $ret;
	}
}

class TextboxFieldCodeGenerater extends AbstractFieldCodeGenerater
{
	function generateInitVar()
	{
		$ret=@sprintf("\$this->initVar('%s', XOBJ_DTYPE_TXTBOX, %s, %s, %d);",
			$this->master_->name_,
			$this->master_->default_ ? '"'.$this->master_->default_.'"' : "null",	// ʸˤʤäƤ
			$this->master_->required_ ? "true" : "false",
			$this->master_->size_ );
		return $ret;
	}
}


class DBObjectUtil
{
	function getDefaultType($xobj_type)
	{
		switch ($xobj_type) {
			case 'XOBJ_DTYPE_INT':
				return "numeric";
				break;

			case 'XOBJ_DTYPE_TXTBOX':
				return "string";
				break;

			case 'XOBJ_DTYPE_TXTAREA':
				return "string";
				break;
		}

		return "string";
	}

	
}

class DBObjectXMLParser extends AbstractXMLLoader
{
	var $name_ ="";
	var $type_ ="";
	
	var $table_name_;
	
	var $active_field_ = null;
	var $fields_=array();
	
	function objectOpenTagHandler($arr)
	{
		$this->name_ = $arr['name'];
		$this->type_ = $arr['type'];
	}
	
	function fieldOpenTagHandler($arr)
	{
		$this->active_field_ = new DBObjectField;

		$this->active_field_->name_ = $arr['name'];
		$this->active_field_->type_ = $arr['type'];
		if(isset($arr['freeze']))
			$this->active_field_->freeze_ = ($arr['freeze']=="true" || $arr['freeze']==1) ? $arr['freeze'] : null;
	}
	
	function fieldCloseTagHandler()
	{
		$this->fields_[] =& $this->active_field_;
		unset($this->active_field_);
	}

	function primarykeyDataHandler($val)
	{
		$val=strtolower($val);
		if($val=="yes" || $val=="true")
			$this->active_field_->primary_=true;
	}
	
	function sizeDataHandler($val)
	{
		$this->active_field_->size_=$val;
	}
	
	function defaultOpenTagHandler($arr)
	{
		$this->active_field_->default_type_=$arr['type'];
	}
	
	function defaultDataHandler($val)
	{
		$this->active_field_->default_=$val;
	}
	
	function requiredDataHandler($val)
	{
		$val = strtolower($val);
		if($val=="yes" || $val=="true") {
			$this->active_field_->required_=true;
		}
	}
	
	function tablenameDataHandler($val)
	{
		$this->table_name_ = $val;
	}
	
	function characterData(&$parser,$val)
	{
		if(trim($val)) {
			$method = $this->tag_."DataHandler";
			
    		if(method_exists($this,$method)) {
    			$this->$method(trim($val));
    		}
		}
	}
}

?>
