<?php
/**
@file
@brief ߡ XoopsObject ե
@version $Id$
*/

define('XOBJ_DTYPE_TXTBOX',1);
define('XOBJ_DTYPE_TXTAREA',2);
define('XOBJ_DTYPE_INT',3);
define('XOBJ_DTYPE_URL',4);
define('XOBJ_DTYPE_EMAIL',5);
define('XOBJ_DTYPE_ARRAY',6);
define('XOBJ_DTYPE_OTHER',7);
define('XOBJ_DTYPE_SOURCE',8);
define('XOBJ_DTYPE_STIME',9);
define('XOBJ_DTYPE_MTIME',10);
define('XOBJ_DTYPE_LTIME',11);

/**
@brief ƥʥߥåե˴Ť fetch ɤ뤿Υ롼δ쥯饹
*/
class FieldRule {
	var $name_;
	var $type_;
	var $init_val_;
	var $required_;
	var $rule_val_;
	
	function FieldRule($name,$type,$init_val,$required,$rule_val='')
	{
		$this->name_=$name;
		$this->type_=$type;
		$this->init_val_ = $init_val;
		$this->required_ = $required;
		$this->rule_val_=$rule_val;
	}

	function fetchFetch($tab,$define_prefix)
	{
		return "";
	}

	function fetchFetch_filter($tab)
	{
		return "";
	}
}

class FieldRuleINT extends FieldRule
{
	function fetchFetch($tab,$define_prefix)
	{
		$ret=array();
		$ret[] = $tab."\$this->".$this->name_."_ = intval(\$request->Params_['".$this->name_."']);";
		if($this->required_) {
			$ret[] = $tab."if(!\$this->".$this->name_."_) {";
			$ret[] = $tab."\t\$this->addError(".$define_prefix."_ERROR_".strtoupper($this->name_)."_REQUIRED);";
			$ret[] = $tab."}";
		}
		return implode("\n",$ret)."\n";
	}

	function fetchFetch_filter($tab)
	{
		$ret=array();
		$ret[] = $tab."\$this->".$this->name_."_ = isset(\$_GET['".$this->name_."']) ? intval(\$_GET['".$this->name_."']) : null;";

		return implode("\n",$ret)."\n";
	}
}

class FieldRuleTXTBOX extends FieldRule
{
	function fetchFetch($tab,$define_prefix)
	{
		$ret=array();
		$ret[] = $tab."\$this->".$this->name_."_ = \$request->Params_['".$this->name_."'];";
		if($this->required_) {
			$ret[] = $tab."if(!\$this->".$this->name_."_) {";
			$ret[] = $tab."\t\$this->addError(".$define_prefix."_ERROR_".strtoupper($this->name_)."_REQUIRED);";
			$ret[] = $tab."}";
		}

		// sizeå
		if($this->rule_val_) {
			$ret[] = $tab."if(!\$this->validateMaxLength(\$this->".$this->name_."_, ".$this->rule_val_.")) {";
			$ret[] = $tab."\t\$this->addError(".$define_prefix."_ERROR_".strtoupper($this->name_)."_SIZEOVER);";
			$ret[] = $tab."}";
		}

		return implode("\n",$ret)."\n";
	}

	function fetchFetch_filter($tab)
	{
		$ret=array();
		$ret[] = $tab."\$this->".$this->name_."_ = isset(\$_GET['".$this->name_."']) ? trim ( \$_GET['".$this->name_."'] ) : null;";

		return implode("\n",$ret)."\n";
	}
}

class FieldRuleTXTAREA extends FieldRule
{
	function fetchFetch($tab,$define_prefix)
	{
		$ret=array();
		$ret[] = $tab."\$this->".$this->name_."_ = \$request->Params_['".$this->name_."'];";
		if($this->required_) {
			$ret[] = $tab."if(!\$this->".$this->name_."_) {";
			$ret[] = $tab."\t\$this->addError(".$define_prefix."_ERROR_".strtoupper($this->name_)."_REQUIRED);";
			$ret[] = $tab."}";
		}
		return implode("\n",$ret)."\n";
	}

	function fetchFetch_filter($tab)
	{
		$ret=array();
		$ret[] = $tab."\$this->".$this->name_."_ = isset(\$_GET['".$this->name_."']) ? trim ( \$_GET['".$this->name_."'] ) : null;";

		return implode("\n",$ret)."\n";
	}
}

/**
@brief exFrame ʤ exXoopsObject ηѾ饹Ǥ褦ˤ뤿δ쥯饹
@remark Υ饹ϡexXoopsObject ΤѤ뤪줬᥽åɤߡǼƤۤ
		ե༫ưΤΥ᥽åɤޤ
*/
class exXoopsObject
{
	var $fields_;
	
	function exXoopsObject($id=null)
	{
		$this->fields_ = array();
	}
	
	function initVar($name,$type,$init_val,$required,$rule_val='')
	{
		$obj=null;
		switch($type) {
			case XOBJ_DTYPE_INT:
				$obj = new FieldRuleINT($name,$type,$init_val,$required,$rule_val);
				break;

			case XOBJ_DTYPE_TXTBOX:
				$obj = new FieldRuleTXTBOX($name,$type,$init_val,$required,$rule_val);
				break;

			case XOBJ_DTYPE_TXTAREA:
				$obj = new FieldRuleTXTAREA($name,$type,$init_val,$required,$rule_val);
				break;
		}
		$this->fields_[$name]=&$obj;
	}
	
	/**
	@brief Ѿ饹򥨥顼ˤʤΥߡ᥽å
	*/
	function assignVars($dmy)
	{
		return null;
	}
	
	/**
	@brief 饹Υʬ
	*/
	function fetchMember($tab)
	{
		$ret = array();
		foreach($this->fields_ as $key=>$val) {
			$ret[]=$tab."var \$".$key."_;";
		}
		return implode("\n",$ret);
	}
	
	function fetchFetch($tab,$define_prefix)
	{
		$ret = array();
		foreach($this->fields_ as $key=>$val) {
			$ret[] = $val->fetchFetch($tab,$define_prefix);
		}
		return implode("\n",$ret);
	}

	/**
	@brief ե륿Ѥ fetch ᥽åɤ
	*/
	function fetchFetch_filter($tab)
	{
		$ret = array();
		foreach($this->fields_ as $key=>$val) {
			$ret[] = $val->fetchFetch_filter($tab);
		}
		return implode("",$ret);
	}

	function fetchLoad($tab)
	{
		$ret = array();
		foreach($this->fields_ as $key=>$val) {
			$ret[]=$tab."\$this->".$key."_=\$master->getVar('".$key."', 'e');";
		}
		return implode("\n",$ret);
	}

	function fetchUpdate($tab)
	{
		$ret = array();
		foreach($this->fields_ as $key=>$val) {
			$ret[]=$tab."\$master->setVar('".$key."', \$this->".$key."_);";
		}
		return implode("\n",$ret);
	}

	/**
	@brief Ф򥫥ޤǶڤäƽФ
	*/
	function fetchSort()
	{
		$arr=array();
		foreach($this->fields_ as $key=>$val) {
			$arr[]='"'.$key.'"';
		}
		return implode(",",$arr);
	}
	
	function fetchGetCriteria($tab)
	{
		$ret=array();
		foreach($this->fields_ as $key=>$val) {
			$ret[]=$tab."// ".$key." Criterion";
			$ret[]=$tab.@sprintf("if ( \$this->%s_ )",$key);
			$ret[]=$tab.@sprintf("\t\$criteria->add(new Criteria('%s',\$this->%s_));",$key,$key);
			$ret[]="";
		}
		return implode("\n",$ret);
	}

	function fetchGetExtra($tab)
	{
		$ret=array();
		foreach($this->fields_ as $key=>$val) {
			$ret[]=$tab."if(\$this->".$key."_)";
			$ret[]=$tab.@sprintf("\t\$ret['%s'] = \$this->%s_;",$key,$key);
		}
		return implode("\n",$ret);
	}

	function fetchGetValueAtCallback($tab)
	{
		$ret=array();
		foreach($this->fields_ as $key=>$val) {
			$ret[]=$tab."function getValueAt".ucfirst($key)."(\$arr)";
			$ret[]=$tab."{";
			$ret[]=$tab."\treturn \$arr['".$key."'];";
			$ret[]=$tab."}";
			$ret[]="";
		}
		return implode("\n",$ret);
	}
}

?>