// $Id: extwiki.js 3 2010-10-02 14:56:27Z mashiki $
Ext.onReady(function(){
	var XC=Ext.util.Cookies, XG=Ext.grid, XF=Ext.form;
	Ext.state.Manager.setProvider(new Ext.state.CookieProvider());
	Ext.QuickTips.init();
	var target = window.location.href.match(/^([^?#]*)([^#]*)(.*)$/);
	var P = XC.get('custom_conf')||'{}';
	P = Ext.apply(ExtWikiConf, Ext.util.JSON.decode(P));

	P.dirWiki = P.UrlWiki.replace(/[^/]*$/, '');
	P.dir     = target[1].replace(/[^/]*$/, '');
	P.UrlWiki0= target[1];
	P.anchor0 = target[3];
	Ext.BLANK_IMAGE_URL = P.UrlExtWiki+'/s.gif';

	// 履歴用フィールド追加と初期化
	Ext.DomHelper.append(
		'hidden_div', {
			tag:  'form',
			children: [{tag:'input',id:'x-history-field'},{tag:'iframe',id:'x-history-frame'}]
		}
	);
	Ext.History.init(function(){
		this.addX = function(token, preventDup){this.lastAdd=token;this.add(token, preventDup)};
		if(Ext.isIE) this.addX('init')
	});
	var stl = Ext.getDom('theme');
	stl.href = stl.href.replace(/xtheme-[^\/]+[.]css$/,'xtheme-'+P.Theme+'.css');

	// wikiPanelクラス定義
	WikiPanel = Ext.extend(Ext.Panel, {
		constructor: function(config) {
			this.pageinfo = config.pageinfo;
			WikiPanel.superclass.constructor.apply(this, arguments);
		},
		getPageInfo: function(key) {
			return !key?this.pageinfo:(this.pageinfo[key]||'');
		}
	});

	// extwikiオブジェクトの定義
	var extwiki = {
		version: '1.4  $Rev: 3 $'.replace(/ \$/g,''),
		defaultPage: '',
		lastClick: null,
		request: function() {
			var cntReq=0;
			return function(obj) {
				++cntReq;
				Ext.get(document.body).mask('ページ読み込み中', 'x-mask-loading');
				obj.timeout = P.Timeout*1000;
				obj.failureX = obj.failure;
				obj.successX = obj.success;
				delete obj.failure;
				delete obj.success;
				obj.callback = function(opt, success, res) {
					if (--cntReq<=0) Ext.get(document.body).unmask();
					if (!success) {
						res.err_type = 'request';
					} else {
						if (res.responseText.match(/^<pre>(.*)<\/pre>$/)) // patch Ext3.0 bug
							res.responseText = res.responseText.replace(/^<pre>|<\/pre>$/g, '');
						try {
							res.decode = Ext.util.JSON.decode(res.responseText);
						} catch(e) {
							res.err_type = 'json';
						}
						res.err_type = !res.decode?'json'
									:(!res.decode.success?'app':false);
					}
					res.err_type? obj.failureX(res, opt)
							: obj.successX(res.decode, opt);
				} // obj.success 定義
				Ext.Ajax.request(obj);

			}
		}(), //request
		makeDiv: function(html) {
			var el = Ext.DomHelper.append(
				'hidden_div',
				{
					tag:  'div',
					html: html
				},
				true // returnElement
			);
			// リンクの処理を設定する (関数を定義しているのは第2パラメータ渡さないため)
			el.select('a').each(function(el){extwiki.setLinkAction(el)});
			// フォームのactionをセットする
			el.select('form').each(
				function(el) {
					el.on('submit', extwiki.postForm, null, {stopEvent:true});
				} // setFormAction
			);
			// サブミットボタンの処理
			extwiki.lastClick = null;
			el.select('input').each(
				function(e) {
					if (e.dom.type=='submit') {
						e.on(
							'click', 
							function(a,submit,c){
								extwiki.lastClick = submit;
							},
							null,
							{stopEvent:false}
						);
					}
				}
			);
			return el;
		}
		,
		loadPluginPage: function(p) { // read を含めたプラグインのページの処理
			var action = ('plugin' in p)?p.plugin:(('cmd' in p)?p.cmd:'read');

			// read の場合は再利用可能かどうか確認する
			if (action=='read' && !p.reload) {
				if (!p.page) p.page = extwiki.defaultPage;
				for (var i=0,pnl; pnl=tab_panel.items.items[i]; ++i) {
					if (p.page==pnl.getPageInfo('page') && action==pnl.getPageInfo('action')) {
						// ヘッダ部の表示とタブのアクティブ化とアンカー処理
						tab_panel.activate(pnl);
						this.goAnchor(p.anchor);
						return;
					}
				}
			}

			if (action=='template') {
				p.refer = p.page;
				delete p.page;
			}
			
			p.x_cmd  = action;
			delete p.cmd;
			delete p.plugin;

			if (p.mode) {
				p.x_mode = p.mode;
				delete p.mode;
			}
			var url = P.UrlWiki+'?cmd=extwiki&mode=getPage';
			for (var key in p) {
				url += '&'+key+'='+p[key];
			}

			// 新ページの読み込み
			extwiki.request({
				url: url,
				x_action: action,
				x_anchor: p.anchor,
				x_page: p.page,
				success: extwiki.makePagePanel,
				failure: extwiki.onRequestFail
			});
		}  // loadPluginPage
		,
		postForm: function(ev,form,c) { // formの内容をPOSTする
			var el, name, action;
			page = '';
			var params = Ext.urlDecode(form.action.replace(/^.*[?]/,''), true);
			if (params.cmd) {
				action = params.cmd;
				delete params.cmd;
			}
			if (params.plugin) {
				action = params.plugin;
				delete params.plugin;
			}
			if (params.mode) {
				params.x_mode = params.mode;
				delete params.plugin;
			}
			var cntSubmit=0;
			for (var i=0; el=form.elements[i]; i++) {
				name = el.name;

				if (!el.disabled && name) {
					if (name=='plugin' || name=='cmd') {
						el.name = 'xx_' + name;
						action  = el.value;
					} else if (name=='mode') {
						el.name = 'x_mode';
					} else if (name=='page') {
						page = el.value.replace(/^\[\[(.*)\]\]$/, '$1');
					}
					if (el.type=='submit') {
						++cntSubmit;
						if (extwiki.lastClick && name==extwiki.lastClick.name){
							params[name] = extwiki.lastClick.value;
						}
						el.name = 'xx_' + name;
					}
				}
			}
			if (!extwiki.lastClick && cntSubmit>1) {
				// 複数submitがありlastClickがセットされていなければ無視
				return;
			}
			
			// x_cmdにセット
			params.x_cmd  = action;
			// 新ページの読み込み
			extwiki.request({
				method: 'POST',
				url: P.UrlWiki+'?cmd=extwiki&mode=postForm',
				params: params,
				form:form,
				x_page: page,
				x_action: action,
				x_anchor: '',
				success: extwiki.makePagePanel,
				failure: extwiki.onRequestFail
			});
			for (var i=0; el=form.elements[i]; i++) {
				el.name = el.name.replace(/^xx_/,'');
			}
		}  // postForm
		,
		removePanel: function(page, action) {
			var panels = tab_panel.items.items;
			// 同アクションと同ページが既にロードされていれば削除
			for (var i=panels.length-1; i>=0; --i) {
				var pi=panels[i].getPageInfo();
				if (page==pi.page && action==pi.action) {
					tab_panel.remove(i);
				}
			}
		}
		,
		makePagePanel: function(result, opt){
			var panels = tab_panel.items.items;
			var res = result.data;

			// デフォルトページのセット
			if (opt.x_action=='read' && res.fDefault) {
				extwiki.defaultPage = res.page;
			}

			if (res.body=='') {
				Ext.Msg.confirm(
					'アクション「'+opt.x_action+'」の結果',
					res.title+'<br />ページの再表示をしますか',
					function (btn) {
						if (btn=='yes') {
							extwiki.loadPluginPage({page:res.page,reload:true});
						}
					}
				);
				return;
			}

			// 同アクションと同ページが既にロードされていれば削除
			extwiki.removePanel(res.page, opt.x_action );

			// パネルが最大数を超えたなら一番古いパネルを消す
			if (panels.length>=P.MaxTabs) {
				var old_lastdisp = panels[0].getPageInfo('lastdisp');
				for (var idx=1,old_idx=0; idx<panels.length; ++idx) {
					var lastdisp = panels[idx].getPageInfo('lastdisp');
					if (lastdisp<old_lastdisp) {
						old_idx = idx;
						old_lastdisp = lastdisp;
					}
				}
				tab_panel.remove(old_idx);
			}

			// ページ内容セットとパネルの作成
			var contentEl = extwiki.makeDiv(res.body);
			if (res.newtemplate) {
				// name="msg"の textarea を探してinnerHTMLをセットする
				contentEl.select('textarea').each(function(el){
					if (el.dom.name=='msg') {
						el.dom.value = res.newtemplate;
					}
				});
			}
			var newpanel = new WikiPanel({
				title: res.title,
				contentEl: contentEl,
				closable: true,
				autoScroll: true,
				bodyStyle: 'padding: 5',
				pageinfo: {
					page: res.page,
					action: opt.x_action,
					writable: res.writable,
					update: res.update,
					cntTotal: res.cntTotal,
					cntToday: res.cntToday,
					cntYesterday: res.cntYesterday,
					lastdisp:0
				}
			});
			tab_panel.activate(tab_panel.add(newpanel)); // 残りの処理はaddのイベントハンドラに

			// アンカーの確認と移動
			extwiki.goAnchor(opt.x_anchor);
			if (panels.length==1) {
				extwiki.redraw(); // 一番最初だけresizeを発生させる
			}
		} // makePagePanel
		,
		onRequestFail:function(res, opt) {
			var pnl = tab_panel.getActiveTab();
			if (res.err_type=='request') {
				Ext.Msg.alert(
					'通信エラー',
					'「'+opt.url+'」への通信でエラーが発生しました<br />'
					+Ext.util.JSON.encode(res)
				);
			} else if (res.err_type=='app') {
				if (res.decode.reason=='PageNotFound' && (opt.x_action=='read' || opt.x_action=='edit')) {
					extwiki.confirmWithResult(
						'ページ読み込み',
						res.decode.message+'<br />新規ページとして作成しますか？',
						res,
						[{
							text:'yes',
							handler:function(b,e){
								extwiki.loadPluginPage({plugin:'newpage',page:opt.x_page,refer:pnl?pnl.getPageInfo('page'):''});
								b.ownerCt.ownerCt.ownerCt.close();
							}
						},'-',{
							text:'no',
							handler:function(b,e){
								b.ownerCt.ownerCt.ownerCt.close();
							}
						}]
					);
					if (!extwiki.initInfo.sync && opt.x_action=='read' && opt.page!=P.DefaultPage) {
						extwiki.loadPluginPage({cmd:'read'});
					}
				} else {
					extwiki.confirmWithResult(
						'ページ読み込み',
						'ページの読み込みに失敗しました'+ (res.decode.message?'<br />'+ res.decode.message:''),
						res
					);
				}
			} else if (opt.params && (
					(opt.params.x_cmd=='edit' && opt.params.write )
					||opt.params.x_cmd=='tracker'
					||opt.params.x_cmd=='pcomment'
				)) {
				if (res.responseText=="\n") {
					Ext.Msg.alert(
						'編集保存エラー',
						'ページ「'+opt.x_page+'」の保存で空の改行が戻りました<br />'
						+'スパムと見なされてエラーとなった可能性があります'
					);
				} else extwiki.confirmWithResult(
					'編集結果',
					'ページ'+(opt.x_page?'「'+opt.x_page+'」':'')+'の編集はおそらく成功しました。<br />'
						+'編集ページを閉じてページをリロードしますか？',
					res,
					[{
						text:'yes',
						handler:function(b,e){
							tab_panel.remove(pnl);
							extwiki.loadPluginPage({page:pnl.getPageInfo('page'),reload:true});
							b.ownerCt.ownerCt.ownerCt.close();
						}
					},'-',{
						text:'no',
						handler:function(b,e){
							b.ownerCt.ownerCt.ownerCt.close();
						}
					}]
				);
			} else if (opt.params && opt.params.x_cmd=='edit' && opt.params.cancel) {
				tab_panel.remove(pnl);
			} else if (opt.params && opt.params.x_cmd=='rename' && opt.form && opt.form.pass) {
				var refer = opt.form.refer.value;
				extwiki.confirmWithResult(
					'名前変更結果',
					'名前変更の結果<br />変更前のタブ「'+ refer +'」を閉じて、新しい名前「'+ opt.x_page +'」を開きますか',
					res,
					[{
						text:'yes',
						handler:function(b,e){
							var panels = tab_panel.items.items;
							var pages=[];
							// アクションがrenameのタブを削除
							for (var i=panels.length-1,pnl; pnl=panels[i]; --i) {
								if (pnl.getPageInfo('action')=='rename') {
									pages.push(pnl.getPageInfo('page'));
									tab_panel.remove(i);
								}
							}
							// 元ページを削除
							for (var i=pages.length-1; page=pages[i]; --i) {
								extwiki.removePanel(page, 'read');
							}
							extwiki.loadPluginPage({page:opt.x_page,reload:true});
							b.ownerCt.ownerCt.ownerCt.close();
						}
					},'-',{
						text:'no',
						handler:function(b,e){
							b.ownerCt.ownerCt.ownerCt.close();
						}
					}]
				);
			} else {
	 			extwiki.confirmWithResult(
					'想定外の結果',
					'サーバーから想定外の結果が返されました',
					res
				);
			}
		} // onRequestFail
		,
		dispMenuPanel: function(fReload) {  // メニューの表示
			extwiki.request({
				url: P.UrlWiki+'?cmd=extwiki&mode=getTreeList&page=:ExtMenuBar',
				x_action: 'read',
				x_page: ':ExtMenuBar',
				failure: extwiki.onRequestFail,
				success: function(result){
					menu_panel.items.each(function(item){menu_panel.remove(item)});
					for (var i=0,top; top=result.data[i]; ++i) {
						// ツリーパネル作成
						var root = new Ext.tree.TreeNode({text:top.text});
						addNodes(root, top.menu?top.menu.items:[{"acttype":"menu","text":"NoMenu"}]);
						var tp = new Ext.tree.TreePanel({
							title:top.text,
							iconCls:'ewi_'+top.iconCls,
							rootVisible: false,
							autoScroll: true,
							root: root
						});
						// ノードをツリーに追加
						menu_panel.add(tp);
					}

					if (fReload) {
						menu_panel.syncSize();
					} else {
						extwiki.redraw();
					}

					function addNodes(parent, childs) {
						for (var i=0; i<childs.length; ++i) {
							//childs[i]よりnodeを作成
							var node = new Ext.tree.TreeNode({
								iconCls:'ewi_'+childs[i].iconCls,
								text:childs[i].text,
								qtip:childs[i].tooltip,
								leaf:!childs[i].menu,
								acttype:childs[i].actType
							});
							// node をparentに追加
							parent.appendChild(node);

							// click した時の動作をセット
							node.on(
								'click',
								function(p) {
									return function(){extwiki.itemHandler(p)}
								}(childs[i]),
								null,
								{stopEvent:true}
							);

							// もしnodeに子ノードがあれば追加する
							if (childs[i].menu && childs[i].menu.items.length>0) {
								addNodes(node, childs[i].menu.items);
							}
						}
					} //addNodes
				} //success
			});
		} // dispMenuPanel
		,
		loadToolBar: function() { // ツールバー作成
			extwiki.request({
				url: P.UrlWiki+'?cmd=extwiki&mode=getTreeList&page=:ExtToolBar',
				x_action: 'read',
				x_page: ':ExtToolBar',
				failure: extwiki.onRequestFail,
				success: function(result){
					// クリックイベントとアイコンの設定
					var res = result.data;
					for (var ii=0; ii<res.length; ++ii) {
						recurciveSet(res[ii]);
						tab_panel.getTopToolbar().add(res[ii]);
					}
					extwiki.redraw();

					function recurciveSet(item) {
						if (item.iconCls) item.iconCls = 'ewi_'+item.iconCls;
						item.handler = function(p){
							return function(){extwiki.itemHandler(p)}
						}(item);
						if (item.menu && item.menu.items) {
							for (var ii=0; ii<item.menu.items.length; ++ii) {
								recurciveSet(item.menu.items[ii]);
							}
						}
					}					
				}
			});
		} // loadToolBar
		,
		confirmWithResult: function (title, message, res, bbar) {
			if (!bbar) bbar = [{
				text:'Ok',
				handler:function(b,e){b.ownerCt.ownerCt.ownerCt.close();}
			}];
			// window表示。サイズ(512,384)変更可能。closable。自動スクロールバー
			(new Ext.Window({
				title: title,
				width : 512,
				height: 384,
				resizable : true,
				closable: true,
				modal: true,
				autoScroll: true,
				layout: 'border',
				items: [{
					region: 'north',
					height: 60,
					html:message,
					bbar: bbar
				},{
					region: 'center',
					xtype: 'tabpanel',
					activeTab: 0,
					items: [{
						title: 'image',
						contentEl: extwiki.makeDiv(res.responseText),
						autoScroll:true
					},{
						title: 'source',
						html: res.responseText.replace(/&/g,'&amp;').replace(/</g,'&lt;'),
						autoScroll:true
					}]
				}]
			})).show();
		} //confirmWithResult
		,
		itemHandler: function(item) {
			if (item=='-' || item.acttype=='menu') { // do nothing
			} else if (item.acttype=='link') {
				extwiki.doLinkAction(item.params.url);
			} else if (item.acttype=='plugin') {
				var p = {}; //オブジェクトをコピーして渡す
				for (var k in item.params) p[k] = item.params[k];
				if (p.page=='.') { 
					p.page = tab_panel.getActiveTab().getPageInfo('page');
				}
				if (item.external) {
					var pp = '';
					for (var key in p) {
						pp += '&'+key+'='+p[key];
					}
					window.open(P.UrlWiki+'?'+pp.substr(1));
				} else {
					extwiki.loadPluginPage(p); 
				}
			} else { // if (item.acttype=='extwiki') 
				if (item.params.extwiki=='about') {
					Ext.Msg.alert(
						'バージョン情報',
						'<b>ExtWiki: '+ extwiki.version +'</b><br />'
						+'<br /><br />'
						+'pukiwiki: '+ P.PukiwikiVer +'<br />'
						+'ExtJS: '+Ext.version
					);
				} else if (item.params.extwiki=='home') {
					extwiki.loadPluginPage({page:''});
				} else if (item.params.extwiki=='newpage') {
					Ext.Msg.prompt(
						'新規ページ',
						'ページ名を入力してください',
						function (btn, text) {
							if (btn=='ok'){
								var pagename = tab_panel.getActiveTab().getPageInfo('page');
								text = text.replace(/^\.\.\//, (pagename.match(/^.+%2F/i)||[''])[0]);
								text = text.replace(/^\.\//, pagename+'/');
								extwiki.loadPluginPage({plugin:'newpage',page:text,refer:pagename});
							}
						}
					);
				} else if (item.params.extwiki=='pukiwiki') {
					var tab = tab_panel.getActiveTab();
					var url = P.UrlWiki + '?cmd=read&page='+((tab && tab.getPageInfo('page'))||extwiki.defaultPage);
					if (item.external) {
						window.open(url);
					} else {
						window.location.href = url; 
					}
				} else if (item.params.extwiki=='reload') {
					extwiki.reload();
				} else if (item.params.extwiki=='customize') {
					extwiki.customize();
				} else {
					alert('この機能は未実装です：'+item.params.extwiki);
				}
			}
		} // itemHandler
		,
		setLinkAction: function(el, url) {  // リンククリック時の動作変更
			if (!(url = url || el.dom.href)) return; // urlがなく、hrefがあればそれを使用する
			// クリックイベントの処理を変更
			el.on(
				'click',
				function(p){
					return function(){extwiki.doLinkAction(p)};
				}(url),
				null,
				{stopEvent:true}
			);
		}
		,
		doLinkAction: function(url) {  // リンクの実行
			var purl = url.match(/^([^?#]*)([^#]*)(.*)$/);
			if ((purl[1]!=P.UrlWiki && purl[1]!=P.UrlWiki0) ) { // 外部サイトへのリンク
				window.open(purl[0]);
				return;
			}
			var p = getParms(purl[2]);
			p.cmd = p.cmd || p.plugin || 'read';
			if (p.cmd=='read' && !p.page) {
				p.page = P.DefaultPage;
			}
			var tab = tab_panel.getActiveTab();
			if (tab && ( // ページ内のアンカー と 自ページへのリンク(read)
				p.cmd=='extwiki' && p.mode=='extwiki'
				|| p.page==tab.getPageInfo('page') && p.cmd=='read' && tab.getPageInfo('action') == 'read'
			)) {
				extwiki.goAnchor(purl[3]);
			} else { // read以外のプラグイン または 別ページへのリンク
				if (p.openfile || (p.cmd=='attach' && p.pcmd=='open')) {
					window.open(purl[0]);
					return;
				}
				if (purl[3]!='') p.anchor = purl[3];
				extwiki.loadPluginPage(p);
			}
		} // doLinkAction
		,
		goAnchor: function(anchor) {  // アンカーへ移動
			var tab = tab_panel.getActiveTab();
			if ( tab && anchor) {
				tab.body.select(anchor).each(function(el){
					tab.body.scrollTo('top', el.getTop(false)-tab.body.getTop(false),true);
				});
			}
		} // goAnchor
		,
		initInfo: {}
		,
		redraw: function(key) {
			tab_panel.syncSize();
			menu_panel.syncSize();
		}
		,
		reload: function() {
			var pagename = tab_panel.getActiveTab().getPageInfo('page');
			// ページ作成
			extwiki.loadPluginPage({page:pagename,reload:true});
			extwiki.dispMenuPanel(true);
		}
		,
		// ユーザ別設定画面表示
		customize: function(){
			if (extwiki.winCustomize) {
				extwiki.winCustomize.show();
				return;
			}
			var st = new Ext.data.JsonStore({
				// store configs
				autoDestroy: true,
				autoLoad: true,
				url: P.UrlWiki + '?cmd=extwiki&mode=getConfig',
				// reader configs
				root: 'data',
				idProperty: 'name',
				fields: ['name', 'type', 'value', {name:'siteDefault',mapping:'value'}, 'title', 'comment','reg','min','max','customizable'],
				listeners: {load: function(s,r,o){
					editors = [];
					s.each(function(r){
						if (P[r.data.name]) r.set('value', P[r.data.name]);
						var e;
						switch(r.get('type')) {
						case 'int':
							e = new XG.GridEditor(new XF.NumberField({
								allowBlank: false,
								maxValue: r.get('max'),
		//						maxText: r.get('max')+'以下の数値を指定してください',
								minValue: r.get('min'),
		//						minText: r.get('min')+'以上の数値を指定してください',
								selectOnFocus: true,
								style:'text-align:left;'
							}));
							break
						case 'bool':
							e =  new XG.GridEditor(
								new XF.Field({
									autoCreate: {tag: 'select', children: [
										{tag: 'option', value:'true', html: 'True'},
										{tag: 'option', value:'false', html: 'False'}
									]},
									getValue: function(){return this.el.dom.value=='true'}
								}),
								{autoSize: 'both'}
							);
							break;
						case 'string':
							var reg = r.get('reg');
							if (reg.match(/^[-\|_a-zA-Z0-9]+$/)) {
								var opts = reg.split('|')
								for (var i=0,opt;opt=opts[i];++i) {
									opts[i] = {tag: 'option', value:opt, html: opt};
								}
								e = new XG.GridEditor(
									new XF.Field({
										autoCreate: {tag: 'select', children: opts}
									}),
									{autoSize: 'both'}
								);
							} else {
								e = new XG.GridEditor(new XF.TextField({
									selectOnFocus: true,
									regex: new RegExp('^'+reg+'$')
								}));
							}
							break;
						}
						r.set('editor', e);
					});
					this.commitChanges();
					this.filterBy(function(r,i){return r.get('customizable')});
				}}
			});

			var rndr = function(tag) {
				return function(v, m, r) {
					return r.get('customizable')?'<'+tag+'>'+v+'</'+tag+'>':v
				}
			}
			extwiki.winCustomize = new Ext.Window({
				minHeight: 200,
				minWidth: 400,
				height: 300,
				width: 600,
				maxPct: 70,
				modal: true,
				title: 'ユーザ別セッティング項目',
				closable:true,
				closeAction:'hide',
				layout: 'fit',
				items: {
					xtype: 'editorgrid',
					store: st,
					viewConfig: {forceFit:true},
					enableColumnMove: false,
					enableHdMenu: false,
					stripeRows: true,
					trackMouseOver: false,
					sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
					clicksToEdit: 1,
					cm: new XG.ColumnModel({
						getCellEditor: function(ci,ri) {
							var row = st.getAt(ri);
							return row.data.editor;
						},
						isCellEditable: function(col, row) {
							return this.columns[col].dataIndex=='value' && st.getAt(row).get('customizable');
						},
						columns: [
							{ sortable:true, header:'設定項目', dataIndex :'title', width: 105},
							{ sortable:true, header:'name',  dataIndex :'name',  width: 55, align:'right', renderer:rndr('b')},
							{ sortable:true, header:'値', dataIndex:'value', width:70,
										editable:true, renderer:rndr('u')},
							{ sortable:true, header:'デフォルト', dataIndex :'siteDefault', width: 70},
							{ sortable:true, header:'備考', dataIndex :'comment', width: 120}
						]
					})
				},
				tbar: [{
					text: 'Save',
					handler: function(b, e){
						var cc={};
						st.each(function(r){
							var d = r.data;
							if (d.value!=d.siteDefault) cc[d.name] = d.value;
						});
						cc = Ext.util.JSON.encode(cc);
						XC.set('custom_conf', cc, (new Date).add(Date.DAY, 45));
						Ext.Msg.alert(
							'ユーザ設定の保存',
							'ユーザ設定の保存が完了しました。<br />'+
							'設定を反映するには[Ctrl]+[f5]でリロードしてください。',
							function(b, t){ extwiki.winCustomize.hide(); }
						);
					}
				},'-',{
					text: 'Reset',
					handler: function(b, e){
						st.each(function(r){
							r.set('value', r.data.siteDefault);
						});
					}
				},'-',{
					text: 'Display',
					menu:[{
						text: 'All',
						handler: function(b, e){
							st.filterBy(function(r,i){return true});
						}
					},'-',{
						text: 'Editable',
						handler: function(b, e){
							st.filterBy(function(r,i){return r.get('customizable')});
						}
					}]
				},'-',{
					text: 'Cancel',
					handler: function(b, e){
						extwiki.winCustomize.hide();
					}
				}]
			});
			extwiki.winCustomize.show();
		}

	}; // extwiki

	// メインパネル
	var tab_panel = new Ext.TabPanel({
		region:'center',
		tabPosition:P.TabPosition,
		enableTabScroll: true,
		deferredRender:false,
		tbar:[],
		listeners:{
			tabchange: {
				fn: function(tp, pnl) {
					var pi = pnl && pnl.getPageInfo();
					if (!pi) return; // ダミーページ
					Ext.History.addX(pnl.id); // 履歴追加
					// 最終参照日時の更新
					pi.lastdisp = new Date();

					// ヘッダ部表示
					document.title = pnl.title + '  --  ' + P.SightName;
					Ext.getDom('top_title').innerHTML = pnl.title;
					Ext.getDom('top_count').innerHTML = pi.cntTotal;
					Ext.getDom('top_today').innerHTML = pi.cntToday;
					Ext.getDom('top_yesterday').innerHTML = pi.cntYesterday;
					Ext.getDom('top_url').innerHTML = P.UrlWiki +'?'+ pi.page;
					Ext.getDom('top_url').href = P.UrlWiki +'?'+ pi.page;
					
					if (pi.update!='-') {
						var date = new Date(pi.update);
						date = date.format((date>(new Date)-10*24*60*60*1000)?'m/d H:i':'Y/m/d');
					} else {
						date = '-';
					}
					Ext.getDom('top_update').innerHTML = date;

					// 編集可/不可によるToolBarの制御
					setDisable(tp.getTopToolbar().items);
					function setDisable(items) {
						items.each(function(item) {
							if (item.ctledit) {
								if ( item.ctledit==(pi.writable?'enable':'disable') ) {
								 	item.enable();
								} else if ( item.ctledit==(pi.writable?'disable':'enable') ) {
								 	item.disable();
								}
							}
							if (item.menu) {
								setDisable(item.menu.items);
							}
						});
					}
				}
			} // tabchange
		}
	}); // tab_panel

	var position = {top:'north',bottom:'south',left:'west',right:'east'};
	var menu_panel = new Ext.Panel({ // 左側メニュー
		region:position[P.MenuPosition],
		id:'west-panel',
		split:true,
		width: 200,
		minSize: 100,
		maxSize: 400,
		collapsible: true,
		collapseMode:'mini',
		margins:0,
		layout:'accordion',
		layoutConfig:{
		    animate:true
		}
	});

	// ページ全体のレイアウト
	var viewport = new Ext.Viewport({
		layout:'border',
		items:[
			{	// 上部ヘッダエリア
				contentEl:'north',
				region:'north',
				height:53
			},{
				region:'center',
				layout:'border',
				items:[menu_panel,tab_panel]
			}
		]
	}); // viewport

	// ロゴのリンク修正
	Ext.getDom('logo_url').innerHTML = P.SightName;
	Ext.getDom('logo_url').title = 'トップページへ';
	Ext.getDom('logo_url').href = P.UrlWiki+"?page="+P.DefaultPage;
	extwiki.setLinkAction(Ext.get('logo_url'));
	Ext.get('top_url').on('click', function(){}, null, {stopEvent:true});

	// 初期ページの追加とメニューパネルセット
	extwiki.loadToolBar();
	extwiki.loadPluginPage({page:P.FirstPage,anchor:P.anchor0});
	extwiki.dispMenuPanel(false);

	//f5キーを押したときの制御
	Ext.getDoc().on('keydown', function(e) {
		if (e.keyCode==116 && !e.ctrlKey) {
			if (Ext.isIE) e.browserEvent.keyCode = 0;
			e.stopEvent();
			extwiki.reload();
		}
	});

	// 履歴制御
	Ext.History.on('change', function(id){
		if (id==this.lastAdd) {
			this.lastAdd = false;
			return;
		}
		if(id && id!='init') {
			if (tab_panel.getItem(id)) tab_panel.setActiveTab(id);
		} else {
			alert('ExtWikiの履歴はここまでです。');
		}
	});

	// url のパラメータを名前付き配列に変える
	function getParms(sParms) {
		if (sParms.charAt(0)=='?') {
			sParms = sParms.substr(1);
		}
		var w = sParms.split('&');
		for (var i=0,p={}; i<w.length; i++){
			var exp = w[i].split('=');
			if (exp.length<2) {
				p.page = w[i];
			} else {
				p[exp[0]] = (exp[0]=='page'||exp[0]=='refer'?exp[1]:unescape(exp[1]));
			}
		}
		return p;
	}
});
