<?php // $Id: extwiki.inc.ondemand.php 67 2010-11-30 04:47:35Z mashiki $
function extwiki_getTemplate($page) {
	mb_internal_encoding('UTF-8');

	$templates = array(
		':ExtConfig'=> <<< _
			このページは導入後に必ず「凍結」をかけてください
			**設定項目 [#h6d2a5dd]
			>
			|~設定名	|~設定値|~初期値|~内容|~備考|h
			|SightName	|	|$page_title|サイトのタイトル|左上ロゴに使用|
			|TabPosition	|bottom	|bottom|タブの表示位置|'top' または 'bottom'|
			|MenuPosition	|left	|left|メニューバーの表示位置|'left', 'right', 'top' または 'bottom'から選択|
			|Theme		|blue	|blue|サイトの配色等のテーマ|'access'、'blue'、'gray'等が指定可能|
			|MaxTabs	|16	|16|最大タブ数|超えた場合、古いタブから削除されます|
			|Timeout	|60	|60|Ajax応答待ち時間|秒単位で指定する|
			|AutoMode	|false	|0|ExtWikiモード優先|'true'/'false'または'1'/'0'で表記|
			|UrlExtWiki	|	|extwiki/|extwikiフォルダのURL|標準以外のフォルダ使用時に指定|
			|UrlExtJS	|	|extwiki/ext3/|ExtJSライブラリのURL|CacheFlyを使うときなど変更|
			|CustomStyle	|	||追加CSSファイル|例) myStyle1.css, myStyle2.css|
			-設定値を変えた場合、「Ctrl」+「f5」キーでリロードを行ってください
			<
_
		,':ExtMenuManual'=> <<< _
			このページは導入後に必ず「凍結」をかけてください
			*メニューとツールバーの設定
			#contents

			** 設定ページ
			-設定はそれぞれ次のページを修正することで行います
			|メニューバー|[[:ExtMenuBar]]|通常のpukiwikiの[[MenuBar]]に相当|
			|ツールバー|[[:ExtToolBar]]|通常のpukiwikiのページの上下に表示されるメニューやアイコンに相当|

			**設定行の表記ルール
			*** 有効書式と種類
			-有効な行は「-」もしくは「*」からはじめる行(段落,箇条書)のみ処理対象となり、それ以外の行は無視されます
				・「*」「**」「***」で始まる行は表示上すべて最上位メニューとなります
					※メニューバーの最上位メニューは、アコーデオンウインドウの開閉のため、
					　タイトル表示のみで、プラグインを動作させることはできません
				・先頭の「-」の数はサブメニューの階層を意味します
					※「*」で始まる行を「-」で始まる行に変えるときは「[#r9cdc238]」のような
					　アンカーも削除してください
				・「----」の行は仕切り線になります。第1階層では縦の線、第2,3階層では横の線となります
				・「->」の行はこれ以降のメニューを右づめで表示します(ツールバーのみで有効)
			-「-」もしくは「*」以降は下記のように表現することとします
				書式1： スイッチ(icon)[[ページ]]:説明
				        スイッチ(icon)[[表示>ページ]]:説明
				書式2： スイッチ(icon)[[表示>&プラグイン名(パラメータ1,...)]]:説明
				        スイッチ(icon)[[表示>>&プラグイン名(パラメータ1,...)]]:説明
				書式3： スイッチ(icon)[[表示>&&extwiki機能名(パラメータ1,...)]]:説明
				書式4： スイッチ(icon)表示:説明

			***共通事項
			-「スイッチ」は省略可能で、ページの書込み可/不可により機能を有効/無効にするかを記述します。
			 ・ツールバーでのみ有効でメニューバーでは指定できません
			 ・スイッチは下記の3通り
			 	?edit  書込み可能の時に機能を有効にする
			 	!edit  書込み不可の時に機能を有効にする
			 	省略時 常に機能を有効にする
			-(icon)は省略可能でメニューに表示するアイコンのCSSクラス名を指定します
			 menu,navi,list,setting等が使用可能です
			-「説明」はメニューにマウスを当てた時、表示するツールチップとなります。省略可能。
			 ※ツールバーにおいては、(おそらくExtJSの仕様で)階層の1番上のレベルでのみ有効となります

			***書式1 通常ページへのリンク
			-書式1： [ [ページ]] または [ [表示>ページ]]
			--この書式はページへのリンクとなります
			--ページは「ページ名#アンカー名」のようにアンカーを含めることが可能です
			--メニュー上の表示と実際のページを変えたい場合、後者の書式で表記します

			***書式2 プラグインの呼び出し
			-書式2： [[表示>&プラグイン名(パラメータ1,...)]] ~
			または  [[表示>>&プラグイン名(パラメータ1,...)]] 
			--この書式はpukiwikiのプラグイン機能を呼び出す際に使用します
			--パラメータとして現在のページを指定するには「.」を使用します
			--表示の後に「>>」と不等号を2つ重ねた場合、別Window(タブ)で表示します

			***書式3 Javascript機能(xjf)の呼び出し
			-書式3： [[表示>&&xjf名(パラメータ)]] ~
			または  [[表示>>&&xjf名(パラメータ)]]
			--この書式はextwikiで実装された機能を呼び出す際に使用します
			--表示の後に「>>」と不等号を2つ重ねた場合、別Window(タブ)で表示します (&&pukiwiki のみ使用可)
			--下記の機能を指定可能です
			|Javascript機能	|説明|h
			|&&about		|ExtWikiのバージョン表示|
			|&&customize	|ユーザ毎のカスタマイズ状況を表示するウインドウを開く|
			|&&dispMenuBar	|サブリージョンにメニューを表示する|
			|&&edit(page=xx)|指定したページを編集モードで開く|
			|&&home			|トップページにもどる|
			|&&move2sub		|アクティブパネルをサブリージョンに移動する|
			|&&newpage		|新規ページの作成|
			|&&pagetree(page)|メニューにpage以下のページをtree表示する&br;MenuBarにls2プラグインを使っていた場合、同じように使用できます★|
			|&&pukiwiki		|通常のpukiwiki表示モードに戻る|
			|&&reload		|ページの再読み込み|
			|&&reloadToolBar|ツールバーの再読み込み|
			|&&recent(n)	|メニューにnページの最終更新情報を表示する★|
			|&&xjpconsole	|xjpの状態を一覧し操作するウインドウを表示する|
			---現状★のxjfはjavascriptでなく、phpで実装されています

			***書式4 機能のない表示のみのメニュー
			-書式4： 表示
			--この書式は機能のないメニューの表示のために使用します
			--「[[表示>&&menu()]]」と同じ意味になります
_
		,':ExtMenuBar'=> <<< _
			このページは導入後に必ず「凍結」をかけてください
			~変更方法は[[設定マニュアル>:ExtMenuManual]]を参照してください。
			//実際の定義
			[[[TARGET]]]

			*(recentchanges)[[最近更新されたページ>&&recent(20)]]

			*(navi)関連サイト
			-PukiWiki関連リンク
			--(navi)[[pukiwiki本家>http://pukiwiki.sourceforge.jp/]]
			--(navi)[[pukiwiki開発サイト>http://pukiwiki.sourceforge.jp/dev/]]
			--(navi)[[本家のExtWikiプラグイン紹介ページ>http://pukiwiki.sourceforge.jp/?%E8%87%AA%E4%BD%9C%E3%83%97%E3%83%A9%E3%82%B0%E3%82%A4%E3%83%B3%2Fextwiki.inc.php]]
			--(navi)[[PukiWiki Plus!>http://pukiwiki.cafelounge.net/plus/]]
			-ExtJS関連リンク
			--(navi)[[ExtJS公式サイト>http://extjs.com/]]
			---(navi)[[公式ブログ>http://extjs.com/blog/]]
			---(navi)[[APIマニュアル>http://extjs.com/deploy/dev/docs/]]

			*(setting)設定ページ
			-[[MenuBar]]
			-[[:ExtMenuBar]]
			-[[:ExtToolBar]]
			-[[:ExtConfig]]
_
		,':ExtToolBar'=> <<< _
			このページは導入後に必ず「凍結」をかけてください
			~[[設定マニュアル>:ExtMenuManual]]
			//実際の定義
			*(normal)表示:通常のpukiwikiや２画面表示など
			-(normal)[[別窓で表示>>&&pukiwiki(page=.)]]
			-(normal)[[通常表示へ>&&pukiwiki(page=.)]]
			----
			-[[ソース表示>&source(page=.)]]:このページのソースを表示する
			----
			-[[サブ領域へ移動>&&move2sub]]
			-[[MenuBar表示>&&dispMenuBar]]
			----
			*(new)[[新規>&&newpage]]:新しいページを作成する<br />存在するページ名を直接入力し開くことも可能
			*(reload)[[リロード>&&reload]]:このタブをリロードする(f5)<br />「Ctrl」+f5で全体のリロード
			*?edit(edit)[[編集>&&edit(page=.)]]:ページを編集する
			----
			*(page)ページ操作:このページを編集/操作する
			-(reload)[[リロード>&&reload]]
			-(diff)[[差分>&diff(page=.)]]
			-[[ソース表示>&source(page=.)]]:このページのソースを表示する
			----
			-?edit(edit)[[編集>&edit(page=.)]]
			-?edit(edit)[[別窓編集>>&edit(page=.)]]:別のwindowでページを編集する
			-?edit(rename)[[名前変更>&rename(page=.)]]
			-(copy)[[コピー(複製)>&template(refer=.)]]
			-?edit(upload)[[添付>&attach(page=.)]]
			-?edit(freeze)[[凍結>&freeze(page=.)]]
			-!edit(unfreeze)[[解凍>&unfreeze(page=.)]]
			----
			-(backup)[[バックアップ>&backup(page=.)]]
			-(referer)[[リンク元>&referer(page=.)]]
			-(related)[[参照元>&related(page=.)]]
			-[[検索キー一覧>&skeylist(page=.)]]
			-[[相互自動リンク表>&linklist(page=.)]]
			----
			*(list)検索/一覧:一覧で確認する
			-(list)[[一覧>&list]]
			//-(list)[[ファイル一覧>&filelist]]
			-(home)[[トップ>&&home]]:トップページを表示する
			-(search)[[検索>&search]]
			-(recentchanges)[[最終更新>RecentChanges]]
			----
			-(feed)[[RSS>>&rss]]
			-(feed)[[RSS>>&mixirss]]
			----
			*(help)ヘルプ:バージョン表示/ヘルプページへのリンク
			-(help)[[ExtWikiバージョン>&&about]]
			-(link)[[pukiwikiヘルプ>http://pukiwiki.sourceforge.jp/?%E6%95%B4%E5%BD%A2%E3%83%AB%E3%83%BC%E3%83%AB]]
			-(link)[[pukiwikiプラグイン>http://pukiwiki.sourceforge.jp/?PukiWiki%2F1.4%2FManual%2FPlugin]]
			->
			*(setting)ツール:ツール/設定
			-[[ツールバーのリロード>&&reloadToolBar]]
			----
			-(setting)[[個人別設定変更>&&customize]]:ユーザ毎の表示等の設定変更
			-[[xjpコンソール>&&xjpconsole]]
_
	);
	$temp = isSet($templates[$page])
		?extwiki_commentLines($templates[$page])
		:'';
	if ($page==':ExtMenuBar') {
		$temp = extwiki_makeSampleMenu($temp);
	}
	
	if (PLUGIN_EXTWIKI_INTERNAL_ENCODING!='UTF-8') {
		$temp = mb_convert_encoding($temp, PLUGIN_EXTWIKI_INTERNAL_ENCODING,'UTF-8');
		mb_internal_encoding(PLUGIN_EXTWIKI_INTERNAL_ENCODING);
	}
	return $temp;
}

function extwiki_commentLines($contents) {
	global $spam;
	$lines = explode("\n", preg_replace('/^\t\t\t/m','',$contents));
	$ret = '';
	foreach ($lines as $line) {
		if (
		 // 存在しないプラグインが指定されている、もしくは
			(preg_match('/^[-*]+.*>&([a-zA-Z0-9]+)[\](]/', $line, $mch)
			&& !exist_plugin($mch[1]) )
		 // extwikiプラグインのスパム対策の設定がされていなければ
		 || (!isset($spam['method']['extwiki']) && preg_match('|https?://|', $line))
		) {
			$line = "//$line"; // コメント化
		}
		$ret .= "$line\n";
	}
	return $ret;
}

function extwiki_makeSampleMenu($contents) {
	global $menubar;
	$target = '';
	if (is_page($menubar) && check_readable($menubar, false, false)) {
		// MenuBarを読み込む
		$source = get_source($menubar);
		// MenuBarを1行ずつ処理
		foreach ($source as $line) {
			if (PLUGIN_EXTWIKI_INTERNAL_ENCODING!='UTF-8') {
				$line = mb_convert_encoding($line, 'UTF-8', PLUGIN_EXTWIKI_INTERNAL_ENCODING);
			}
			// コメント行は無視
			if (preg_match('|^//|', $line)) continue;
			//「&size(数字){ｘｘｘ};」はｘｘｘに変換してから処理を行う
			$line = preg_replace('/&size\([0-9]*\){([^{}]+)};/', '\1', rtrim($line));

			// extwiki プラグインの行は無視
			if (preg_match('/[#&]extwiki/', $line)) {
				// 何もしない
			}
			// *から始まる行は残す
			else if (preg_match('/^\*/', $line)) {
				$line = preg_replace('/ *\[[^\[]+\]$/', '', $line);
				$target .= "$line\n";
			}
			// -から始まる行は残す
			else if (preg_match('/^-/', $line)) {
				$target .= "$line\n";
			}
			// [[ｘｘｘ]]な行は -[[ｘｘｘ]] に変更する
			else if (preg_match('/\[\[[^\[\]]+\]\]/', $line, $mch)) {
				$target .= "-{$mch[0]}\n";
			}
			// #ls2(ｘｘ) があれば pagetree(ｘｘ)に変更する
			else if (preg_match('/[#&](ls2|pagetree|ajaxtree)\(([^,)]+)[,)]/', $line, $mch)) {
				$target .= "-[[{$mch[2]}>&&pagetree({$mch[2]})]]\n";
			}
			// #ls2 があれば pagetreeに変更する
			else if (preg_match('/[#&](ls2|pagetree|ajaxtree)/', $line, $mch)) {
				$target .= "-[[Top>&&pagetree]]\n";
			}
			// それ以外は何もしない
		}
	}
	// $contentsにはめ込む
	return str_replace('[[[TARGET]]]', $target, $contents);
}
?>