// $Id: edit.js 101 2011-01-08 01:27:42Z mashiki $
function(opt) {
	// 再利用可能かどうか確認する
	var page = opt.page
		force= opt.force
		refer= opt.refer;
	var pi = {page:page,action:'_edit',edit_continue:opt.edit_continue};
	var pnl = Xji.find('main',pi)[0],
		idMsg = page+'_msg',
		idNts =  page+'_nts',
		idPas =  page+'_pas',
		idCnt =  page+'_cnt',
		helppage = 'FormattingRules';

	// パネルがある場合、アクティブにする
	if (pnl) {
		Xji.activate(pnl);
		return;
	}

	// パネルがない場合作成する
	pnl = new Xji.Panel({
		title: 'loading ...',
		iconCls: 'ewi_loading',
		closable: true,
		autoScroll: true,
		pageinfo: pi,
		layout:'fit',
		items: {
			xtype: 'textarea',
			hideLabel: true,
			id: idMsg
		},
		buttonAlign:'left',
		buttons: [
			{
				text:'プレビュー',
				width:60,
				handler:function(){
					var ppi = Ext.apply({}, pi);
					var ppnl = Xji.add(ppi, 'sub');
					// ページデータの読み込み
					Xji.request({
						query: {
							mode:'getPreview',
							page:ppi.page
						},
						params : {
							msg:Ext.getCmp(idMsg).getValue()
						},
						x_page : ppi.page,
						x_pnl  : ppnl,
						success: Xji.onPageLoad
					});
				}
			},
			{
				text:'Diff',
				width:40,
				handler:function(){
					var msg = Ext.getCmp(idMsg).getValue();
					if (msg===pi.original) {
						XM.alert('ページ編集', '変更箇所はありません');
						return;
					}
					var ppi = Ext.apply({}, pi);
					var ppnl = Xji.add(ppi, 'sub');
					// Diff 取得リクエスト
					Xji.request({
						query: {
							mode:'getDiff',
							page:ppi.page
						},
						params : {
							msg: msg,
							original: pi.original
						},
						x_page : ppi.page,
						x_pnl  : ppnl,
						success: Xji.onPageLoad
					});
				}
			},'-',
			{
				xtype:'checkbox',
				id:idNts,
				boxLabel:'タイムスタンプ保持',
				hidden: (P.NoTimeUpdate==0)
			},{
				xtype:'field',
				inputType:'password',
				id:idPas,
				width: 70,
				hidden: (P.NoTimeUpdate!=2)
			},{
				text:'ページ更新',
				handler: postForm
			},'->',{
				text:'テキスト整形ルール',
				handler:function(){
					Xji.loadPage({page:helppage},'sub');
				}
			}
		],
		listeners:{
			beforeClose: function(p) {
				// 編集中の場合、確認する
				if (Ext.getCmp(idMsg).isDirty()) {
					XM.confirm(
						'ページ編集',
						'編集中のデータがありますが、ページを閉じますか',
						function (btn) {
							if (btn=='yes') {
								Xji.remove(pnl);
							}
						}
					);
					return false; // closeをキャンセルする
				}
				// サブパネルが表示されていた場合、クリアする
				clearSubPanel()
			}
		}
	});
	Xji.add(pi,'main',pnl);
	Xji.activate(pnl);

	// ページデータの読み込み
	Xji.request({
		query: {
			mode:'getPageInfo',
			body:'1',
			page:page
		},
		x_page  : page,
		x_pnl   : pnl,
		success : onRawPageLoad,
		failure : Xji.onPageNotFound
	});

	function onRawPageLoad(res, opt) {
		if (!res.found) {
			if (!force) {
				XM.confirm(
					'ページ編集',
					'存在しないページです。新規に作成しますか', 
					function(btn){
						if (btn=='yes') {
							force = true;
							onRawPageLoad(res, opt);
						}
					}
				);
				return;
			}
		// 書き込み可能かチェックする
		}else if (!res.writable) {
			for (var i,b;b=pnl.buttons[i];++i) b.disable();
			XM.alert('ページ編集','このページは書き込み禁止です');
		}
		// ページ内容セット
		var body = res.body||(refer&&refer.title?'[['+refer.title+']]':'');
		Ext.getCmp(idMsg).setValue(body);
		Ext.getCmp(idMsg).originalValue = body;
		// ページ情報セット
		pnl.setPI({
			original: body,
			digest: res.digest,
			title: res.title,
			iconClass: 'ewi_edit',
			writable: false,
			update: (res.update&&res.update!='-')?new Date(res.update):'-',
			cntTotal: res.cntTotal,
			cntToday: res.cntToday,
			cntYesterday: res.cntYesterday
		});
		Xji.onPageActive(pnl);
	}

	function postForm() { // formの内容をPOSTする
		// パラメータ
		var prms = {
			digest: pi.digest,
			encode_hint: 'ぷ',
			msg: Ext.getCmp(idMsg).getValue(),
			original: pi.original,
			write: 'ページの更新',
			x_cmd: 'edit'
		}
		if (Ext.getCmp(idNts).getValue()) {
			prms.notimestamp='true';
			if (P.NoTimeUpdate==2) prms.pass=Ext.getCmp(idPas).getValue();
		}
		// リクエスト発行
		Xji.request({
			query: {mode:'postForm',page:page},
			params: prms,
			x_page: page,
			x_action: pi.action,
			x_pnl: pnl,
			success: function(res, opt) {
				opt.x_pnl = Xji.add({page:pi.page,action:'edit'},'main');
				Xji.onPageLoad(res, opt);
				Xji.remove(pnl);
			},
			failure: Xji.onPostFail
		});
		Ext.getCmp(idMsg).originalValue = prms.msg;
		clearSubPanel();
	}  // postForm

	function clearSubPanel() { // プレビューやテキスト整形ルールが表示されていれば消す
		var sub = Xji.find('sub')[0];
		if (sub && (sub.getPI('page')==pi.page || sub.getPI('page')==helppage)) {
			Xji.clearSub(true);
		}
	}
}
