#define _GNU_SOURCE

#include "ch_time_and_mod_dir.h"
#include "cp.h"
#include "filefrag_custom.h"
#include "global.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>

/*******************************************************************************
*******************************************************************************/
_Bool dir_traverse(const char *target)
{
	struct stat current_stat;
	_Bool current_stat_flag;

	if(chdir(target) == -1)
	{
		perror("chdir");
		return false;
	}
	else
	{
		if(stat(".", &current_stat) == -1)
		{
			current_stat_flag = false;
			stat_data = NULL;
		}
		else
		{
			current_stat_flag = true;
			stat_data = &current_stat;
		}

		stat_target_directory = ".";
	}

	DIR *dp = NULL;
	struct dirent *entry = NULL;

	if((dp = opendir(".")) != NULL)
	{
		while((entry = readdir(dp)) != NULL)
		{
			// strcmpは等しければ0を返す（0は偽）
			if(strcmp(entry->d_name, ".") && strcmp(entry->d_name, ".."))
			{
				int from_extents;

				switch(entry->d_type)
				{
				case DT_REG:
					from_extents = filefrag_custom(entry->d_name);

					if(from_extents > 1)
					{
						cp(entry->d_name, from_extents);

						if(current_stat_flag == true)
						{
							ch_time_and_mod_dir(".", &current_stat);
						}
					}
					break;

				case DT_DIR:
					// 再帰
					if(dir_traverse(entry->d_name) == true)
					{
						if(chdir("..") == -1)
						{
							perror("chdir");
							exit(EXIT_FAILURE);
						}
						else
						{
							if(current_stat_flag == true)
							{
								stat_data = &current_stat;
							}
							else
							{
								stat_data = NULL;
							}

							stat_target_directory = ".";
						}
					}
					break;
				}
			}
		}
		if(closedir(dp) == -1)
		{
			perror("closedir");
		}
	}
	else
	{
		perror("opendir");
	}

	if(current_stat_flag == true)
	{
		ch_time_and_mod_dir(".", &current_stat);
	}

	return true;
}
