#define _GNU_SOURCE

#include "ch_time_and_mod_dir.h"
#include "cp.h"
#include "dir_traverse.h"
#include "filefrag_custom.h"
#include "global.h"
#include "help.h"
#include "set_signal.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <limits.h>

#include <errno.h>
#include <linux/limits.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <glib.h>
#include <getopt.h>

_Bool flag_advance = false;
_Bool flag_over_gigabyte = false;
_Bool flag_gigabyte = false;
_Bool flag_verify = false;

char *stat_target_directory;
struct stat *stat_data;

/*******************************************************************************
*******************************************************************************/
void analyze_option(const int argc, char **argv)
{
	int result;

	while((result = getopt(argc, argv, "aGgr")) != -1)
	{
		switch(result)
		{
		case 'a':
			flag_advance = true;
			break;
		case 'G':
			flag_over_gigabyte = true;
			flag_gigabyte = true;
			break;
		case 'g':
			flag_gigabyte = true;
			flag_over_gigabyte = false;
			break;
		case 'r':
			flag_verify = true;
			break;
		}
	}
}

/*******************************************************************************
*******************************************************************************/
int main(int argc, char **argv)
{
	if(argc == 1)
	{
		help();
		return EXIT_SUCCESS;
	}
	else if(argc == 2)
	{
		char *tmp = argv[1];

		if(
			((tmp[0] == '-') && (tmp[1] == 'h'))
			||
			(
				(tmp[0] == '-') &&
				(tmp[1] == 'h') &&
				(tmp[2] == 'e') &&
				(tmp[3] == 'l') &&
				(tmp[4] == 'p')
			)
			||
			(
				(tmp[0] == '-') &&
				(tmp[1] == '-') &&
				(tmp[2] == 'h') &&
				(tmp[3] == 'e') &&
				(tmp[4] == 'l') &&
				(tmp[5] == 'p')
			)
		)
		{
			help();
			return EXIT_SUCCESS;
		}
	}
	else if(argc > 1)
	{
		int current;

		if((current = open(".", O_RDONLY)) == -1)
		{
			perror("open");
			exit(EXIT_FAILURE);
		}

		set_signal();
		analyze_option(argc, argv);

		for(int i = 1; i <= argc; i++)
		{
			if(g_file_test(argv[i], G_FILE_TEST_IS_SYMLINK) == FALSE)
			{
				if(g_file_test(argv[i], G_FILE_TEST_IS_REGULAR) == TRUE)
				{
					int from_extents = filefrag_custom(argv[i]);
					char *parent = g_path_get_dirname(argv[i]);
					struct stat stat_buf;
					_Bool stat_flag = false;

					if(stat(parent, &stat_buf) == -1)
					{
						stat_data = NULL;
						stat_flag = false;
						perror("stat");
					}
					else
					{
						stat_data = &stat_buf;
						stat_flag = true;
					}

					stat_target_directory = parent;

					if(from_extents > 1)
					{
						cp(argv[i], from_extents);
					}

					if(stat_flag == true)
					{
						ch_time_and_mod_dir(stat_target_directory, stat_data);
					}

					stat_target_directory = NULL;
					stat_data = NULL;
					free(parent);
				}
				else if(g_file_test(argv[i], G_FILE_TEST_IS_DIR) == TRUE)
				{
					char path_buf[PATH_MAX];

					if((realpath(argv[i], path_buf) == NULL))
					{
						fprintf(stderr, "絶対パスの作成に失敗しました\n");
						fprintf(stderr, "対象ファイル : %s\n", argv[i]);
						exit(EXIT_FAILURE);
					}

					if(dir_traverse(argv[i]) == true)
					{
						if(fchdir(current) == -1)
						{
							perror("fchdir");
							exit(EXIT_FAILURE);
						}
					}

					stat_target_directory = NULL;
					stat_data = NULL;
				}
			}
		}
	}
	else
	{
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}
