#define _GNU_SOURCE

#include <stdio.h>

#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

/*******************************************************************************
*******************************************************************************/
void ch_time_and_mod(const int ito, const char *to, const struct stat *stat_buf)
{
	struct timespec time_s[2];

	errno = 0;

	if(fchmod(ito, stat_buf->st_mode) == -1)
	{
		perror("fchmod");
	}
	if(fchown(ito, stat_buf->st_uid, stat_buf->st_gid) == -1)
	{
		perror("fchown");
	}

	time_s[0].tv_sec = stat_buf->st_atime;
	time_s[1].tv_sec = stat_buf->st_mtime;

	time_s[0].tv_nsec = stat_buf->st_atim.tv_nsec;
//	time_s[0].tv_nsec = stat_buf->st_atimensec;
	time_s[1].tv_nsec = stat_buf->st_mtim.tv_nsec;
//	time_s[1].tv_nsec = stat_buf->st_mtimensec;

	// 第四引数は0かAT_SYMLINK_NOFOLLOW
	if(utimensat(AT_FDCWD, to, time_s, AT_SYMLINK_NOFOLLOW) == -1)
	{
		perror("utimensat");
	}
}
