
#include <string.h>

#include "CanData.h"



CanDataMng::CanDataMng( int buffNum )
{
	int i;
	CanData * pCanData;

	recodeNum = 0;

	for( i=0; i<buffNum; ++i ) {
		pCanData = new CanData;
		dataVec.append( pCanData );
	}
}

CanDataMng::~CanDataMng()
{
	int i;

	for( i=0; i<dataVec.count(); ++i ) {
		delete dataVec[i];
	}
}

int CanDataMng::num( void )
{
	int num;

	lock.lockForRead();
	num = recodeNum;
	lock.unlock();

	return num;
}

void CanDataMng::set( CanData & canData )
{

	lock.lockForWrite();
	if( recodeNum < dataVec.count() ) {
		*dataVec[recodeNum] = canData;
		recodeNum ++;
	}
	lock.unlock();
}

int CanDataMng::get( int no, CanData &canData )
{
	int retVal = -1;

	lock.lockForRead();

	if( no < recodeNum ) {
		canData = *dataVec[no];
		retVal = 0;
	}

	lock.unlock();

	return retVal;
}

void CanDataMng::clear( void )
{
	lock.lockForWrite();
	recodeNum = 0;
	lock.unlock();
}

bool CanDataMng::isFull( void )
{
	bool bFull = true;

	lock.lockForWrite();
	if( recodeNum < dataVec.count() ) {
		bFull = false;
	}
	lock.unlock();

	return bFull;
}
