#pragma once

#include <QVector>
#include <QReadWriteLock>

#define	CAN_FRAME_LEN_MAX	8

class CanData
{
public:
//	CanData();
//	~CanData();

//	bool          bTx;
//	unsigned long time;
//	int           id;
//	int           rtr;
//	int           ide;
//	int           r0;
//	int           dlc;
//	int           len;
//	unsigned char data[CAN_FRAME_LEN_MAX];
//	int           crc;
//	int           ack;

	int           type;
	int           id;
	int           func;
	int           len;
	unsigned char data[CAN_FRAME_LEN_MAX];
	unsigned long int mtime;
	unsigned short int utime;
};

class CanDataMng
{
public:
	CanDataMng( int buffNum );
	~CanDataMng();

	int num( void );
	void set( CanData &canData );
	int get( int no, CanData &canData );
	bool isFull( void );
	void clear( void );

private:
	QReadWriteLock	lock;
	volatile int		recodeNum;
	QVector<CanData *>	dataVec;
};

