#ifndef GRAPH_H
#define GRAPH_H

#include <QtGui>
#include <QWidget>
#include <qtimer.h>
#include "ui_graph.h"
#include "rxdataformat.h"
#include "information.h"
#include "SysConfig.h"
#include "CanData.h"
#include "plotter.h"
#include "CanFrame.h"

class FCAN_View;

class Graph : public QWidget
{
	Q_OBJECT

public:
	Graph(QWidget *parent = 0);
	~Graph();

	void SysConfigSet( SysConfig * sysconfig );
	void RxDataFormatSet( RxDataFormat * rxdataformat );
	void PlotterSet( Plotter * plotter );
	void PlotSettingsSet( PlotSettings * plotsettings );
	void CanDataSet( CanData * candata );
	void CanDataMngSet( CanDataMng * candatamng );
	void CanFrameSet( CanFrame * canframe );
	void InformationSet( Information * information );
	void FcanViewSet( FCAN_View * fcanview );
	void GraphNumberSet(int no);
	void GraphStartStop();
	QString GraphInit(int mode, QString line);
	double EndScroll( );

	int GraphReciveMode;
	int GraphNumber;
	int GraphWindowOpen;
	int GraphYaxisSelect[5];
	QString GraphName;
	bool GraphWindow[5];
	CanFrameFormat * pGraphItem[5];

private slots:
	// btnGraphDraw
	void btnGraphDraw_Click();
	// btnGraphClose
	void btnGraphClose_Click();
	// btnGraphStartStop
	void btnGraphStartStop_Click();
	// btnGraphFileFind
	void btnGraphFileFind_Click();
	// btnGraphFileLoad
	void btnGraphFileLoad_Click();
	// rdbGraphRecive
	void rdbGraphRecive_Toggled();
	// chbGraph1
	void chbGraph1_Toggled();
	// chbGraph2
	void chbGraph2_Toggled();
	// chbGraph3
	void chbGraph3_Toggled();
	// chbGraph4
	void chbGraph4_Toggled();
	// chbGraph5
	void chbGraph5_Toggled();
	// chbYaxis2
	void chbYaxis2_Toggled();
	// chbYaxis3
	void chbYaxis3_Toggled();
	// chbYaxis4
	void chbYaxis4_Toggled();
	// chbYaxis5
	void chbYaxis5_Toggled();
	// cbbGraphId1
	void cbbGraphId1_Changed( const QString &s );
	// cbbGraphId2
	void cbbGraphId2_Changed( const QString &s );
	// cbbGraphId3
	void cbbGraphId3_Changed( const QString &s );
	// cbbGraphId4
	void cbbGraphId4_Changed( const QString &s );
	// cbbGraphId5
	void cbbGraphId5_Changed( const QString &s );
	// cbbGraphFunc1
	void cbbGraphFunc1_Changed( const QString &s );
	// cbbGraphFunc2
	void cbbGraphFunc2_Changed( const QString &s );
	// cbbGraphFunc3
	void cbbGraphFunc3_Changed( const QString &s );
	// cbbGraphFunc4
	void cbbGraphFunc4_Changed( const QString &s );
	// cbbGraphFunc5
	void cbbGraphFunc5_Changed( const QString &s );
	// Timer
	void timGraph();
	// File Menu
	void menu_triggered( );
	// Load File
	void menu_loadfile( );
	// Save File
	void menu_savefile( );
	// Close
	void closeEvent( QCloseEvent * event );

private:
	Ui::Graph ui;

	SysConfig * pSysConfig;
	RxDataFormat * pRxDataFormat;
	Plotter * pPlotter;
	PlotSettings * pPlotSettings;
	CanData * pCanData;
	CanDataMng * pCanDataMng;
	CanFrame * pCanFrame;
	Information * pInformation;
	FCAN_View * pFcanView;

	// Timer
	QTimer	*GraphTimer;

	int GetId(int Select);
	int GetFunc(int Select);
	int GetItem(int Select);
	void chbGraph1_Load();
	void chbGraph2_Load();
	void chbGraph3_Load();
	void chbGraph4_Load();
	void chbGraph5_Load();
	void cbbGraphId1_Load();
	void cbbGraphId2_Load();
	void cbbGraphId3_Load();
	void cbbGraphId4_Load();
	void cbbGraphId5_Load();
	void cbbGraphFunc1_Load();
	void cbbGraphFunc2_Load();
	void cbbGraphFunc3_Load();
	void cbbGraphFunc4_Load();
	void cbbGraphFunc5_Load();
	void GraphReSize();
	void PlotterSetting( );
	void createMenus();
	void createMenuActions();
	int ValueCheck(QString ValueString);

	int MessageCount;
	long long MessageTimeGen;
	int TimeGetFlag;
	int GraphRighViewCount;
	int LoardFileError;

	union LongIntAndFloat {
		long long				ival;
		unsigned long long		uival;
		double					fval;
	};

	union IntAndFloat {
		int						ival;
		unsigned int			uival;
		float					fval;
	};

	struct {
		QMenu * pMenu;
		QAction * pLoadFile;
		QAction * pSaveFile;
	} SettingMenu;

};

#endif // GRAPH_H
