#include <QtGui>
#include "initfile.h"
#include "fcan_view.h"

InitFile::InitFile(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
	hide();

	pHardware = NULL;
	pRxDataFilter = NULL;
	pRxDataFormat = NULL;
	pTxData = NULL;
	pInformation = NULL;
	pFcanView = NULL;

	// btnInitLoadFileFind
	connect( ui.btnInitLoadFileFind,SIGNAL(clicked()),this,SLOT(btnInitLoadFileFind_Click()));
	// btnInitLoad
	connect( ui.btnInitLoad,SIGNAL(clicked()),this,SLOT(btnInitLoad_Click()));
	// btnInitSaveFileFind
	connect( ui.btnInitSaveFileFind,SIGNAL(clicked()),this,SLOT(btnInitSaveFileFind_Click()));
	// btnInitSaveFile
	connect( ui.btnInitSaveFile,SIGNAL(clicked()),this,SLOT(btnInitSaveFile_Click()));


}

InitFile::~InitFile()
{
}

////////////////////////////////////////
// Pointer Setting
////////////////////////////////////////
void InitFile::HardwareSet( Hardware * hardware )
{
	pHardware = hardware;
}
void InitFile::RxDataFilterSet( RxDataFilter * rxdatafilter )
{
	pRxDataFilter = rxdatafilter;
}
void InitFile::RxDataFormatSet( RxDataFormat * rxdataformat )
{
	pRxDataFormat = rxdataformat;
}
void InitFile::TxDataSet( TxData * txdata )
{
	pTxData = txdata;
}
void InitFile::InformationSet( Information * information )
{
	pInformation = information;
}
void InitFile::FcanViewSet( FCAN_View * fcanview )
{
	pFcanView = fcanview;
}
////////////////////////////////////////
// InitFile Function
////////////////////////////////////////
// Close
void InitFile::closeEvent(QCloseEvent * pEvent)
{
	pFcanView->ViewWindow[0] = false;
}
// btnInitLoadFileFind
void InitFile::btnInitLoadFileFind_Click()
{
	QString fileName = QFileDialog::getOpenFileName(
														this,
					   									tr("Read Init file"),	// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter
	ui.txtInitLoadFileName->setText(fileName);

}
// btnInitLoad
void InitFile::btnInitLoad_Click()
{
	int no;
	int mode;
	int format_load;
	QString line;
	QString qt_str;
	QString qt_ret;

	// Mode Select(Load)
	mode = 0;
	format_load = 0;
	pInformation->Information_set("");

	// File Name
	qt_str = ui.txtInitLoadFileName->text();
	QFile InitFile(qt_str);

	if (InitFile.open(QIODevice::ReadOnly)) {
		QTextStream in(&InitFile);

		// Line1 = Hardware Initialize
		line = in.readLine();
		if( line[0] != '#' ){
			pFcanView->HardwareView(1);
			qt_ret = pHardware->HardwareInit(mode,line);
			if( qt_ret != "" ){
				pInformation->Information_append(qt_ret);
			}
		}
		// Line2 = RxDataFilter Initialize
		line = in.readLine();
		if( line[0] != '#' ){
			pFcanView->RxDataFilterView(1);
			qt_ret = pRxDataFilter->RxDataFilterInit(mode,line);
			if( qt_ret != "" ){
				pInformation->Information_append(qt_ret);
			}
		}
		// Line3 = RxDataFormat Initialize
		line = in.readLine();
		if( line[0] != '#' ){
			if( line[0] == '1' ){
				format_load = 1;
			}
			pFcanView->RxDataFormatView(1);
			qt_ret = pRxDataFormat->RxDataFormatInit(mode,line);
			if( qt_ret != "" ){
				pInformation->Information_append(qt_ret);
			}
		}
		// Line4 = TxData Initialize
		line = in.readLine();
		if( line[0] != '#' ){
			pFcanView->TxDataView(1);
			qt_ret = pTxData->TxDataInit(mode,line);
			if( qt_ret != "" ){
				pInformation->Information_append(qt_ret);
			}
		}
		// Line5 = Graph Initialize
		for(int i =0; i < 10; ++i ){
			if( pFcanView->ViewGraph[i] == true ){
				pFcanView->GraphViewClose(i);
			}
		}
		no = 0;
		while (!in.atEnd()) {
			line = in.readLine();
			if( line[0] != '#' ){
				if( format_load == 1 ){
					pFcanView->GraphView(1);
					qt_ret = pFcanView->GraphInit(no,mode,line);
					if( qt_ret != "" ){
						pInformation->Information_append(qt_ret);
					}
				}
			}
			no = no + 1;
		}
		InitFile.close();
	}
	pInformation->Information_set("");
	pInformation->Information_append("Load Initialize File successfully");

}
// btnInitSaveFileFind
void InitFile::btnInitSaveFileFind_Click()
{
	QString fileName = QFileDialog::getSaveFileName(
														this,
					   									tr("Write Init file"),	// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter
	ui.txtInitSaveFileName->setText(fileName);

}
// btnInitSaveFile
void InitFile::btnInitSaveFile_Click()
{
	int mode;
	QString line;
	QString qt_str;
	QString qt_ret;

	// Mode Select(Save)
	mode = 1;
	line = "";
	pInformation->Information_set("");

	// File Name
	qt_str = ui.txtInitSaveFileName->text();
	QFile SaveFile(qt_str);

	if(!SaveFile.open(QIODevice::WriteOnly)) {
		pInformation->Information_append("OutPut File Not Open");
	} else {
		QTextStream outputfile(&SaveFile);

		// Line1 = Hardware Initialize Save
		if( pFcanView->ViewWindow[1] == true ){
			qt_ret = pHardware->HardwareInit(mode,line);
			outputfile << qt_ret;
		} else {
			qt_ret = "#### Not Open Hardware Window ####\n";
			outputfile << qt_ret;
		}
		// Line2 = RxDataFilter Initialize Save
		if( pFcanView->ViewWindow[5] == true ){
			qt_ret = pRxDataFilter->RxDataFilterInit(mode,line);
			outputfile << qt_ret;
		} else {
			qt_ret = "#### Not Open RxDataFilter Window ####\n";
			outputfile << qt_ret;
		}
		// Line3 = RxDataFormat Initialize Save
		if( pFcanView->ViewWindow[4] == true ){
			qt_ret = pRxDataFormat->RxDataFormatInit(mode,line);
			outputfile << qt_ret;
		} else {
			qt_ret = "#### Not Open RxDataFormat Window ####\n";
			outputfile << qt_ret;
		}
		// Line4 = TxData Initialize Save
		if( pFcanView->ViewWindow[3] == true ){
			qt_ret = pTxData->TxDataInit(mode,line) + "\n";
			outputfile << qt_ret;
		} else {
			qt_ret = "#### Not Open TxData Window ####\n";
			outputfile << qt_ret;
		}
		// Line5 = Graph Initialize Save
		for( int i = 0; i < 10; ++i ){
			qt_ret = pFcanView->GraphInit(i,mode,line);
			outputfile << qt_ret;
		}
		SaveFile.close();
	}
	pInformation->Information_set("");
	pInformation->Information_append("Save Initialize File successfully");

}

