#include <QtGui>
#include "rxdatafilter.h"
#include "hardware.h"
#include "information.h"
#include "fcan_view.h"

RxDataFilter::RxDataFilter(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
	hide();

	pHardware = NULL;
	pInformation = NULL;
	pFcanView = NULL;

	// btnHWfilterSetReset
	connect( ui.btnHWfilterSetReset,SIGNAL(clicked()),this,SLOT(btnHWfilterSetReset_Click()));
	// btnSWfilterSetReset_1
	connect( ui.btnSWfilterSetReset_1,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_1_Click()));
	// btnSWfilterSetReset_2
	connect( ui.btnSWfilterSetReset_2,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_2_Click()));
	// btnSWfilterSetReset_3
	connect( ui.btnSWfilterSetReset_3,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_3_Click()));
	// btnSWfilterSetReset_4
	connect( ui.btnSWfilterSetReset_4,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_4_Click()));
	// btnSWfilterSetReset_5
	connect( ui.btnSWfilterSetReset_5,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_5_Click()));
	// btnSWfilterSetReset_6
	connect( ui.btnSWfilterSetReset_6,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_6_Click()));
	// btnSWfilterSetReset_7
	connect( ui.btnSWfilterSetReset_7,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_7_Click()));
	// btnSWfilterSetReset_8
	connect( ui.btnSWfilterSetReset_8,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_8_Click()));
	// btnSWfilterSetReset_9
	connect( ui.btnSWfilterSetReset_9,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_9_Click()));
	// btnSWfilterSetReset_10
	connect( ui.btnSWfilterSetReset_10,SIGNAL(clicked()),this,SLOT(btnSWfilterSetReset_10_Click()));

	ui.btnHWfilterSetReset->setEnabled(true);
	ui.btnHWfilterSetReset->setText("Enable");
	ui.btnSWfilterSetReset_1->setEnabled(true);
	ui.btnSWfilterSetReset_1->setText("Disable");
	ui.btnSWfilterSetReset_2->setEnabled(true);
	ui.btnSWfilterSetReset_2->setText("Enable");
	ui.btnSWfilterSetReset_3->setEnabled(true);
	ui.btnSWfilterSetReset_3->setText("Enable");
	ui.btnSWfilterSetReset_4->setEnabled(true);
	ui.btnSWfilterSetReset_4->setText("Enable");
	ui.btnSWfilterSetReset_5->setEnabled(true);
	ui.btnSWfilterSetReset_5->setText("Enable");
	ui.btnSWfilterSetReset_6->setEnabled(true);
	ui.btnSWfilterSetReset_6->setText("Enable");
	ui.btnSWfilterSetReset_7->setEnabled(true);
	ui.btnSWfilterSetReset_7->setText("Enable");
	ui.btnSWfilterSetReset_8->setEnabled(true);
	ui.btnSWfilterSetReset_8->setText("Enable");
	ui.btnSWfilterSetReset_9->setEnabled(true);
	ui.btnSWfilterSetReset_9->setText("Enable");
	ui.btnSWfilterSetReset_10->setEnabled(true);
	ui.btnSWfilterSetReset_10->setText("Enable");
	ui.rdbHWfilterStandard->setEnabled(true);
	ui.rdbHWfilterExtended->setEnabled(true);
	ui.txtHWfilterFromCobId->setEnabled(true);
	ui.txtHWfilterFromId->setEnabled(true);
	ui.txtHWfilterToCobId->setEnabled(true);
	ui.txtHWfilterToId->setEnabled(true);
	ui.cbbSWfilterType_1->setEnabled(false);
	ui.txtSWfilterFromCobId_1->setEnabled(false);
	ui.txtSWfilterFromId_1->setEnabled(false);
	ui.txtSWfilterToCobId_1->setEnabled(false);
	ui.txtSWfilterToId_1->setEnabled(false);
	ui.cbbSWfilterType_2->setEnabled(true);
	ui.txtSWfilterFromCobId_2->setEnabled(true);
	ui.txtSWfilterFromId_2->setEnabled(true);
	ui.txtSWfilterToCobId_2->setEnabled(true);
	ui.txtSWfilterToId_2->setEnabled(true);
	ui.cbbSWfilterType_3->setEnabled(true);
	ui.txtSWfilterFromCobId_3->setEnabled(true);
	ui.txtSWfilterFromId_3->setEnabled(true);
	ui.txtSWfilterToCobId_3->setEnabled(true);
	ui.txtSWfilterToId_3->setEnabled(true);
	ui.cbbSWfilterType_4->setEnabled(true);
	ui.txtSWfilterFromCobId_4->setEnabled(true);
	ui.txtSWfilterFromId_4->setEnabled(true);
	ui.txtSWfilterToCobId_4->setEnabled(true);
	ui.txtSWfilterToId_4->setEnabled(true);
	ui.cbbSWfilterType_5->setEnabled(true);
	ui.txtSWfilterFromCobId_5->setEnabled(true);
	ui.txtSWfilterFromId_5->setEnabled(true);
	ui.txtSWfilterToCobId_5->setEnabled(true);
	ui.txtSWfilterToId_5->setEnabled(true);
	ui.cbbSWfilterType_6->setEnabled(true);
	ui.txtSWfilterFromCobId_6->setEnabled(true);
	ui.txtSWfilterFromId_6->setEnabled(true);
	ui.txtSWfilterToCobId_6->setEnabled(true);
	ui.txtSWfilterToId_6->setEnabled(true);
	ui.cbbSWfilterType_7->setEnabled(true);
	ui.txtSWfilterFromCobId_7->setEnabled(true);
	ui.txtSWfilterFromId_7->setEnabled(true);
	ui.txtSWfilterToCobId_7->setEnabled(true);
	ui.txtSWfilterToId_7->setEnabled(true);
	ui.cbbSWfilterType_8->setEnabled(true);
	ui.txtSWfilterFromCobId_8->setEnabled(true);
	ui.txtSWfilterFromId_8->setEnabled(true);
	ui.txtSWfilterToCobId_8->setEnabled(true);
	ui.txtSWfilterToId_8->setEnabled(true);
	ui.cbbSWfilterType_9->setEnabled(true);
	ui.txtSWfilterFromCobId_9->setEnabled(true);
	ui.txtSWfilterFromId_9->setEnabled(true);
	ui.txtSWfilterToCobId_9->setEnabled(true);
	ui.txtSWfilterToId_9->setEnabled(true);
	ui.cbbSWfilterType_10->setEnabled(true);
	ui.txtSWfilterFromCobId_10->setEnabled(true);
	ui.txtSWfilterFromId_10->setEnabled(true);
	ui.txtSWfilterToCobId_10->setEnabled(true);
	ui.txtSWfilterToId_10->setEnabled(true);

	int i;
	for( i = 0; i < 10; ++i ){
		SoftMinValue[i] = 0;
		SoftMaxValue[i] = 0x7ff;
		SoftStandard[i] = 1;
		SoftSet[i]		= 0;
	}
	SoftSet[0]		= 1;

	// Menu Init
	createMenus();

}

RxDataFilter::~RxDataFilter()
{

}

////////////////////////////////////////
// Pointer Setting
////////////////////////////////////////
void RxDataFilter::HardwareSet( Hardware * hardware )
{
	pHardware = hardware;
}
void RxDataFilter::InformationSet( Information * information )
{
	pInformation = information;
}
void RxDataFilter::FcanViewSet( FCAN_View * fcanview )
{
	pFcanView = fcanview;
}
////////////////////////////////////////
// RxDataFilter Function
////////////////////////////////////////
// Close
void RxDataFilter::closeEvent(QCloseEvent * pEvent)
{
	pFcanView->ViewWindow[5] = false;
}
// btnHWfilterSet
void RxDataFilter::btnHWfilterSetReset_Click()
{
	TPCANStatus stsResult;
	QString qt_str;
	DWORD inMaxValue;
	DWORD inMinValue;
	DWORD MaxValue;
	TPCANMode setMode;
	QMessageBox msgBox;

	// Set Select
	if( ui.btnHWfilterSetReset->text() == "Enable" ){
		// Standard or Extended Select
		if( ui.rdbHWfilterStandard->isChecked() ){
			// Standard Select
			MaxValue = 0x7FF;
			setMode = PCAN_MODE_STANDARD;
			// MinValue Get
			qt_str = ui.txtHWfilterFromCobId->text();
			inMinValue = qt_str.toULong(0,16);
			inMinValue = inMinValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtHWfilterFromId->text();
			inMinValue = inMinValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			// MaxValue Get
			qt_str = ui.txtHWfilterToCobId->text();
			inMaxValue = qt_str.toULong(0,16);
			inMaxValue = inMaxValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtHWfilterToId->text();
			inMaxValue = inMaxValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			if( inMaxValue > MaxValue ){
				inMaxValue = MaxValue;
				qt_str.sprintf("%03X", (inMaxValue & pFcanView->StdCobIDMask));
				ui.txtHWfilterToCobId->setText(qt_str);
				qt_str.sprintf("%03X", (inMaxValue & pFcanView->StdNodeIDMask));
				ui.txtHWfilterToId->setText(qt_str);
			}
		} else {
			// Extended Select
			MaxValue = 0x1FFFFFFF;
			setMode = PCAN_MODE_EXTENDED;
			// MinValue Get
			qt_str = ui.txtHWfilterFromCobId->text();
			inMinValue = qt_str.toULong(0,16);
			inMinValue = inMinValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtHWfilterFromId->text();
			inMinValue = inMinValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			// MaxValue Get
			qt_str = ui.txtHWfilterToCobId->text();
			inMaxValue = qt_str.toULong(0,16);
			inMaxValue = inMaxValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtHWfilterToId->text();
			inMaxValue = inMaxValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			if( inMaxValue > MaxValue ){
				inMaxValue = MaxValue;
				qt_str.sprintf("%08X", (inMaxValue & pFcanView->ExtCobIDMask));
				ui.txtHWfilterToCobId->setText(qt_str);
				qt_str.sprintf("%08X", (inMaxValue & pFcanView->ExtNodeIDMask));
				ui.txtHWfilterToId->setText(qt_str);
			}
		}

		// Configures the message filter for a custom range of messages
		//
		stsResult = pHardware->btnSetFilter_Click(inMinValue, inMaxValue, setMode);

		if (stsResult == PCAN_ERROR_OK) {
			ui.btnHWfilterSetReset->setText("Disable");
			ui.rdbHWfilterStandard->setEnabled(false);
			ui.rdbHWfilterExtended->setEnabled(false);
			ui.txtHWfilterFromCobId->setEnabled(false);
			ui.txtHWfilterFromId->setEnabled(false);
			ui.txtHWfilterToCobId->setEnabled(false);
			ui.txtHWfilterToId->setEnabled(false);
			qt_str = "The Hardware filter was customized. IDs from " + ui.txtHWfilterFromCobId->text() + " " + ui.txtHWfilterFromId->text()
					 + " to " + ui.txtHWfilterToCobId->text() + " " + ui.txtHWfilterToId->text() + " will be received";
			pInformation->Information_set("");
			pInformation->Information_append(qt_str);
		} else {
			pInformation->Information_set("");
			pInformation->Information_append("The Hardware filter Customize Error !!");
		}
	} else {
	// Reset Select
		// Standard or Extended Select
		setMode = ( ui.rdbHWfilterStandard->isChecked() ) ? PCAN_MODE_STANDARD : PCAN_MODE_EXTENDED;

		// MinValue Get
		inMinValue = 0;

		// MaxValue Get
		if( ui.rdbHWfilterStandard->isChecked() ){
			inMaxValue = 0x7FF;
		} else {
			inMaxValue = 0x1FFFFFFF;
		}

		// Configures the message filter for a custom range of messages
		//
		stsResult = pHardware->btnResetFilter_Click(inMinValue, inMaxValue, setMode);

		if (stsResult == PCAN_ERROR_OK) {
			ui.btnHWfilterSetReset->setText("Enable");
			ui.rdbHWfilterStandard->setEnabled(true);
			ui.rdbHWfilterExtended->setEnabled(true);
			ui.txtHWfilterFromCobId->setEnabled(true);
			ui.txtHWfilterFromId->setEnabled(true);
			ui.txtHWfilterToCobId->setEnabled(true);
			ui.txtHWfilterToId->setEnabled(true);
			pInformation->Information_set("");
			pInformation->Information_append("The Hardware filter was Disable!!");
		} else {
			pInformation->Information_set("");
			pInformation->Information_append("The HarWare filter was Disable Error !!");
		}
	}

}
// btnSWfilterSetReset_1
void RxDataFilter::btnSWfilterSetReset_1_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_1->text() == "Enable" ){
		ui.btnSWfilterSetReset_1->setText("Disable");
		ui.cbbSWfilterType_1->setEnabled(false);
		ui.txtSWfilterFromCobId_1->setEnabled(false);
		ui.txtSWfilterFromId_1->setEnabled(false);
		ui.txtSWfilterToCobId_1->setEnabled(false);
		ui.txtSWfilterToId_1->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_1->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[0] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_1->text();
			SoftMinValue[0] = qt_str.toULong(0,16);
			SoftMinValue[0] = SoftMinValue[0] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_1->text();
			SoftMinValue[0] = SoftMinValue[0] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_1->text();
			SoftMaxValue[0] = qt_str.toULong(0,16);
			SoftMaxValue[0] = SoftMaxValue[0] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_1->text();
			SoftMaxValue[0] = SoftMaxValue[0] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[0] > MaxValue ){
				SoftMaxValue[0] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[0] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_1->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[0] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_1->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[0] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_1->text();
			SoftMinValue[0] = qt_str.toULong(0,16);
			SoftMinValue[0] = SoftMinValue[0] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_1->text();
			SoftMinValue[0] = SoftMinValue[0] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_1->text();
			SoftMaxValue[0] = qt_str.toULong(0,16);
			SoftMaxValue[0] = SoftMaxValue[0] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_1->text();
			SoftMaxValue[0] = SoftMaxValue[0] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[0] > MaxValue ){
				SoftMaxValue[0] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[0] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_1->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[0] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_1->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[0] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_1->text() + " " + ui.txtSWfilterFromId_1->text()
				 + " to " + ui.txtSWfilterToCobId_1->text() + " " + ui.txtSWfilterToId_1->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_1->setText("Enable");
		ui.cbbSWfilterType_1->setEnabled(true);
		ui.txtSWfilterFromCobId_1->setEnabled(true);
		ui.txtSWfilterFromId_1->setEnabled(true);
		ui.txtSWfilterToCobId_1->setEnabled(true);
		ui.txtSWfilterToId_1->setEnabled(true);

		SoftSet[0] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_2
void RxDataFilter::btnSWfilterSetReset_2_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_2->text() == "Enable" ){
		ui.btnSWfilterSetReset_2->setText("Disable");
		ui.cbbSWfilterType_2->setEnabled(false);
		ui.txtSWfilterFromCobId_2->setEnabled(false);
		ui.txtSWfilterFromId_2->setEnabled(false);
		ui.txtSWfilterToCobId_2->setEnabled(false);
		ui.txtSWfilterToId_2->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_2->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[1] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_2->text();
			SoftMinValue[1] = qt_str.toULong(0,16);
			SoftMinValue[1] = SoftMinValue[1] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_2->text();
			SoftMinValue[1] = SoftMinValue[1] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_2->text();
			SoftMaxValue[1] = qt_str.toULong(0,16);
			SoftMaxValue[1] = SoftMaxValue[1] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_2->text();
			SoftMaxValue[1] = SoftMaxValue[1] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[1] > MaxValue ){
				SoftMaxValue[1] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[1] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_2->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[1] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_2->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[1] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_2->text();
			SoftMinValue[1] = qt_str.toULong(0,16);
			SoftMinValue[1] = SoftMinValue[1] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_2->text();
			SoftMinValue[1] = SoftMinValue[1] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_2->text();
			SoftMaxValue[1] = qt_str.toULong(0,16);
			SoftMaxValue[1] = SoftMaxValue[1] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_2->text();
			SoftMaxValue[1] = SoftMaxValue[1] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[1] > MaxValue ){
				SoftMaxValue[1] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[1] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_2->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[1] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_2->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[1] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_2->text() + " " + ui.txtSWfilterFromId_2->text()
				 + " to " + ui.txtSWfilterToCobId_2->text() + " " + ui.txtSWfilterToId_2->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_2->setText("Enable");
		ui.cbbSWfilterType_2->setEnabled(true);
		ui.txtSWfilterFromCobId_2->setEnabled(true);
		ui.txtSWfilterFromId_2->setEnabled(true);
		ui.txtSWfilterToCobId_2->setEnabled(true);
		ui.txtSWfilterToId_2->setEnabled(true);

		SoftSet[1] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_3
void RxDataFilter::btnSWfilterSetReset_3_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_3->text() == "Enable" ){
		ui.btnSWfilterSetReset_3->setText("Disable");
		ui.cbbSWfilterType_3->setEnabled(false);
		ui.txtSWfilterFromCobId_3->setEnabled(false);
		ui.txtSWfilterFromId_3->setEnabled(false);
		ui.txtSWfilterToCobId_3->setEnabled(false);
		ui.txtSWfilterToId_3->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_3->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[2] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_3->text();
			SoftMinValue[2] = qt_str.toULong(0,16);
			SoftMinValue[2] = SoftMinValue[2] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_3->text();
			SoftMinValue[2] = SoftMinValue[2] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_3->text();
			SoftMaxValue[2] = qt_str.toULong(0,16);
			SoftMaxValue[2] = SoftMaxValue[2] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_3->text();
			SoftMaxValue[2] = SoftMaxValue[2] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[2] > MaxValue ){
				SoftMaxValue[2] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[2] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_3->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[2] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_3->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[2] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_3->text();
			SoftMinValue[2] = qt_str.toULong(0,16);
			SoftMinValue[2] = SoftMinValue[2] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_3->text();
			SoftMinValue[2] = SoftMinValue[2] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_3->text();
			SoftMaxValue[2] = qt_str.toULong(0,16);
			SoftMaxValue[2] = SoftMaxValue[2] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_3->text();
			SoftMaxValue[2] = SoftMaxValue[2] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[2] > MaxValue ){
				SoftMaxValue[2] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[2] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_3->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[2] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_3->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[2] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_3->text() + " " + ui.txtSWfilterFromId_3->text()
				 + " to " + ui.txtSWfilterToCobId_3->text() + " " + ui.txtSWfilterToId_3->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_3->setText("Enable");
		ui.cbbSWfilterType_3->setEnabled(true);
		ui.txtSWfilterFromCobId_3->setEnabled(true);
		ui.txtSWfilterFromId_3->setEnabled(true);
		ui.txtSWfilterToCobId_3->setEnabled(true);
		ui.txtSWfilterToId_3->setEnabled(true);

		SoftSet[2] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_4
void RxDataFilter::btnSWfilterSetReset_4_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_4->text() == "Enable" ){
		ui.btnSWfilterSetReset_4->setText("Disable");
		ui.cbbSWfilterType_4->setEnabled(false);
		ui.txtSWfilterFromCobId_4->setEnabled(false);
		ui.txtSWfilterFromId_4->setEnabled(false);
		ui.txtSWfilterToCobId_4->setEnabled(false);
		ui.txtSWfilterToId_4->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_4->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[3] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_4->text();
			SoftMinValue[3] = qt_str.toULong(0,16);
			SoftMinValue[3] = SoftMinValue[3] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_4->text();
			SoftMinValue[3] = SoftMinValue[3] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_4->text();
			SoftMaxValue[3] = qt_str.toULong(0,16);
			SoftMaxValue[3] = SoftMaxValue[3] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_4->text();
			SoftMaxValue[3] = SoftMaxValue[3] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[3] > MaxValue ){
				SoftMaxValue[3] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[3] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_4->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[3] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_4->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[3] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_4->text();
			SoftMinValue[3] = qt_str.toULong(0,16);
			SoftMinValue[3] = SoftMinValue[3] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_4->text();
			SoftMinValue[3] = SoftMinValue[3] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_4->text();
			SoftMaxValue[3] = qt_str.toULong(0,16);
			SoftMaxValue[3] = SoftMaxValue[3] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_4->text();
			SoftMaxValue[3] = SoftMaxValue[3] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[3] > MaxValue ){
				SoftMaxValue[3] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[3] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_4->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[3] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_4->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[3] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_4->text() + " " + ui.txtSWfilterFromId_4->text()
				 + " to " + ui.txtSWfilterToCobId_4->text() + " " + ui.txtSWfilterToId_4->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_4->setText("Enable");
		ui.cbbSWfilterType_4->setEnabled(true);
		ui.txtSWfilterFromCobId_4->setEnabled(true);
		ui.txtSWfilterFromId_4->setEnabled(true);
		ui.txtSWfilterToCobId_4->setEnabled(true);
		ui.txtSWfilterToId_4->setEnabled(true);

		SoftSet[3] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_5
void RxDataFilter::btnSWfilterSetReset_5_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_5->text() == "Enable" ){
		ui.btnSWfilterSetReset_5->setText("Disable");
		ui.cbbSWfilterType_5->setEnabled(false);
		ui.txtSWfilterFromCobId_5->setEnabled(false);
		ui.txtSWfilterFromId_5->setEnabled(false);
		ui.txtSWfilterToCobId_5->setEnabled(false);
		ui.txtSWfilterToId_5->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_5->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[4] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_5->text();
			SoftMinValue[4] = qt_str.toULong(0,16);
			SoftMinValue[4] = SoftMinValue[4] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_5->text();
			SoftMinValue[4] = SoftMinValue[4] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_5->text();
			SoftMaxValue[4] = qt_str.toULong(0,16);
			SoftMaxValue[4] = SoftMaxValue[4] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_5->text();
			SoftMaxValue[4] = SoftMaxValue[4] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[4] > MaxValue ){
				SoftMaxValue[4] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[4] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_5->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[4] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_5->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[4] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_5->text();
			SoftMinValue[4] = qt_str.toULong(0,16);
			SoftMinValue[4] = SoftMinValue[4] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_5->text();
			SoftMinValue[4] = SoftMinValue[4] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_5->text();
			SoftMaxValue[4] = qt_str.toULong(0,16);
			SoftMaxValue[4] = SoftMaxValue[4] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_5->text();
			SoftMaxValue[4] = SoftMaxValue[4] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[4] > MaxValue ){
				SoftMaxValue[4] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[4] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_5->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[4] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_5->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[4] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_5->text() + " " + ui.txtSWfilterFromId_5->text()
				 + " to " + ui.txtSWfilterToCobId_5->text() + " " + ui.txtSWfilterToId_5->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_5->setText("Enable");
		ui.cbbSWfilterType_5->setEnabled(true);
		ui.txtSWfilterFromCobId_5->setEnabled(true);
		ui.txtSWfilterFromId_5->setEnabled(true);
		ui.txtSWfilterToCobId_5->setEnabled(true);
		ui.txtSWfilterToId_5->setEnabled(true);

		SoftSet[4] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_6
void RxDataFilter::btnSWfilterSetReset_6_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_6->text() == "Enable" ){
		ui.btnSWfilterSetReset_6->setText("Disable");
		ui.cbbSWfilterType_6->setEnabled(false);
		ui.txtSWfilterFromCobId_6->setEnabled(false);
		ui.txtSWfilterFromId_6->setEnabled(false);
		ui.txtSWfilterToCobId_6->setEnabled(false);
		ui.txtSWfilterToId_6->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_6->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[5] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_6->text();
			SoftMinValue[5] = qt_str.toULong(0,16);
			SoftMinValue[5] = SoftMinValue[5] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_6->text();
			SoftMinValue[5] = SoftMinValue[5] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_6->text();
			SoftMaxValue[5] = qt_str.toULong(0,16);
			SoftMaxValue[5] = SoftMaxValue[5] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_6->text();
			SoftMaxValue[5] = SoftMaxValue[5] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[5] > MaxValue ){
				SoftMaxValue[5] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[5] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_6->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[5] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_6->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[5] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_6->text();
			SoftMinValue[5] = qt_str.toULong(0,16);
			SoftMinValue[5] = SoftMinValue[5] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_6->text();
			SoftMinValue[5] = SoftMinValue[5] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_6->text();
			SoftMaxValue[5] = qt_str.toULong(0,16);
			SoftMaxValue[5] = SoftMaxValue[5] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_6->text();
			SoftMaxValue[5] = SoftMaxValue[5] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[5] > MaxValue ){
				SoftMaxValue[5] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[5] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_6->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[5] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_6->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[5] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_6->text() + " " + ui.txtSWfilterFromId_6->text()
				 + " to " + ui.txtSWfilterToCobId_6->text() + " " + ui.txtSWfilterToId_6->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_6->setText("Enable");
		ui.cbbSWfilterType_6->setEnabled(true);
		ui.txtSWfilterFromCobId_6->setEnabled(true);
		ui.txtSWfilterFromId_6->setEnabled(true);
		ui.txtSWfilterToCobId_6->setEnabled(true);
		ui.txtSWfilterToId_6->setEnabled(true);

		SoftSet[5] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_7
void RxDataFilter::btnSWfilterSetReset_7_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_7->text() == "Enable" ){
		ui.btnSWfilterSetReset_7->setText("Disable");
		ui.cbbSWfilterType_7->setEnabled(false);
		ui.txtSWfilterFromCobId_7->setEnabled(false);
		ui.txtSWfilterFromId_7->setEnabled(false);
		ui.txtSWfilterToCobId_7->setEnabled(false);
		ui.txtSWfilterToId_7->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_7->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[6] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_7->text();
			SoftMinValue[6] = qt_str.toULong(0,16);
			SoftMinValue[6] = SoftMinValue[6] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_7->text();
			SoftMinValue[6] = SoftMinValue[6] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_7->text();
			SoftMaxValue[6] = qt_str.toULong(0,16);
			SoftMaxValue[6] = SoftMaxValue[6] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_7->text();
			SoftMaxValue[6] = SoftMaxValue[6] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[6] > MaxValue ){
				SoftMaxValue[6] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[6] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_7->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[6] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_7->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[6] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_7->text();
			SoftMinValue[6] = qt_str.toULong(0,16);
			SoftMinValue[6] = SoftMinValue[6] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_7->text();
			SoftMinValue[6] = SoftMinValue[6] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_7->text();
			SoftMaxValue[6] = qt_str.toULong(0,16);
			SoftMaxValue[6] = SoftMaxValue[6] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_7->text();
			SoftMaxValue[6] = SoftMaxValue[6] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[6] > MaxValue ){
				SoftMaxValue[6] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[6] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_7->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[6] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_7->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[6] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_7->text() + " " + ui.txtSWfilterFromId_7->text()
				 + " to " + ui.txtSWfilterToCobId_7->text() + " " + ui.txtSWfilterToId_7->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_7->setText("Enable");
		ui.cbbSWfilterType_7->setEnabled(true);
		ui.txtSWfilterFromCobId_7->setEnabled(true);
		ui.txtSWfilterFromId_7->setEnabled(true);
		ui.txtSWfilterToCobId_7->setEnabled(true);
		ui.txtSWfilterToId_7->setEnabled(true);

		SoftSet[6] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_8
void RxDataFilter::btnSWfilterSetReset_8_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_8->text() == "Enable" ){
		ui.btnSWfilterSetReset_8->setText("Disable");
		ui.cbbSWfilterType_8->setEnabled(false);
		ui.txtSWfilterFromCobId_8->setEnabled(false);
		ui.txtSWfilterFromId_8->setEnabled(false);
		ui.txtSWfilterToCobId_8->setEnabled(false);
		ui.txtSWfilterToId_8->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_8->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[7] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_8->text();
			SoftMinValue[7] = qt_str.toULong(0,16);
			SoftMinValue[7] = SoftMinValue[7] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_8->text();
			SoftMinValue[7] = SoftMinValue[7] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_8->text();
			SoftMaxValue[7] = qt_str.toULong(0,16);
			SoftMaxValue[7] = SoftMaxValue[7] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_8->text();
			SoftMaxValue[7] = SoftMaxValue[7] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[7] > MaxValue ){
				SoftMaxValue[7] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[7] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_8->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[7] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_8->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[7] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_8->text();
			SoftMinValue[7] = qt_str.toULong(0,16);
			SoftMinValue[7] = SoftMinValue[7] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_8->text();
			SoftMinValue[7] = SoftMinValue[7] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_8->text();
			SoftMaxValue[7] = qt_str.toULong(0,16);
			SoftMaxValue[7] = SoftMaxValue[7] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_8->text();
			SoftMaxValue[7] = SoftMaxValue[7] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[7] > MaxValue ){
				SoftMaxValue[7] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[7] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_8->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[7] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_8->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[7] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_8->text() + " " + ui.txtSWfilterFromId_8->text()
				 + " to " + ui.txtSWfilterToCobId_8->text() + " " + ui.txtSWfilterToId_8->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_8->setText("Enable");
		ui.cbbSWfilterType_8->setEnabled(true);
		ui.txtSWfilterFromCobId_8->setEnabled(true);
		ui.txtSWfilterFromId_8->setEnabled(true);
		ui.txtSWfilterToCobId_8->setEnabled(true);
		ui.txtSWfilterToId_8->setEnabled(true);

		SoftSet[7] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_9
void RxDataFilter::btnSWfilterSetReset_9_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_9->text() == "Enable" ){
		ui.btnSWfilterSetReset_9->setText("Disable");
		ui.cbbSWfilterType_9->setEnabled(false);
		ui.txtSWfilterFromCobId_9->setEnabled(false);
		ui.txtSWfilterFromId_9->setEnabled(false);
		ui.txtSWfilterToCobId_9->setEnabled(false);
		ui.txtSWfilterToId_9->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_9->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[8] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_9->text();
			SoftMinValue[8] = qt_str.toULong(0,16);
			SoftMinValue[8] = SoftMinValue[8] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_9->text();
			SoftMinValue[8] = SoftMinValue[8] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_9->text();
			SoftMaxValue[8] = qt_str.toULong(0,16);
			SoftMaxValue[8] = SoftMaxValue[8] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_9->text();
			SoftMaxValue[8] = SoftMaxValue[8] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[8] > MaxValue ){
				SoftMaxValue[8] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[8] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_9->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[8] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_9->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[8] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_9->text();
			SoftMinValue[8] = qt_str.toULong(0,16);
			SoftMinValue[8] = SoftMinValue[8] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_9->text();
			SoftMinValue[8] = SoftMinValue[8] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_9->text();
			SoftMaxValue[8] = qt_str.toULong(0,16);
			SoftMaxValue[8] = SoftMaxValue[8] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_9->text();
			SoftMaxValue[8] = SoftMaxValue[8] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[8] > MaxValue ){
				SoftMaxValue[8] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[8] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_9->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[8] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_9->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[8] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_9->text() + " " + ui.txtSWfilterFromId_9->text()
				 + " to " + ui.txtSWfilterToCobId_9->text() + " " + ui.txtSWfilterToId_9->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_9->setText("Enable");
		ui.cbbSWfilterType_9->setEnabled(true);
		ui.txtSWfilterFromCobId_9->setEnabled(true);
		ui.txtSWfilterFromId_9->setEnabled(true);
		ui.txtSWfilterToCobId_9->setEnabled(true);
		ui.txtSWfilterToId_9->setEnabled(true);

		SoftSet[8] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// btnSWfilterSetReset_10
void RxDataFilter::btnSWfilterSetReset_10_Click()
{
	DWORD MaxValue;
	QString qt_str;

	// Set Select
	if( ui.btnSWfilterSetReset_10->text() == "Enable" ){
		ui.btnSWfilterSetReset_10->setText("Disable");
		ui.cbbSWfilterType_10->setEnabled(false);
		ui.txtSWfilterFromCobId_10->setEnabled(false);
		ui.txtSWfilterFromId_10->setEnabled(false);
		ui.txtSWfilterToCobId_10->setEnabled(false);
		ui.txtSWfilterToId_10->setEnabled(false);
		// Standard or Extended Select
		if( ui.cbbSWfilterType_10->currentIndex() == 0 ){
			// Standard Select
			SoftStandard[9] = 1;
			MaxValue = 0x7FF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_10->text();
			SoftMinValue[9] = qt_str.toULong(0,16);
			SoftMinValue[9] = SoftMinValue[9] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_10->text();
			SoftMinValue[9] = SoftMinValue[9] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_10->text();
			SoftMaxValue[9] = qt_str.toULong(0,16);
			SoftMaxValue[9] = SoftMaxValue[9] & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_10->text();
			SoftMaxValue[9] = SoftMaxValue[9] + ( qt_str.toULong(0,16) & pFcanView->StdNodeIDMask );
			if( SoftMaxValue[9] > MaxValue ){
				SoftMaxValue[9] = MaxValue;
				qt_str.sprintf("%03X", (SoftMaxValue[9] & pFcanView->StdCobIDMask));
				ui.txtSWfilterToCobId_10->setText(qt_str);
				qt_str.sprintf("%03X", (SoftMaxValue[9] & pFcanView->StdNodeIDMask));
				ui.txtSWfilterToId_10->setText(qt_str);
			}
		} else {
			// Extended Select
			SoftStandard[9] = 0;
			MaxValue = 0x1FFFFFFF;
			// MinValue Get
			qt_str = ui.txtSWfilterFromCobId_10->text();
			SoftMinValue[9] = qt_str.toULong(0,16);
			SoftMinValue[9] = SoftMinValue[9] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_10->text();
			SoftMinValue[9] = SoftMinValue[9] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			// MaxValue Get
			qt_str = ui.txtSWfilterToCobId_10->text();
			SoftMaxValue[9] = qt_str.toULong(0,16);
			SoftMaxValue[9] = SoftMaxValue[9] & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_10->text();
			SoftMaxValue[9] = SoftMaxValue[9] + ( qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask );
			if( SoftMaxValue[9] > MaxValue ){
				SoftMaxValue[9] = MaxValue;
				qt_str.sprintf("%08X", (SoftMaxValue[9] & pFcanView->ExtCobIDMask));
				ui.txtSWfilterToCobId_10->setText(qt_str);
				qt_str.sprintf("%08X", (SoftMaxValue[9] & pFcanView->ExtNodeIDMask));
				ui.txtSWfilterToId_10->setText(qt_str);
			}
		}
		// Set / Reset
		SoftSet[9] = 1;
		qt_str = "The SoftWare filter was customized. IDs from " + ui.txtSWfilterFromCobId_10->text() + " " + ui.txtSWfilterFromId_10->text()
				 + " to " + ui.txtSWfilterToCobId_10->text() + " " + ui.txtSWfilterToId_10->text() + " will be received";
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	} else {
	// Reset Select
		ui.btnSWfilterSetReset_10->setText("Enable");
		ui.cbbSWfilterType_10->setEnabled(true);
		ui.txtSWfilterFromCobId_10->setEnabled(true);
		ui.txtSWfilterFromId_10->setEnabled(true);
		ui.txtSWfilterToCobId_10->setEnabled(true);
		ui.txtSWfilterToId_10->setEnabled(true);

		SoftSet[9] = 0;

		pInformation->Information_set("");
		pInformation->Information_append("The SoftWare filter was Disable!!");

	}

}
// RxDataFilterInit
QString RxDataFilter::RxDataFilterInit(int mode, QString line)
{
	DWORD loop;
	DWORD inMaxValue;
	DWORD inMinValue;
	DWORD SaveValue;
	TPCANMode setMode;
	TPCANStatus stsResult;
	QMessageBox msgBox;
	QString qt_str;
	QString qt_ret;
	int ret;
	int index;
	int count;
	int error_flag;

	// Load Initialize Mode 
	if( mode == 0 ){
		error_flag = 0;
		QStringList coords = line.split(",");
		count = coords.size();
		if( count < 33 ){
			error_flag = 1;
			qt_str = "Error: Filter Initialize File Illegal Value!";
			qt_ret = QMessageBox::warning(this, tr("FilterInit"),
											qt_str,
											QMessageBox::Yes | QMessageBox::Default);
		} else {
			// HardwarefilterSet
			ret = ValueCheck(coords[1]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				inMinValue = coords[1].toULong(0,16);
			}
			ret = ValueCheck(coords[2]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				inMaxValue = coords[2].toULong(0,16);
			}
			if( error_flag == 0 ){
				if( coords[0] == "0" ){ 
					setMode = PCAN_MODE_STANDARD;
					stsResult = pHardware->btnSetFilter_Click(inMinValue, inMaxValue, setMode);
					if (stsResult != PCAN_ERROR_OK) {
						msgBox.setText("Error: The Hardware filter Customize Error!");
						ret = msgBox.exec();
					} else {
						// Filter From
						qt_str.sprintf("%03X", (inMinValue & pFcanView->StdCobIDMask));
						ui.txtHWfilterFromCobId->setText(qt_str);
						qt_str.sprintf("%03X", (inMinValue & pFcanView->StdNodeIDMask));
						ui.txtHWfilterFromId->setText(qt_str);
						// Filter To
						qt_str.sprintf("%03X", (inMaxValue & pFcanView->StdCobIDMask));
						ui.txtHWfilterToCobId->setText(qt_str);
						qt_str.sprintf("%03X", (inMaxValue & pFcanView->StdNodeIDMask));
						ui.txtHWfilterToId->setText(qt_str);
						// Set View
						ui.rdbHWfilterStandard->setChecked(true);
						ui.rdbHWfilterExtended->setChecked(false);
						ui.rdbHWfilterStandard->setEnabled(false);
						ui.rdbHWfilterExtended->setEnabled(false);
						ui.txtHWfilterFromCobId->setEnabled(false);
						ui.txtHWfilterFromId->setEnabled(false);
						ui.txtHWfilterToCobId->setEnabled(false);
						ui.txtHWfilterToId->setEnabled(false);
						ui.btnHWfilterSetReset->setEnabled(true);
						ui.btnHWfilterSetReset->setText("Disable");
					}
				} else if( coords[0] == "1" ){ 
					setMode = PCAN_MODE_EXTENDED;
					stsResult = pHardware->btnSetFilter_Click(inMinValue, inMaxValue, setMode);
					if (stsResult != PCAN_ERROR_OK) {
						msgBox.setText("Error: The Hardware filter Customize Error!");
						ret = msgBox.exec();
					} else {
						// Filter From
						qt_str.sprintf("%08X", (inMinValue & pFcanView->ExtCobIDMask));
						ui.txtHWfilterFromCobId->setText(qt_str);
						qt_str.sprintf("%08X", (inMinValue & pFcanView->ExtNodeIDMask));
						ui.txtHWfilterFromId->setText(qt_str);
						// Filter To
						qt_str.sprintf("%08X", (inMaxValue & pFcanView->ExtCobIDMask));
						ui.txtHWfilterToCobId->setText(qt_str);
						qt_str.sprintf("%08X", (inMaxValue & pFcanView->ExtNodeIDMask));
						ui.txtHWfilterToId->setText(qt_str);
						// Set View
						ui.rdbHWfilterStandard->setChecked(false);
						ui.rdbHWfilterExtended->setChecked(true);
						ui.rdbHWfilterStandard->setEnabled(false);
						ui.rdbHWfilterExtended->setEnabled(false);
						ui.txtHWfilterFromCobId->setEnabled(false);
						ui.txtHWfilterFromId->setEnabled(false);
						ui.txtHWfilterToCobId->setEnabled(false);
						ui.txtHWfilterToId->setEnabled(false);
						ui.btnHWfilterSetReset->setEnabled(true);
						ui.btnHWfilterSetReset->setText("Disable");
					}
				} else if( coords[0] == "2" ){ 
					// Filter From
					qt_str.sprintf("%03X", (inMinValue & pFcanView->StdCobIDMask));
					ui.txtHWfilterFromCobId->setText(qt_str);
					qt_str.sprintf("%03X", (inMinValue & pFcanView->StdNodeIDMask));
					ui.txtHWfilterFromId->setText(qt_str);
					// Filter To
					qt_str.sprintf("%03X", (inMaxValue & pFcanView->StdCobIDMask));
					ui.txtHWfilterToCobId->setText(qt_str);
					qt_str.sprintf("%03X", (inMaxValue & pFcanView->StdNodeIDMask));
					ui.txtHWfilterToId->setText(qt_str);
					// Set View
					ui.rdbHWfilterStandard->setChecked(true);
					ui.rdbHWfilterExtended->setChecked(false);
					ui.rdbHWfilterStandard->setEnabled(true);
					ui.rdbHWfilterExtended->setEnabled(true);
					ui.txtHWfilterFromCobId->setEnabled(true);
					ui.txtHWfilterFromId->setEnabled(true);
					ui.txtHWfilterToCobId->setEnabled(true);
					ui.txtHWfilterToId->setEnabled(true);
					ui.btnHWfilterSetReset->setEnabled(true);
					ui.btnHWfilterSetReset->setText("Enable");
				} else { 
					// Filter From
					qt_str.sprintf("%08X", (inMinValue & pFcanView->ExtCobIDMask));
					ui.txtHWfilterFromCobId->setText(qt_str);
					qt_str.sprintf("%08X", (inMinValue & pFcanView->ExtNodeIDMask));
					ui.txtHWfilterFromId->setText(qt_str);
					// Filter To
					qt_str.sprintf("%08X", (inMaxValue & pFcanView->ExtCobIDMask));
					ui.txtHWfilterToCobId->setText(qt_str);
					qt_str.sprintf("%08X", (inMaxValue & pFcanView->ExtNodeIDMask));
					ui.txtHWfilterToId->setText(qt_str);
					// Set View
					ui.rdbHWfilterStandard->setChecked(false);
					ui.rdbHWfilterExtended->setChecked(true);
					ui.rdbHWfilterStandard->setEnabled(true);
					ui.rdbHWfilterExtended->setEnabled(true);
					ui.txtHWfilterFromCobId->setEnabled(true);
					ui.txtHWfilterFromId->setEnabled(true);
					ui.txtHWfilterToCobId->setEnabled(true);
					ui.txtHWfilterToId->setEnabled(true);
					ui.btnHWfilterSetReset->setEnabled(true);
					ui.btnHWfilterSetReset->setText("Enable");
				}
			} else {
				qt_str = "Error: Hardware Filter Initialize Illegal Value!";
				qt_ret = QMessageBox::warning(this, tr("FilterInit"),
												qt_str,
												QMessageBox::Yes | QMessageBox::Default);
			}
			// SoftWarefilterSet
//			error_flag = 0;
			for( loop = 0; loop < 10; ++loop ){
				ret = ValueCheck(coords[(3*loop)+4]);
				if( ret == 1 ){
					error_flag = 1;
					inMinValue = 0;
				} else {
					inMinValue = coords[(3*loop)+4].toULong(0,16);
				}
				ret = ValueCheck(coords[(3*loop)+5]);
				if( ret == 1 ){
					error_flag = 1;
					inMaxValue = 0x7FF;
				} else {
					inMaxValue = coords[(3*loop)+5].toULong(0,16);
				}
				if( error_flag == 0 ){
					if( coords[(3*loop)+3] == "0" ){ 
						SoftMinValue[loop] = inMinValue;
						SoftMaxValue[loop] = inMaxValue;
						SoftStandard[loop] = 1;
						SoftSet[loop] = 1;
					} else if( coords[(3*loop)+3] == "1" ){ 
						SoftMinValue[loop] = inMinValue;
						SoftMaxValue[loop] = inMaxValue;
						SoftStandard[loop] = 0;
						SoftSet[loop] = 1;
					} else if( coords[(3*loop)+3] == "2" ){ 
						SoftMinValue[loop] = inMinValue;
						SoftMaxValue[loop] = inMaxValue;
						SoftStandard[loop] = 1;
						SoftSet[loop] = 0;
					} else { 
						SoftMinValue[loop] = inMinValue;
						SoftMaxValue[loop] = inMaxValue;
						SoftStandard[loop] = 0;
						SoftSet[loop] = 0;
					}
				}
			}

			if( error_flag == 0 ){
				// SoftFilter 1
				if( SoftSet[0] == 1 ){
					ui.btnSWfilterSetReset_1->setText("Disable");
					ui.cbbSWfilterType_1->setEnabled(false);
					ui.txtSWfilterFromCobId_1->setEnabled(false);
					ui.txtSWfilterFromId_1->setEnabled(false);
					ui.txtSWfilterToCobId_1->setEnabled(false);
					ui.txtSWfilterToId_1->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_1->setText("Enable");
					ui.cbbSWfilterType_1->setEnabled(true);
					ui.txtSWfilterFromCobId_1->setEnabled(true);
					ui.txtSWfilterFromId_1->setEnabled(true);
					ui.txtSWfilterToCobId_1->setEnabled(true);
					ui.txtSWfilterToId_1->setEnabled(true);
				}
				if( SoftStandard[0] == 1 ){
					ui.cbbSWfilterType_1->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[0] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_1->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[0] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_1->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[0] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_1->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[0] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_1->setText(qt_str);
				} else {
					ui.cbbSWfilterType_1->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[0] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_1->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[0] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_1->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[0] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_1->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[0] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_1->setText(qt_str);
				}
				// SoftFilter 2
				if( SoftSet[1] == 1 ){
					ui.btnSWfilterSetReset_2->setText("Disable");
					ui.cbbSWfilterType_2->setEnabled(false);
					ui.txtSWfilterFromCobId_2->setEnabled(false);
					ui.txtSWfilterFromId_2->setEnabled(false);
					ui.txtSWfilterToCobId_2->setEnabled(false);
					ui.txtSWfilterToId_2->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_2->setText("Enable");
					ui.cbbSWfilterType_2->setEnabled(true);
					ui.txtSWfilterFromCobId_2->setEnabled(true);
					ui.txtSWfilterFromId_2->setEnabled(true);
					ui.txtSWfilterToCobId_2->setEnabled(true);
					ui.txtSWfilterToId_2->setEnabled(true);
				}
				if( SoftStandard[1] == 1 ){
					ui.cbbSWfilterType_2->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[1] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_2->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[1] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_2->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[1] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_2->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[1] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_2->setText(qt_str);
				} else {
					ui.cbbSWfilterType_2->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[1] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_2->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[1] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_2->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[1] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_2->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[1] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_2->setText(qt_str);
				}
				// SoftFilter 3
				if( SoftSet[2] == 1 ){
					ui.btnSWfilterSetReset_3->setText("Disable");
					ui.cbbSWfilterType_3->setEnabled(false);
					ui.txtSWfilterFromCobId_3->setEnabled(false);
					ui.txtSWfilterFromId_3->setEnabled(false);
					ui.txtSWfilterToCobId_3->setEnabled(false);
					ui.txtSWfilterToId_3->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_3->setText("Enable");
					ui.cbbSWfilterType_3->setEnabled(true);
					ui.txtSWfilterFromCobId_3->setEnabled(true);
					ui.txtSWfilterFromId_3->setEnabled(true);
					ui.txtSWfilterToCobId_3->setEnabled(true);
					ui.txtSWfilterToId_3->setEnabled(true);
				}
				if( SoftStandard[2] == 1 ){
					ui.cbbSWfilterType_3->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[2] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_3->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[2] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_3->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[2] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_3->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[2] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_3->setText(qt_str);
				} else {
					ui.cbbSWfilterType_3->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[2] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_3->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[2] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_3->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[2] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_3->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[2] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_3->setText(qt_str);
				}
				// SoftFilter 4
				if( SoftSet[3] == 1 ){
					ui.btnSWfilterSetReset_4->setText("Disable");
					ui.cbbSWfilterType_4->setEnabled(false);
					ui.txtSWfilterFromCobId_4->setEnabled(false);
					ui.txtSWfilterFromId_4->setEnabled(false);
					ui.txtSWfilterToCobId_4->setEnabled(false);
					ui.txtSWfilterToId_4->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_4->setText("Enable");
					ui.cbbSWfilterType_4->setEnabled(true);
					ui.txtSWfilterFromCobId_4->setEnabled(true);
					ui.txtSWfilterFromId_4->setEnabled(true);
					ui.txtSWfilterToCobId_4->setEnabled(true);
					ui.txtSWfilterToId_4->setEnabled(true);
				}
				if( SoftStandard[3] == 1 ){
					ui.cbbSWfilterType_4->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[3] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_4->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[3] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_4->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[3] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_4->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[3] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_4->setText(qt_str);
				} else {
					ui.cbbSWfilterType_4->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[3] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_4->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[3] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_4->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[3] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_4->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[3] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_4->setText(qt_str);
				}
				// SoftFilter 5
				if( SoftSet[4] == 1 ){
					ui.btnSWfilterSetReset_5->setText("Disable");
					ui.cbbSWfilterType_5->setEnabled(false);
					ui.txtSWfilterFromCobId_5->setEnabled(false);
					ui.txtSWfilterFromId_5->setEnabled(false);
					ui.txtSWfilterToCobId_5->setEnabled(false);
					ui.txtSWfilterToId_5->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_5->setText("Enable");
					ui.cbbSWfilterType_5->setEnabled(true);
					ui.txtSWfilterFromCobId_5->setEnabled(true);
					ui.txtSWfilterFromId_5->setEnabled(true);
					ui.txtSWfilterToCobId_5->setEnabled(true);
					ui.txtSWfilterToId_5->setEnabled(true);
				}
				if( SoftStandard[4] == 1 ){
					ui.cbbSWfilterType_5->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[4] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_5->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[4] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_5->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[4] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_5->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[4] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_5->setText(qt_str);
				} else {
					ui.cbbSWfilterType_5->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[4] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_5->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[4] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_5->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[4] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_5->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[4] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_5->setText(qt_str);
				}
				// SoftFilter 6
				if( SoftSet[5] == 1 ){
					ui.btnSWfilterSetReset_6->setText("Disable");
					ui.cbbSWfilterType_6->setEnabled(false);
					ui.txtSWfilterFromCobId_6->setEnabled(false);
					ui.txtSWfilterFromId_6->setEnabled(false);
					ui.txtSWfilterToCobId_6->setEnabled(false);
					ui.txtSWfilterToId_6->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_6->setText("Enable");
					ui.cbbSWfilterType_6->setEnabled(true);
					ui.txtSWfilterFromCobId_6->setEnabled(true);
					ui.txtSWfilterFromId_6->setEnabled(true);
					ui.txtSWfilterToCobId_6->setEnabled(true);
					ui.txtSWfilterToId_6->setEnabled(true);
				}
				if( SoftStandard[5] == 1 ){
					ui.cbbSWfilterType_6->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[5] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_6->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[5] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_6->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[5] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_6->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[5] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_6->setText(qt_str);
				} else {
					ui.cbbSWfilterType_6->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[5] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_6->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[5] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_6->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[5] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_6->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[5] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_6->setText(qt_str);
				}
				// SoftFilter 7
				if( SoftSet[6] == 1 ){
					ui.btnSWfilterSetReset_7->setText("Disable");
					ui.cbbSWfilterType_7->setEnabled(false);
					ui.txtSWfilterFromCobId_7->setEnabled(false);
					ui.txtSWfilterFromId_7->setEnabled(false);
					ui.txtSWfilterToCobId_7->setEnabled(false);
					ui.txtSWfilterToId_7->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_7->setText("Enable");
					ui.cbbSWfilterType_7->setEnabled(true);
					ui.txtSWfilterFromCobId_7->setEnabled(true);
					ui.txtSWfilterFromId_7->setEnabled(true);
					ui.txtSWfilterToCobId_7->setEnabled(true);
					ui.txtSWfilterToId_7->setEnabled(true);
				}
				if( SoftStandard[6] == 1 ){
					ui.cbbSWfilterType_7->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[6] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_7->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[6] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_7->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[6] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_7->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[6] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_7->setText(qt_str);
				} else {
					ui.cbbSWfilterType_7->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[6] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_7->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[6] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_7->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[6] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_7->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[6] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_7->setText(qt_str);
				}
				// SoftFilter 8
				if( SoftSet[7] == 1 ){
					ui.btnSWfilterSetReset_8->setText("Disable");
					ui.cbbSWfilterType_8->setEnabled(false);
					ui.txtSWfilterFromCobId_8->setEnabled(false);
					ui.txtSWfilterFromId_8->setEnabled(false);
					ui.txtSWfilterToCobId_8->setEnabled(false);
					ui.txtSWfilterToId_8->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_8->setText("Enable");
					ui.cbbSWfilterType_8->setEnabled(true);
					ui.txtSWfilterFromCobId_8->setEnabled(true);
					ui.txtSWfilterFromId_8->setEnabled(true);
					ui.txtSWfilterToCobId_8->setEnabled(true);
					ui.txtSWfilterToId_8->setEnabled(true);
				}
				if( SoftStandard[7] == 1 ){
					ui.cbbSWfilterType_8->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[7] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_8->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[7] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_8->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[7] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_8->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[7] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_8->setText(qt_str);
				} else {
					ui.cbbSWfilterType_8->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[7] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_8->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[7] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_8->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[7] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_8->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[7] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_8->setText(qt_str);
				}
				// SoftFilter 9
				if( SoftSet[8] == 1 ){
					ui.btnSWfilterSetReset_9->setText("Disable");
					ui.cbbSWfilterType_9->setEnabled(false);
					ui.txtSWfilterFromCobId_9->setEnabled(false);
					ui.txtSWfilterFromId_9->setEnabled(false);
					ui.txtSWfilterToCobId_9->setEnabled(false);
					ui.txtSWfilterToId_9->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_9->setText("Enable");
					ui.cbbSWfilterType_9->setEnabled(true);
					ui.txtSWfilterFromCobId_9->setEnabled(true);
					ui.txtSWfilterFromId_9->setEnabled(true);
					ui.txtSWfilterToCobId_9->setEnabled(true);
					ui.txtSWfilterToId_9->setEnabled(true);
				}
				if( SoftStandard[8] == 1 ){
					ui.cbbSWfilterType_9->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[8] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_9->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[8] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_9->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[8] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_9->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[8] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_9->setText(qt_str);
				} else {
					ui.cbbSWfilterType_9->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[8] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_9->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[8] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_9->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[8] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_9->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[8] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_9->setText(qt_str);
				}
				// SoftFilter 10
				if( SoftSet[9] == 1 ){
					ui.btnSWfilterSetReset_10->setText("Disable");
					ui.cbbSWfilterType_10->setEnabled(false);
					ui.txtSWfilterFromCobId_10->setEnabled(false);
					ui.txtSWfilterFromId_10->setEnabled(false);
					ui.txtSWfilterToCobId_10->setEnabled(false);
					ui.txtSWfilterToId_10->setEnabled(false);
				} else {
					ui.btnSWfilterSetReset_10->setText("Enable");
					ui.cbbSWfilterType_10->setEnabled(true);
					ui.txtSWfilterFromCobId_10->setEnabled(true);
					ui.txtSWfilterFromId_10->setEnabled(true);
					ui.txtSWfilterToCobId_10->setEnabled(true);
					ui.txtSWfilterToId_10->setEnabled(true);
				}
				if( SoftStandard[9] == 1 ){
					ui.cbbSWfilterType_10->setCurrentIndex(0); 
					qt_str.sprintf("%03X", (SoftMinValue[9] & pFcanView->StdCobIDMask));
					ui.txtSWfilterFromCobId_10->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMinValue[9] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterFromId_10->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[9] & pFcanView->StdCobIDMask));
					ui.txtSWfilterToCobId_10->setText(qt_str);
					qt_str.sprintf("%03X", (SoftMaxValue[9] & pFcanView->StdNodeIDMask));
					ui.txtSWfilterToId_10->setText(qt_str);
				} else {
					ui.cbbSWfilterType_10->setCurrentIndex(1); 
					qt_str.sprintf("%08X", (SoftMinValue[9] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterFromCobId_10->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMinValue[9] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterFromId_10->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[9] & pFcanView->ExtCobIDMask));
					ui.txtSWfilterToCobId_10->setText(qt_str);
					qt_str.sprintf("%08X", (SoftMaxValue[9] & pFcanView->ExtNodeIDMask));
					ui.txtSWfilterToId_10->setText(qt_str);
				}
			} else {
				qt_str = "Error: Software Filter Initialize Illegal Value!";
				qt_ret = QMessageBox::warning(this, tr("FilterInit"),
												qt_str,
												QMessageBox::Yes | QMessageBox::Default);
			}
		}
		qt_ret = "";
	// Save Initialize Mode 
	} else {
		// Hardwarefilter
		if( ui.btnHWfilterSetReset->text() == "Enable" ){
			if( ui.rdbHWfilterStandard->isChecked() ){
				qt_ret = "2,";
			} else {
				qt_ret = "3,";
			}
		} else {
			if( ui.rdbHWfilterStandard->isChecked() ){
				qt_ret = "0,";
			} else {
				qt_ret = "1,";
			}
		}
		if( ui.rdbHWfilterStandard->isChecked() ){
			// Min
			qt_str = ui.txtHWfilterFromCobId->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtHWfilterFromId->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtHWfilterToCobId->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtHWfilterToId->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtHWfilterFromCobId->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtHWfilterFromId->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtHWfilterToCobId->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtHWfilterToId->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter1
		if( SoftSet[0] == 0 ){
			if( ui.cbbSWfilterType_1->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_1->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_1->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_1->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_1->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_1->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_1->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_1->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_1->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_1->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_1->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter2
		if( SoftSet[1] == 0 ){
			if( ui.cbbSWfilterType_2->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_2->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_2->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_2->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_2->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_2->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_2->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_2->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_2->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_2->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_2->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter3
		if( SoftSet[2] == 0 ){
			if( ui.cbbSWfilterType_3->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_3->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_3->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_3->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_3->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_3->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_3->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_3->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_3->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_3->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_3->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter4
		if( SoftSet[3] == 0 ){
			if( ui.cbbSWfilterType_4->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_4->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_4->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_4->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_4->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_4->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_4->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_4->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_4->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_4->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_4->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter5
		if( SoftSet[4] == 0 ){
			if( ui.cbbSWfilterType_5->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_5->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_5->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_5->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_5->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_5->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_5->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_5->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_5->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_5->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_5->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter6
		if( SoftSet[5] == 0 ){
			if( ui.cbbSWfilterType_6->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_6->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_6->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_6->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_6->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_6->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_6->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_6->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_6->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_6->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_6->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter7
		if( SoftSet[6] == 0 ){
			if( ui.cbbSWfilterType_7->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_7->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_7->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_7->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_7->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_7->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_7->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_7->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_7->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_7->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_7->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter8
		if( SoftSet[7] == 0 ){
			if( ui.cbbSWfilterType_8->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_8->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_8->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_8->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_8->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_8->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_8->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_8->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_8->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_8->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_8->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter9
		if( SoftSet[8] == 0 ){
			if( ui.cbbSWfilterType_9->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_9->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_9->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_9->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_9->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_9->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_9->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_9->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_9->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_9->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_9->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		// SoftWarefilter10
		if( SoftSet[9] == 0 ){
			if( ui.cbbSWfilterType_10->currentIndex() == 0 ){
				qt_ret = qt_ret + ",2,";
			} else {
				qt_ret = qt_ret + ",3,";
			}
		} else {
			if( ui.cbbSWfilterType_10->currentIndex() == 0 ){
				qt_ret = qt_ret + ",0,";
			} else {
				qt_ret = qt_ret + ",1,";
			}
		}
		if( ui.cbbSWfilterType_10->currentIndex() == 0 ){
			// Min
			qt_str = ui.txtSWfilterFromCobId_10->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterFromId_10->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_10->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->StdCobIDMask;
			qt_str = ui.txtSWfilterToId_10->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->StdNodeIDMask);
			qt_str.sprintf("%03X", SaveValue);
			qt_ret = qt_ret + qt_str;
		} else {
			// Min
			qt_str = ui.txtSWfilterFromCobId_10->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterFromId_10->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str + ",";
			// Max
			qt_str = ui.txtSWfilterToCobId_10->text();
			SaveValue = qt_str.toULong(0,16);
			SaveValue = SaveValue & pFcanView->ExtCobIDMask;
			qt_str = ui.txtSWfilterToId_10->text();
			SaveValue = SaveValue + (qt_str.toULong(0,16) & pFcanView->ExtNodeIDMask);
			qt_str.sprintf("%08X", SaveValue);
			qt_ret = qt_ret + qt_str;
		}

		qt_ret = qt_ret + "\n";
	}

	return qt_ret;

}

int RxDataFilter::ValueCheck(QString ValueString)
{
	int error_flag;
	int loop;
	int ValueLength;
	QString GetValue;

	error_flag = 1;
	ValueLength = ValueString.length();
	for( loop=0; loop<ValueLength; loop=loop+1 ){
		GetValue = ValueString[loop];
		if( "0" == GetValue ){        error_flag = 0;
		} else if( "1" == GetValue ){ error_flag = 0;
		} else if( "2" == GetValue ){ error_flag = 0;
		} else if( "3" == GetValue ){ error_flag = 0;
		} else if( "4" == GetValue ){ error_flag = 0;
		} else if( "5" == GetValue ){ error_flag = 0;
		} else if( "6" == GetValue ){ error_flag = 0;
		} else if( "7" == GetValue ){ error_flag = 0;
		} else if( "8" == GetValue ){ error_flag = 0;
		} else if( "9" == GetValue ){ error_flag = 0;
		} else if( "a" == GetValue ){ error_flag = 0;
		} else if( "b" == GetValue ){ error_flag = 0;
		} else if( "c" == GetValue ){ error_flag = 0;
		} else if( "d" == GetValue ){ error_flag = 0;
		} else if( "e" == GetValue ){ error_flag = 0;
		} else if( "f" == GetValue ){ error_flag = 0;
		} else if( "A" == GetValue ){ error_flag = 0;
		} else if( "B" == GetValue ){ error_flag = 0;
		} else if( "C" == GetValue ){ error_flag = 0;
		} else if( "D" == GetValue ){ error_flag = 0;
		} else if( "E" == GetValue ){ error_flag = 0;
		} else if( "F" == GetValue ){ error_flag = 0;
		} else {
			error_flag = 1;
			break;
		}
	}
	return error_flag;

}

////////////////////////////////////////
// Setting Menu
////////////////////////////////////////
void RxDataFilter::createMenus()
{
	QMenu   * pMenu;

	//File Menu
	pMenu = ui.menuBar->addMenu( tr("File") );
	SettingMenu.pMenu = pMenu;
    connect(pMenu, SIGNAL(aboutToShow()), this, SLOT(menu_triggered()));

	createMenuActions();

}
void RxDataFilter::createMenuActions()
{
	QAction * pAction;
	QString qt_str;

	/* Clear */
	SettingMenu.pMenu->clear( );
	
	/* Load File */
	pAction = new QAction( tr("Open File"), this );
	pAction->setShortcut(tr("Ctrl+O"));
	SettingMenu.pLoadFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_loadfile()));

	/* Save File */
	pAction = new QAction( tr("Save File"), this );
	pAction->setShortcut(tr("Ctrl+S"));
	SettingMenu.pSaveFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_savefile()));

}

////////////////////////////////////////
// Menu Action
////////////////////////////////////////
void RxDataFilter::menu_triggered()
{
	createMenuActions();
}
void RxDataFilter::menu_loadfile()
{
	DWORD loop;
	QString qt_str;
	QString line;
	QString qt_ret;

	// File Select
	QString fileName = QFileDialog::getOpenFileName(
														this,
					   									tr("Load File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile LoadFile(fileName);

	// File Read
	if (LoadFile.open(QIODevice::ReadOnly)) {
		QTextStream in(&LoadFile);
		qt_str = "";
		for( loop = 0; loop < 11; ++loop ){
			line = in.readLine();
			qt_str = qt_str + line + ",";
		}
		// Load Setting
		qt_ret = RxDataFilterInit(0, qt_str);
		// File Close
		LoadFile.close();
		// File Close
		pInformation->Information_append("Load File successfully");
	} else {
		pInformation->Information_append("Can not open load file");
	}

}
void RxDataFilter::menu_savefile()
{
	DWORD loop;
	QString qt_str;
	QString line;
	QString qt_ret;

	// File Select
	QString fileName = QFileDialog::getSaveFileName(
														this,
					   									tr("Save File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile SaveFile(fileName);

	// File Write
	if(SaveFile.open(QIODevice::WriteOnly)) {
		QTextStream outputfile(&SaveFile);
		line = RxDataFilterInit(1,qt_str);
		QStringList coords = line.split(",");
		for( loop = 0; loop < 11; ++loop ){
			qt_str = "";
			qt_str = qt_str + coords[loop*3]   + ",";
			qt_str = qt_str + coords[loop*3+1] + ",";
			qt_str = qt_str + coords[loop*3+2] + "\n";
			outputfile << qt_str;
		}
		// File Close
		SaveFile.close();
		// File Close
		pInformation->Information_append("Save File successfully");
	} else {
		pInformation->Information_append("Can not open save file");
	}

}

