#ifndef RXDATAFILTER_H
#define RXDATAFILTER_H

#include <QtGui>
#include <QWidget>
#include "ui_rxdatafilter.h"
#include "hardware.h"
#include "information.h"
#include "PCANBasic.h"

class FCAN_View;

class RxDataFilter : public QWidget
{
	Q_OBJECT

public:
	RxDataFilter(QWidget *parent = 0);
	~RxDataFilter();

	void HardwareSet( Hardware * hardware );
	void InformationSet( Information * information );
	void FcanViewSet( FCAN_View * fcanview );
	QString RxDataFilterInit(int mode, QString line);

	DWORD SoftMinValue[10];
	DWORD SoftMaxValue[10];
	DWORD SoftSet[10];

private slots:
	// btnHWfilterSetReset
	void btnHWfilterSetReset_Click();
	// btnSWfilterSetReset_1
	void btnSWfilterSetReset_1_Click();
	// btnSWfilterSetReset_2
	void btnSWfilterSetReset_2_Click();
	// btnSWfilterSetReset_3
	void btnSWfilterSetReset_3_Click();
	// btnSWfilterSetReset_4
	void btnSWfilterSetReset_4_Click();
	// btnSWfilterSetReset_5
	void btnSWfilterSetReset_5_Click();
	// btnSWfilterSetReset_6
	void btnSWfilterSetReset_6_Click();
	// btnSWfilterSetReset_7
	void btnSWfilterSetReset_7_Click();
	// btnSWfilterSetReset_8
	void btnSWfilterSetReset_8_Click();
	// btnSWfilterSetReset_9
	void btnSWfilterSetReset_9_Click();
	// btnSWfilterSetReset_10
	void btnSWfilterSetReset_10_Click();
	// File Menu
	void menu_triggered( );
	// Load File
	void menu_loadfile( );
	// Save File
	void menu_savefile( );
	// Close
	void closeEvent( QCloseEvent * event );

private:
	Ui::RxDataFilter ui;

	Hardware * pHardware;
	Information * pInformation;
	FCAN_View * pFcanView;

	void createMenus();
	void createMenuActions();
	int ValueCheck(QString ValueString);

	DWORD SoftStandard[10];

	struct {
		QMenu * pMenu;
		QAction * pLoadFile;
		QAction * pSaveFile;
	} SettingMenu;

};

#endif // RXDATAFILTER_H
