#include <QtGui>
#include <QTableWidget.h>
#include <qtimer.h>
#include "txdata.h"
#include "hardware.h"
#include "information.h"
#include "fcan_view.h"

TxData::TxData(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
	hide();

	pHardware = NULL;
	pInformation = NULL;
	pFcanView = NULL;

	//	QTimer Create
	WriteTimer = new QTimer(this);
    connect( WriteTimer,SIGNAL(timeout()),this,SLOT(timWrite()));
	// btnWrite
	connect( ui.btnWrite,SIGNAL(clicked()),this,SLOT(btnWrite_Click()));
	// btnWriteFile
	connect( ui.btnWriteFile,SIGNAL(clicked()),this,SLOT(btnWriteFile_Click()));
	// btnWriteFileFind
	connect( ui.btnWriteFileFind,SIGNAL(clicked()),this,SLOT(btnWriteFileFind_Click()));
	// btnSetMessage
	connect( ui.btnSetMessage,SIGNAL(clicked()),this,SLOT(btnSetMessage_Click()));
	// btnOverWriteMessage
	connect( ui.btnOverWriteMessage,SIGNAL(clicked()),this,SLOT(btnOverWriteMessage_Click()));
	// btnDelMessage
	connect( ui.btnDelMessage,SIGNAL(clicked()),this,SLOT(btnDelMessage_Click()));
	// chbTxExtended
	connect( ui.chbTxExtended,SIGNAL(toggled(bool)),this,SLOT(chbTxExtended_Toggled()));
	// cbbTxLength
	connect( ui.cbbTxLength,SIGNAL(activated( const QString & )),this,SLOT(cbbTxLength_Changed( const QString & )));
	// chbRemoteRequest
	connect( ui.chbRemoteRequest,SIGNAL(toggled(bool)),this,SLOT(chbRemoteRequest_Toggled()));
	// chbDisplay
	connect( ui.chbDisplay,SIGNAL(toggled(bool)),this,SLOT(chbDisplay_Toggled()));
	// tblTxData_CellClickd
    connect(ui.tblTxData, SIGNAL(cellClicked(int, int)), this, SLOT(tblTxData_CellClicked(int, int)) );
	// tblTxData_CellDoubleClickd
    connect(ui.tblTxData, SIGNAL(cellDoubleClicked(int, int)), this, SLOT(tblTxData_CellDoubleClicked(int, int)) );

	ui.btnWrite->setEnabled(true);
	ui.btnWriteFile->setEnabled(true);
	ui.btnWriteFileFind->setEnabled(true);
	ui.btnSetMessage->setEnabled(true);
	ui.btnOverWriteMessage->setEnabled(true);
	ui.btnDelMessage->setEnabled(true);
	ui.tblTxData->setEnabled(true);
	ui.txtTxTimerCount->setEnabled(true);

	MessageCount = 0;
	WriteFileLine = 0;
	WriteFileLineMax = 0;
	TxMode = 0;
	TxRow = 0;
	TxRowSelect = 0;
	RemoteRequestMode = 0;
	DoubleClickFlag = 0;
	OverWriteFlag = 0;
	IntervalCount = 0;
	TimerCountCycle = 0;
	DisplayTime = 0;

	// Menu Init
	createMenus();

}

TxData::~TxData()
{
	int no;

	for( no=TxDataLine.count()-1; no>=0; no=no-1 ) {
		TxDataLine.removeAt(0);
	}
}

////////////////////////////////////////
// Pointer Setting
////////////////////////////////////////
void TxData::HardwareSet( Hardware * hardware )
{
	pHardware = hardware;
}
void TxData::InformationSet( Information * information )
{
	pInformation = information;
}
void TxData::FcanViewSet( FCAN_View * fcanview )
{
	pFcanView = fcanview;
}
////////////////////////////////////////
// TxData Function
////////////////////////////////////////
// Close
void TxData::closeEvent(QCloseEvent * pEvent)
{
	WriteTimer->stop();
	pFcanView->ViewWindow[3] = false;
}
void TxData::resizeEvent(QResizeEvent * /* event */)
{
	ui.groupBox->resize(width() - 19, 251 + (height() - 420));
	ui.tblTxData->resize(width() - 39, 121 + (height() - 420));
}
void TxData::keyPressEvent(QKeyEvent *event)
{
    switch (event->key()) {
    case Qt::Key_Delete:
        DelMessage();
        break;
    default:
        QWidget::keyPressEvent(event);
    }
}
// btnWrite
void TxData::btnWrite_Click()
{
	TPCANMsg CANMsg;
	TPCANStatus stsResult;
	QString qt_str;
	QTableWidgetItem * pItem;
	QMessageBox msgBox;
	int TxId;
	int TxCob;
	int Count;
	int ret;
	int row_max;
	int lp;
	int interval_count;
	int error_flag;
	int index;

	if( pHardware->HardwareInitSet == 0 ){
		msgBox.setText("Error: Hardware Not Initialize!");
		ret = msgBox.exec();
	} else {
		ui.btnWrite->setEnabled(false);
		ui.btnSetMessage->setEnabled(false);
		ui.btnOverWriteMessage->setEnabled(false);
		ui.btnDelMessage->setEnabled(false);
		ui.tblTxData->setEnabled(false);
		ui.btnWriteFile->setEnabled(false);
		ui.btnWriteFileFind->setEnabled(false);

		TxMode = 0;

		// Start Select
		ui.btnWrite->setText("Stop Message");
		pFcanView->statusBar_message("    <<<< During the transmission");

		// Cob ID / Node ID
		error_flag = 0;
		if( ui.chbTxExtended->isChecked() ){
			qt_str = ui.txtTxCobId->text();
			ret = ValueCheck(qt_str);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				TxCob = (DWORD)qt_str.toUInt(0,16) & pFcanView->ExtCobIDMask;
				qt_str.sprintf("%08X", TxCob);
				ui.txtTxCobId->setText(qt_str);
			}
			qt_str = ui.txtTxId->text();
			ret = ValueCheck(qt_str);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				TxId = (DWORD)qt_str.toUInt(0,16) & pFcanView->ExtNodeIDMask;
				qt_str.sprintf("%08X", TxId);
				ui.txtTxId->setText(qt_str);
			}
			CANMsg.ID = TxCob + TxId;
		} else {
			qt_str = ui.txtTxCobId->text();
			ret = ValueCheck(qt_str);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				TxCob = (DWORD)qt_str.toUInt(0,16) & pFcanView->StdCobIDMask;
				qt_str.sprintf("%03X", TxCob);
				ui.txtTxCobId->setText(qt_str);
			}
			qt_str = ui.txtTxId->text();
			ret = ValueCheck(qt_str);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				TxId = (DWORD)qt_str.toUInt(0,16) & pFcanView->StdNodeIDMask;
				qt_str.sprintf("%03X", TxId);
				ui.txtTxId->setText(qt_str);
			}
			CANMsg.ID = TxCob + TxId;
		}

		// Length
		qt_str = ui.cbbTxLength->currentText();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.LEN = (BYTE)qt_str.toUInt(0,16);
		}

		// MSGTYPE
		CANMsg.MSGTYPE = ( ui.chbTxExtended->isChecked() ) ? PCAN_MESSAGE_EXTENDED : PCAN_MESSAGE_STANDARD;

		// RemoteRequest
		if( ui.chbRemoteRequest->isChecked() ){
			CANMsg.MSGTYPE = CANMsg.MSGTYPE | PCAN_MESSAGE_RTR;
		}

		// We get so much data as the Len of the message
		//
		qt_str = ui.txtTxData0->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[0] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[0]);
		ui.txtTxData0->setText(qt_str);

		qt_str = ui.txtTxData1->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[1] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[1]);
		ui.txtTxData1->setText(qt_str);

		qt_str = ui.txtTxData2->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[2] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[2]);
		ui.txtTxData2->setText(qt_str);

		qt_str = ui.txtTxData3->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[3] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[3]);
		ui.txtTxData3->setText(qt_str);

		qt_str = ui.txtTxData4->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[4] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[4]);
		ui.txtTxData4->setText(qt_str);

		qt_str = ui.txtTxData5->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[5] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[5]);
		ui.txtTxData5->setText(qt_str);

		qt_str = ui.txtTxData6->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[6] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[6]);
		ui.txtTxData6->setText(qt_str);

		qt_str = ui.txtTxData7->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.DATA[7] = (BYTE)qt_str.toUInt(0,16);
		}
		qt_str.sprintf("%02X", CANMsg.DATA[7]);
		ui.txtTxData7->setText(qt_str);

		// The message is sent to the configured hardware
		//
		if( error_flag == 0 ){
			stsResult = Write_Message(&CANMsg);
			if( stsResult == PCAN_ERROR_OK ){
				pInformation->Information_set("");
				pInformation->Information_append("Message was successfully SENT");
			// An error occurred.  We show the error.
			//
			} else {
				pInformation->Information_set("");
				pInformation->Information_append("Message was SENT Error!!");
			}

		} else {
			qt_str = "Error: TxData Write Illegal Value!";
			ret = QMessageBox::warning(this, tr("TxDataInit"),
											qt_str,
											QMessageBox::Yes | QMessageBox::Default);
		}

		ui.btnWrite->setText("Write Message");
		ui.btnWrite->setEnabled(true);
		ui.btnSetMessage->setEnabled(true);
		ui.btnOverWriteMessage->setEnabled(true);
		ui.btnDelMessage->setEnabled(true);
		ui.tblTxData->setEnabled(true);
		ui.btnWriteFile->setEnabled(true);
		ui.btnWriteFileFind->setEnabled(true);
		pFcanView->statusBar_message("");
	}
	ui.btnWrite->setFocus();

}
// TxDataWrite
void TxData::TxDataWrite()
{
	TPCANMsg CANMsg;
	TPCANStatus stsResult;
	QStringList coords;
	QString qt_str;
	QString qt_std;
	QString qt_cob;
	QString qt_id;
	QString qt_len;
	QString qt_data;
	QString qt_count;
	QTableWidgetItem * pItem;
	QMessageBox msgBox;
	int TxId;
	int TxCob;
	int Count;
	int ret;
	int lp;
	int error_flag;

	if( pHardware->HardwareInitSet == 0 ){
		msgBox.setText("Error: Hardware Not Initialize!");
		ret = msgBox.exec();
	} else if( ui.tblTxData->rowCount() == 0 ){
		msgBox.setText("Error: Write Message Not Setting!");
		ret = msgBox.exec();
	} else {
		ui.btnWrite->setEnabled(false);
		ui.btnSetMessage->setEnabled(false);
		ui.btnOverWriteMessage->setEnabled(false);
		ui.btnDelMessage->setEnabled(false);
		ui.tblTxData->setEnabled(false);
		ui.btnWriteFile->setEnabled(false);
		ui.btnWriteFileFind->setEnabled(false);
		ui.btnWrite->setText("Stop Message");
		pFcanView->statusBar_message("    <<<< During the transmission");

		TxMode = 0;

		for( lp = 1; lp < 7; lp=lp+1 ){
			pItem = ui.tblTxData->item(TxRow, lp);
			if( lp == 1 ){        qt_std = pItem->text();
			} else if( lp == 2 ){ qt_cob   = pItem->text();
			} else if( lp == 3 ){ qt_id    = pItem->text();
			} else if( lp == 4 ){ qt_len   = pItem->text();
			} else if( lp == 5 ){ qt_data  = pItem->text();
			} else if( lp == 6 ){ qt_count = pItem->text();
			}
		}

		error_flag = 0;
		// CobID + NodeID
		if( qt_std == "EXT" ){
			ret = ValueCheck(qt_cob);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				TxCob = (DWORD)qt_cob.toUInt(0,16) & pFcanView->ExtCobIDMask;
				ret = ValueCheck(qt_id);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					TxId = (DWORD)qt_id.toUInt(0,16) & pFcanView->ExtNodeIDMask;
					CANMsg.ID = TxCob + TxId;
				}
			}
		} else {
			ret = ValueCheck(qt_cob);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				TxCob = (DWORD)qt_cob.toUInt(0,16) & pFcanView->StdCobIDMask;
				ret = ValueCheck(qt_id);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					TxId = (DWORD)qt_id.toUInt(0,16) & pFcanView->StdNodeIDMask;
					CANMsg.ID = TxCob + TxId;
				}
			}
		}

		// Length
		ret = ValueCheck(qt_len);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			CANMsg.LEN = (BYTE)qt_len.toUInt(0,16);
		}

		// MSGTYPE
		CANMsg.MSGTYPE = ( qt_std == "EXT" ) ? PCAN_MESSAGE_EXTENDED : PCAN_MESSAGE_STANDARD;

		// RemoteRequest
		if( qt_data == "RTR" ){
			CANMsg.MSGTYPE = CANMsg.MSGTYPE | PCAN_MESSAGE_RTR;
		}

		// Data
		if( qt_data != "RTR" ){
			coords = qt_data.split(" ");
			for( lp=0; lp<CANMsg.LEN; lp=lp+1 ){
				ret = ValueCheck(coords[lp]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					CANMsg.DATA[lp] = (BYTE)coords[lp].toUInt(0,16);
				}
			}
		}

		// The message is sent to the configured hardware
		//
		if( error_flag == 0 ){
			stsResult = Write_Message(&CANMsg);
			if( stsResult == PCAN_ERROR_OK ){
				pInformation->Information_set("");
				pInformation->Information_append("Message was successfully SENT");
				pItem = ui.tblTxData->item(TxRow, 6);
				Count = qt_count.toInt(0,10) + 1;
				qt_str.sprintf("%d", Count);
				pItem->setText(qt_str);
			} else {
				pInformation->Information_set("");
				pInformation->Information_append("Message was SENT Error!!");
			}
		} else {
			qt_str = "Error: TxData Write Illegal Value!";
			ret = QMessageBox::warning(this, tr("TxData"),
											qt_str,
											QMessageBox::Yes | QMessageBox::Default);
		}

		ui.btnWrite->setText("Write Message");
		ui.btnWrite->setEnabled(true);
		ui.btnSetMessage->setEnabled(true);
		ui.btnOverWriteMessage->setEnabled(true);
		ui.btnDelMessage->setEnabled(true);
		ui.tblTxData->setEnabled(true);
		ui.btnWriteFile->setEnabled(true);
		ui.btnWriteFileFind->setEnabled(true);
		pFcanView->statusBar_message("");
		ui.tblTxData->setFocus();
	}

}
// btnSetMessage
void TxData::btnSetMessage_Click()
{
	ui.btnWrite->setEnabled(false);
	ui.btnSetMessage->setEnabled(false);
	ui.btnOverWriteMessage->setEnabled(false);
	ui.btnDelMessage->setEnabled(false);
	ui.tblTxData->setEnabled(false);
	ui.btnWriteFile->setEnabled(false);
	ui.btnWriteFileFind->setEnabled(false);

	OverWriteFlag = 0;
	SetMessage();

	ui.btnWrite->setEnabled(true);
	ui.btnSetMessage->setEnabled(true);
	ui.btnOverWriteMessage->setEnabled(true);
	ui.btnDelMessage->setEnabled(true);
	ui.tblTxData->setEnabled(true);
	ui.btnWriteFile->setEnabled(true);
	ui.btnWriteFileFind->setEnabled(true);

	ui.btnSetMessage->setFocus();
}
// btnOverWriteMessage
void TxData::btnOverWriteMessage_Click()
{
	ui.btnWrite->setEnabled(false);
	ui.btnSetMessage->setEnabled(false);
	ui.btnOverWriteMessage->setEnabled(false);
	ui.btnDelMessage->setEnabled(false);
	ui.tblTxData->setEnabled(false);
	ui.btnWriteFile->setEnabled(false);
	ui.btnWriteFileFind->setEnabled(false);

	OverWriteFlag = 1;
	SetMessage();

	ui.btnWrite->setEnabled(true);
	ui.btnSetMessage->setEnabled(true);
	ui.btnOverWriteMessage->setEnabled(true);
	ui.btnDelMessage->setEnabled(true);
	ui.tblTxData->setEnabled(true);
	ui.btnWriteFile->setEnabled(true);
	ui.btnWriteFileFind->setEnabled(true);

	ui.btnOverWriteMessage->setFocus();
}
// btnDelMessage
void TxData::btnDelMessage_Click()
{
	DelMessage();
	ui.btnDelMessage->setFocus();
}
void TxData::DelMessage()
{
	QString qt_str;

	ui.btnWrite->setEnabled(false);
	ui.btnSetMessage->setEnabled(false);
	ui.btnOverWriteMessage->setEnabled(false);
	ui.btnDelMessage->setEnabled(false);
	ui.tblTxData->setEnabled(false);
	ui.btnWriteFile->setEnabled(false);
	ui.btnWriteFileFind->setEnabled(false);

	qt_str.sprintf("%d", (TxRow+1));
	qt_str = "Do you really delete RowItem = " + qt_str + " ?";
	int qt_ret = QMessageBox::warning(this, tr("TxDataItemDelate"),
										qt_str,
										QMessageBox::Yes,
										QMessageBox::No | QMessageBox::Default);
	if( qt_ret == QMessageBox::Yes ){
		ui.tblTxData->removeRow(TxRow);
	}

	ui.btnWrite->setEnabled(true);
	ui.btnSetMessage->setEnabled(true);
	ui.btnOverWriteMessage->setEnabled(true);
	ui.btnDelMessage->setEnabled(true);
	ui.tblTxData->setEnabled(true);
	ui.btnWriteFile->setEnabled(true);
	ui.btnWriteFileFind->setEnabled(true);
}
// SetMessage
void TxData::SetMessage()
{
	QString qt_cobid;
	QString qt_id;
	QString qt_length;
	QString qt_type;
	QString qt_data;
	QString qt_str;
	QString qt_interval;
	int TxId;
	int TxCob;
	int TxData;
	int index;
	int row_max;
	int count;
	int id_chk;
	QTableWidgetItem * pItem[6];

	// We configurate the Message.  The ID (max 0x1FF),
	// Length of the Data, Message Type (Standard in 
	// this example) and die data
	//

	// IntervalTimer
	qt_interval = ui.txtTxTimerCount->text();

	// Cob ID / Node ID
	if( ui.chbTxExtended->isChecked() ){
		qt_cobid = ui.txtTxCobId->text();
		TxCob = (DWORD)qt_cobid.toUInt(0,16) & pFcanView->ExtCobIDMask;
		qt_cobid.sprintf("%08X", TxCob);
		ui.txtTxCobId->setText(qt_cobid);
		qt_id = ui.txtTxId->text();
		TxId = (DWORD)qt_id.toUInt(0,16) & pFcanView->ExtNodeIDMask;
		qt_id.sprintf("%08X", TxId);
		ui.txtTxId->setText(qt_id);
	} else {
		qt_cobid = ui.txtTxCobId->text();
		TxCob = (DWORD)qt_cobid.toUInt(0,16) & pFcanView->StdCobIDMask;
		qt_cobid.sprintf("%03X", TxCob);
		ui.txtTxCobId->setText(qt_cobid);
		qt_id = ui.txtTxId->text();
		TxId = (DWORD)qt_id.toUInt(0,16) & pFcanView->StdNodeIDMask;
		qt_id.sprintf("%03X", TxId);
		ui.txtTxId->setText(qt_id);
	}

	// Length
	qt_length = ui.cbbTxLength->currentText();
	index = ui.cbbTxLength->currentIndex();

	// MSGTYPE
	qt_type = ( ui.chbTxExtended->isChecked() ) ? "EXT" : "STD";

	// We get so much data as the Len of the message
	//
	qt_str = ui.txtTxData0->text();
	TxData = (BYTE)qt_str.toUInt(0,16);
	qt_str.sprintf("%02X", TxData);
	ui.txtTxData0->setText(qt_str);
	qt_data = qt_str;

	if( index <= 6 ){
		qt_str = ui.txtTxData1->text();
		TxData = (BYTE)qt_str.toUInt(0,16);
		qt_str.sprintf("%02X", TxData);
		ui.txtTxData1->setText(qt_str);
		qt_data = qt_data + " " + qt_str;
	}

	if( index <= 5 ){
		qt_str = ui.txtTxData2->text();
		TxData = (BYTE)qt_str.toUInt(0,16);
		qt_str.sprintf("%02X", TxData);
		ui.txtTxData2->setText(qt_str);
		qt_data = qt_data + " " + qt_str;
	}

	if( index <= 4 ){
		qt_str = ui.txtTxData3->text();
		TxData = (BYTE)qt_str.toUInt(0,16);
		qt_str.sprintf("%02X", TxData);
		ui.txtTxData3->setText(qt_str);
		qt_data = qt_data + " " + qt_str;
	}

	if( index <= 3 ){
		qt_str = ui.txtTxData4->text();
		TxData = (BYTE)qt_str.toUInt(0,16);
		qt_str.sprintf("%02X", TxData);
		ui.txtTxData4->setText(qt_str);
		qt_data = qt_data + " " + qt_str;
	}

	if( index <= 2 ){
		qt_str = ui.txtTxData5->text();
		TxData = (BYTE)qt_str.toUInt(0,16);
		qt_str.sprintf("%02X", TxData);
		ui.txtTxData5->setText(qt_str);
		qt_data = qt_data + " " + qt_str;
	}

	if( index <= 1 ){
		qt_str = ui.txtTxData6->text();
		TxData = (BYTE)qt_str.toUInt(0,16);
		qt_str.sprintf("%02X", TxData);
		ui.txtTxData6->setText(qt_str);
		qt_data = qt_data + " " + qt_str;
	}

	if( index <= 0 ){
		qt_str = ui.txtTxData7->text();
		TxData = (BYTE)qt_str.toUInt(0,16);
		qt_str.sprintf("%02X", TxData);
		ui.txtTxData7->setText(qt_str);
		qt_data = qt_data + " " + qt_str;
	}

	if( ui.chbRemoteRequest->isChecked() ){
		qt_data = "RTR";
	}


	if( OverWriteFlag == 1 ){
		count = ui.tblTxData->currentRow();
		pItem[0] = ui.tblTxData->item(count, 0);
		pItem[1] = ui.tblTxData->item(count, 1);
		pItem[2] = ui.tblTxData->item(count, 2);
		pItem[3] = ui.tblTxData->item(count, 3);
		pItem[4] = ui.tblTxData->item(count, 4);
		pItem[5] = ui.tblTxData->item(count, 5);
		pItem[6] = ui.tblTxData->item(count, 6);

		pItem[0]->setCheckState(Qt::Unchecked);
		pItem[0]->setText(qt_interval);
		pItem[1]->setText(qt_type);
		pItem[2]->setText(qt_cobid);
		pItem[3]->setText(qt_id);
		pItem[4]->setText(qt_length);
		pItem[5]->setText(qt_data);
		pItem[6]->setText(QString("0"));
	} else {
		row_max = ui.tblTxData->rowCount();
		id_chk = -1;

		for( count = 0; count < row_max; count=count+1 ){
			pItem[0] = ui.tblTxData->item(count, 0);
			pItem[1] = ui.tblTxData->item(count, 1);
			pItem[2] = ui.tblTxData->item(count, 2);
			pItem[3] = ui.tblTxData->item(count, 3);
			pItem[4] = ui.tblTxData->item(count, 4);
			pItem[5] = ui.tblTxData->item(count, 5);
			pItem[6] = ui.tblTxData->item(count, 6);
//			if(( pItem[2]->text() == qt_cobid )
//				&& ( pItem[3]->text() == qt_id )){
//				id_chk = count;
//				TxRow = count;
//				break;
//			}
		}

		if( id_chk == -1 ){
			ui.tblTxData->setRowCount(row_max+1);
			TxRow = row_max;
			for(count = 0; count < 7; count=count+1 ){
				pItem[count] = new QTableWidgetItem();
				ui.tblTxData->setItem(row_max, count, pItem[count]);
			}
		}

		pItem[0]->setCheckState(Qt::Unchecked);
		pItem[0]->setText(qt_interval);
		pItem[1]->setText(qt_type);
		pItem[2]->setText(qt_cobid);
		pItem[3]->setText(qt_id);
		pItem[4]->setText(qt_length);
		pItem[5]->setText(qt_data);
		if( id_chk == -1 ){
			pItem[6]->setText(QString("0"));
		}
	}

	ui.tblTxData->resizeColumnsToContents();
	ui.tblTxData->resizeRowsToContents();

}
// btnWriteFile
void TxData::btnWriteFile_Click()
{
	QString line;
	QString qt_str;
	QStringList coords;
	QMessageBox msgBox;
	int no;
	int qt_ret;
	int overline;
	DWORD TimerCount = 0;
	DWORD TxTime;
	DWORD TxTimeGen;
	double RxTime;

	overline = 0;

	if( pHardware->HardwareInitSet == 0 ){
		msgBox.setText("Error: Hardware Not Initialize!");
		qt_ret = msgBox.exec();
	} else if( ui.txtTxFileName->text() == "" ){
		msgBox.setText("Error: Load File Not Setting!");
		qt_ret = msgBox.exec();
	} else {
		if( ui.btnWriteFile->text() == "Write Message" ){
			ui.btnWriteFile->setText("Stop Message");

			ui.btnWrite->setEnabled(false);
			ui.btnSetMessage->setEnabled(false);
			ui.btnOverWriteMessage->setEnabled(false);
			ui.btnDelMessage->setEnabled(false);
			ui.tblTxData->setEnabled(false);
			ui.btnWriteFile->setEnabled(true);
			ui.btnWriteFileFind->setEnabled(false);

			TxMode = 1;
			WriteFileLineMax = 0;

			// TxDataLine Clear
			for( no=TxDataLine.count()-1; no>=0; no=no-1 ) {
				TxDataLine.removeAt(0);
			}

			// File Name
			qt_str = ui.txtTxFileName->text();
			QFile TxFile(qt_str);

			WriteFileLine = 0;
			if (TxFile.open(QIODevice::ReadOnly)) {
				QTextStream in(&TxFile);
				while (!in.atEnd()) {
					QString line = in.readLine();
					coords = line.split(",");

					qt_str = coords[0];
					if( qt_str[0] == 'T' ){
//						TxDataLine[WriteFileLine] = coords;
						TxDataLine.append(line);
						WriteFileLine = WriteFileLine + 1;
						if( WriteFileLine > 10000000 ){
							msgBox.setText("Error: The number of Write Message File exceeds a limit 10000000 Messages!");
							qt_ret = msgBox.exec();
							overline = 1;
							break;
						}
					} else if( qt_str[0] == 'R' ){
						RxTime = coords[1].toDouble();
						RxTime = RxTime + 0.5;
						if( WriteFileLine == 0 ){
							TxTimeGen = 0;
							TxTime = (DWORD)RxTime;
							coords[1] = qt_str.sprintf("%d", TxTime);
						} else {
							TxTimeGen = (DWORD)RxTime;
							TxTime = TxTimeGen - TxTime;
							coords[1] = qt_str.sprintf("%d", TxTime);
							TxTime = TxTimeGen;
						}
//						TxDataLine[WriteFileLine] = coords;
						qt_str = "";
						for( no=0; no<coords.count(); no=no+1 ) {
							if( no == coords.count() -1 ){
								qt_str = qt_str + coords[no];
							} else {
								qt_str = qt_str + coords[no] + ",";
							}
						}
						TxDataLine.append(qt_str);
						WriteFileLine = WriteFileLine + 1;
						if( WriteFileLine > 10000000 ){
							msgBox.setText("Error: The number of Write Message File exceeds a limit 10000000 Messages!");
							qt_ret = msgBox.exec();
							overline = 1;
							break;
						}
					} else {
					}
				}
				TxFile.close();
			}

			// Timer Start
			if( overline == 0 ){
//				coords = TxDataLine[0];
				line = TxDataLine[0];
				coords = line.split(",");

				TimerCount = (DWORD)coords[1].toUInt(0,10);
				WriteTimer->start(TimerCount);
				ui.txtWriteMessageCount->setText("0");

				WriteFileLineMax = WriteFileLine;
				WriteFileLine = 0;
				MessageCount = 0;

				pFcanView->statusBar_message("    <<<< During the transmission");
			} else {
				ui.btnWriteFile->setText("Write Message");
				WriteTimer->stop();
				ui.btnWrite->setEnabled(true);
				ui.btnSetMessage->setEnabled(true);
				ui.btnOverWriteMessage->setEnabled(true);
				ui.btnDelMessage->setEnabled(true);
				ui.tblTxData->setEnabled(true);
				ui.btnWriteFile->setEnabled(true);
				ui.btnWriteFileFind->setEnabled(true);
				WriteFileLine = 0;
				WriteFileLineMax = 0;
				pFcanView->statusBar_message("");
			}
		} else {
			ui.btnWriteFile->setText("Write Message");
			WriteTimer->stop();
			ui.btnWrite->setEnabled(true);
			ui.btnSetMessage->setEnabled(true);
			ui.btnOverWriteMessage->setEnabled(true);
			ui.btnDelMessage->setEnabled(true);
			ui.tblTxData->setEnabled(true);
			ui.btnWriteFile->setEnabled(true);
			ui.btnWriteFileFind->setEnabled(true);
			WriteFileLine = 0;
			WriteFileLineMax = 0;
			pFcanView->statusBar_message("");
		}

	}
	ui.btnWriteFile->setFocus();

}

// btnWriteFile
void TxData::btnWriteFileFind_Click()
{
	QString fileName = QFileDialog::getOpenFileName(
														this,
					   									tr("Open Data file"),	// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter
	ui.txtTxFileName->setText(fileName);
	ui.btnWriteFileFind->setFocus();

}

// Write Messages
TPCANStatus TxData::Write_Message(TPCANMsg* MessageBuffer)
{
	TPCANStatus stsResult;

	stsResult = pHardware->btnWrite_Click(MessageBuffer);
	return stsResult;

}

// timWrite
void TxData::timWrite()
{
	TPCANMsg CANMsg;
	TPCANStatus stsResult;
	QString line;
	QString qt_str;
	QStringList coords;
	QTableWidgetItem * pItem;
	int lp;
	int no;
	int TxId;
	int Length;
	int Count;
	int ret;
	int error_flag;
	int row;
	int file_write;
	DWORD time_gen;
	DWORD time_cnt;
	DWORD TimerCount = 0;


	error_flag = 0;

	// Write
	if( TxMode == 0 ){
		for( lp = 0; lp < IntervalCount; lp=lp+1 ){
//			coords = TxDataLine[lp];
			line = TxDataLine[lp];
			coords = line.split(" ");
			row = coords[0].toUInt(0,10);
			time_gen = (DWORD)coords[1].toUInt(0,10);
			if( time_gen == 0 ){
				time_gen = 1;
			}
			time_cnt = (DWORD)coords[2].toUInt(0,10);
			time_cnt = time_cnt + 1;
			if( time_gen == time_cnt ){
				coords[2] = "0";
				// COB ID / ID / MSGTYPE
				if( coords[4] == "EXT" ){
					CANMsg.MSGTYPE = PCAN_MESSAGE_EXTENDED;
					ret = ValueCheck(coords[5]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						TxId = (DWORD)coords[5].toUInt(0,16) & pFcanView->ExtCobIDMask;
					}
					ret = ValueCheck(coords[6]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						CANMsg.ID = TxId + ((DWORD)coords[6].toUInt(0,16) & pFcanView->ExtNodeIDMask );
					}
				} else {
					CANMsg.MSGTYPE = PCAN_MESSAGE_STANDARD;
					ret = ValueCheck(coords[5]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						TxId = (DWORD)coords[5].toUInt(0,16) & pFcanView->StdCobIDMask;
					}
					ret = ValueCheck(coords[6]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						CANMsg.ID = TxId + ((DWORD)coords[6].toUInt(0,16) & pFcanView->StdNodeIDMask);
					}
				}

				// Length
				qt_str = coords[7];
				ret = ValueCheck(qt_str);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					Length = qt_str.toInt(0,16);
					CANMsg.LEN = (BYTE)Length;
				}

				// RemoteRequest
				if( coords[8] == "RTR" ){
					CANMsg.MSGTYPE = CANMsg.MSGTYPE | PCAN_MESSAGE_RTR;
				}

				// Messages
				if( coords[8] != "RTR" ){
					for( int i = 0; i < Length; i=i+1 ){
						qt_str = coords[8+i];
						ret = ValueCheck(qt_str);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							CANMsg.DATA[i] = (BYTE)qt_str.toUInt(0,16);
						}
					}
				}

				if( error_flag == 0 ){
					stsResult = Write_Message(&CANMsg);
					if( stsResult == PCAN_ERROR_OK ){
						pInformation->Information_set("");
						pInformation->Information_append("Message was successfully SENT");
					// An error occurred.  We show the error.
					//
					} else {
						pInformation->Information_set("");
						pInformation->Information_append("Message was SENT Error!!");
					}
//					// Count Check
//					pItem = ui.tblTxData->item(row, 6);
//					qt_str = pItem->text();
//					Count = qt_str.toInt(0,10) + 1;
//					qt_str.sprintf("%d", Count);
//					pItem->setText(qt_str);
					Count = coords[3].toInt(0,10) + 1;
					qt_str.sprintf("%d", Count);
					coords[3] = qt_str;
				} else {
					pInformation->Information_set("");
					pInformation->Information_append("Message was SENT Error!!");
				}
			} else {
				qt_str.sprintf("%d", time_cnt);
				coords[2] = qt_str;
			}
//			TxDataLine[lp] = coords;
			qt_str = "";
			for( no=0; no<coords.count(); no=no+1 ) {
				if( no == coords.count() - 1 ){
					qt_str = qt_str + coords[no];
				} else {
					qt_str = qt_str + coords[no] + " ";
				}
			}
			TxDataLine.removeAt(lp);
			TxDataLine.insert(lp, qt_str);
		}
		// Count Check
		TimerCountCycle = TimerCountCycle + 1;
		if( ui.chbDisplay->isChecked() ){
			if(( DisplayTime == 0 ) || ( TimerCountCycle >= DisplayTime )){
				TimerCountCycle = 0;
				for( lp = 0; lp < IntervalCount; lp=lp+1 ){
					line = TxDataLine[lp];
					coords = line.split(" ");
					row = coords[0].toUInt(0,10);
					pItem = ui.tblTxData->item(row, 6);
					pItem->setText(coords[3]);
				}
			}
		} else {
			TimerCountCycle = 0;
		}
	} else {
	// Write File

		if( WriteFileLine == WriteFileLineMax ){
			WriteTimer->stop();
			ui.btnWrite->setEnabled(true);
			ui.btnSetMessage->setEnabled(true);
			ui.btnOverWriteMessage->setEnabled(true);
			ui.btnDelMessage->setEnabled(true);
			ui.tblTxData->setEnabled(true);
			ui.btnWriteFile->setEnabled(true);
			ui.btnWriteFile->setText("Write Message");
			ui.btnWriteFileFind->setEnabled(true);
			WriteFileLine = 0;
			WriteFileLineMax = 0;
			pFcanView->statusBar_message("");
		} else {
			file_write = 1;
			WriteTimer->stop();

			while( file_write == 1 ){
//				coords = TxDataLine[WriteFileLine];
				line = TxDataLine[WriteFileLine];
				coords = line.split(",");

				// COB ID / ID / MSGTYPE
				if( ui.chbTxFileExtended->isChecked() ){
					CANMsg.MSGTYPE = PCAN_MESSAGE_EXTENDED;
					ret = ValueCheck(coords[2]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						TxId = (DWORD)coords[2].toUInt(0,16) & pFcanView->ExtCobIDMask;
					}
					ret = ValueCheck(coords[3]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						CANMsg.ID = TxId + ((DWORD)coords[3].toUInt(0,16) & pFcanView->ExtNodeIDMask);
					}
				} else {
					CANMsg.MSGTYPE = PCAN_MESSAGE_STANDARD;
					ret = ValueCheck(coords[2]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						TxId = (DWORD)coords[2].toUInt(0,16) & pFcanView->StdCobIDMask;
					}
					ret = ValueCheck(coords[3]);
					if( ret == 1 ){
						error_flag = 1;
					} else {
						CANMsg.ID = TxId + ((DWORD)coords[3].toUInt(0,16) & pFcanView->StdNodeIDMask);
					}
				}

				// Length
				qt_str = coords[4];
				ret = ValueCheck(qt_str);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					Length = qt_str.toInt(0,16);
					CANMsg.LEN = (BYTE)Length;
				}

				// Messages
				if( coords[5] == "RTR" ){
					RemoteRequestMode = 1;
					CANMsg.MSGTYPE = CANMsg.MSGTYPE | PCAN_MESSAGE_RTR;
					for( int i = 0; i < Length; i=i+1 ){
						CANMsg.DATA[i] = 0x00;
					}
				} else {
					RemoteRequestMode = 0;
					for( int i = 0; i < Length; i=i+1 ){
						qt_str = coords[5+i];
						ret = ValueCheck(qt_str);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							CANMsg.DATA[i] = (BYTE)qt_str.toUInt(0,16);
						}
					}
				}

				if( error_flag == 0 ){
					stsResult = Write_Message(&CANMsg);
					if( stsResult == PCAN_ERROR_OK ){
						pInformation->Information_set("");
						pInformation->Information_append("Message was successfully SENT");
					// An error occurred.  We show the error.
					//
					} else {
						pInformation->Information_set("");
						pInformation->Information_append("Message was SENT Error!!");
					}
					// Timer Start
					if(( WriteFileLine + 1 ) == WriteFileLineMax ){
//						coords = TxDataLine[WriteFileLine];
						line = TxDataLine[WriteFileLine];
						coords = line.split(",");
					} else {
//						coords = TxDataLine[WriteFileLine+1];
						line = TxDataLine[WriteFileLine+1];
						coords = line.split(",");
					}
					TimerCount = (DWORD)coords[1].toUInt(0,10);
					if( TimerCount != 0 ){
						WriteTimer->start(TimerCount);
						file_write = 0;
					}
					MessageCount = MessageCount + 1;
					qt_str.sprintf("%08d", MessageCount);
					ui.txtWriteMessageCount->setText(qt_str);
					WriteFileLine = WriteFileLine + 1;
					if( WriteFileLine == WriteFileLineMax ){
						file_write = 0;
						WriteTimer->start( 1 );
					}
				} else {
					file_write = 0;
					WriteFileLine = WriteFileLineMax;
					WriteTimer->start( 1 );
					pInformation->Information_set("");
					pInformation->Information_append("Message was SENT Error!!");
				}
			}
		}
	}

}

// chbTxExtended
void TxData::chbTxExtended_Toggled()
{
	int TxId;
	int TxCob;
	QString qt_str;

	if( ui.chbTxExtended->isChecked() ){
		qt_str = ui.txtTxCobId->text();
		TxCob = (DWORD)qt_str.toUInt(0,16) & pFcanView->ExtCobIDMask;
		qt_str.sprintf("%08X", TxCob);
		ui.txtTxCobId->setText(qt_str);
		qt_str = ui.txtTxId->text();
		TxId = (DWORD)qt_str.toUInt(0,16) & pFcanView->ExtNodeIDMask;
		qt_str.sprintf("%08X", TxId);
		ui.txtTxId->setText(qt_str);
	} else {
		qt_str = ui.txtTxCobId->text();
		TxCob = (DWORD)qt_str.toUInt(0,16) & pFcanView->StdCobIDMask;
		qt_str.sprintf("%03X", TxCob);
		ui.txtTxCobId->setText(qt_str);
		qt_str = ui.txtTxId->text();
		TxId = (DWORD)qt_str.toUInt(0,16) & pFcanView->StdNodeIDMask;
		qt_str.sprintf("%03X", TxId);
		ui.txtTxId->setText(qt_str);
	}

}
// chbRemoteRequest
void TxData::chbRemoteRequest_Toggled()
{

	if( ui.chbRemoteRequest->isChecked() ){
		 ui.txtTxData7->hide();
		 ui.txtTxData6->hide();
		 ui.txtTxData5->hide();
		 ui.txtTxData4->hide();
		 ui.txtTxData3->hide();
		 ui.txtTxData2->hide();
		 ui.txtTxData1->hide();
		 ui.txtTxData0->hide();
	} else {
		 ui.txtTxData7->show();
		 ui.txtTxData6->show();
		 ui.txtTxData5->show();
		 ui.txtTxData4->show();
		 ui.txtTxData3->show();
		 ui.txtTxData2->show();
		 ui.txtTxData1->show();
		 ui.txtTxData0->show();
	}

}
void TxData::chbDisplay_Toggled()
{

	if( ui.chbDisplay->isChecked() ){
		ui.txtDisplayTime->setEnabled(true);
	} else {
		ui.txtDisplayTime->setEnabled(false);
	}

}

// cbbTxLength
void TxData::cbbTxLength_Changed( const QString &s )
{
	int index;

	if( ui.chbRemoteRequest->isChecked() ){
	} else {
		index = ui.cbbTxLength->currentIndex();
		if( index > 0 ){ ui.txtTxData7->hide(); } else { ui.txtTxData7->show(); }
		if( index > 1 ){ ui.txtTxData6->hide(); } else { ui.txtTxData6->show(); }
		if( index > 2 ){ ui.txtTxData5->hide(); } else { ui.txtTxData5->show(); }
		if( index > 3 ){ ui.txtTxData4->hide(); } else { ui.txtTxData4->show(); }
		if( index > 4 ){ ui.txtTxData3->hide(); } else { ui.txtTxData3->show(); }
		if( index > 5 ){ ui.txtTxData2->hide(); } else { ui.txtTxData2->show(); }
		if( index > 6 ){ ui.txtTxData1->hide(); } else { ui.txtTxData1->show(); }
		if( index > 7 ){ ui.txtTxData0->hide(); } else { ui.txtTxData0->show(); }
	}

}

// tblTxData_CellClickd
void TxData::tblTxData_CellClicked(int row_gen, int column_gen)
{
	int ret;
	int lp;
	int check_count;
	int row;
	int row_max;
	QString qt_str;
	QString line;
	QStringList coords;
	QTableWidgetItem * pItem;
	QMessageBox msgBox;
	DWORD TimerCount = 0;

	TxRow = row_gen;

	if( DoubleClickFlag == 0 ){
		ui.tblTxData->selectRow(ui.tblTxData->currentRow());
	}
	DoubleClickFlag = 0;

	// Count Check
	for( lp = 0; lp < IntervalCount; lp=lp+1 ){
		line = TxDataLine[lp];
		coords = line.split(" ");
		row = coords[0].toUInt(0,10);
		pItem = ui.tblTxData->item(row, 6);
		pItem->setText(coords[3]);
	}

	// Timer Check
	check_count = 0;
	row_max = ui.tblTxData->rowCount();
	for( lp=0; lp<row_max; lp=lp+1 ){
		pItem = ui.tblTxData->item(lp, 0);
		if( pItem->checkState() ){
			if( pItem->text() == "0" ){
				pItem->setCheckState(Qt::Unchecked);
			} else {
				check_count = check_count + 1;
			}
		}
	}

	// WriteMessageLoopf
	if( check_count == 0 ){
		WriteTimer->stop();
		IntervalCount = 0;
		TimerCountCycle = 0;
	} else if( check_count > 10 ){
		qt_str = "Error: The number of Loop Write Message exceeds a limit 10 Messages!";
		ret = QMessageBox::warning(this, tr("Write Messages Loop"),
												qt_str,
												QMessageBox::Yes | QMessageBox::Default);
		pItem = ui.tblTxData->item(row_gen, 0);
		pItem->setCheckState(Qt::Unchecked);
	} else {
		// TxDataLine Clear
		for( int no=TxDataLine.count()-1; no>=0; no=no-1 ) {
			TxDataLine.removeAt(0);
		}
		if( pHardware->HardwareInitSet == 0 ){
			msgBox.setText("Error: Hardware Not Initialize!");
			ret = msgBox.exec();
			pItem = ui.tblTxData->item(row_gen, 0);
			pItem->setCheckState(Qt::Unchecked);
		} else if( ui.tblTxData->rowCount() == 0 ){
			msgBox.setText("Error: Write Message Not Setting!");
			ret = msgBox.exec();
			pItem = ui.tblTxData->item(row_gen, 0);
			pItem->setCheckState(Qt::Unchecked);
		} else {
			check_count = 0;
			WriteTimer->stop();
			for( lp=0; lp<row_max; lp=lp+1 ){
				pItem = ui.tblTxData->item(lp, 0);
				if( pItem->checkState() ){
					// WriteMessage擾
					qt_str.sprintf("%d ", lp);
					qt_str = qt_str + pItem->text() + " 0";
					pItem = ui.tblTxData->item(lp, 6);
					qt_str = qt_str + " " + pItem->text();
					pItem = ui.tblTxData->item(lp, 1);
					qt_str = qt_str + " " + pItem->text();
					pItem = ui.tblTxData->item(lp, 2);
					qt_str = qt_str + " " + pItem->text();
					pItem = ui.tblTxData->item(lp, 3);
					qt_str = qt_str + " " + pItem->text();
					pItem = ui.tblTxData->item(lp, 4);
					qt_str = qt_str + " " + pItem->text();
					pItem = ui.tblTxData->item(lp, 5);
					qt_str = qt_str + " " + pItem->text();
					// WriteMessageێ
//					coords = qt_str.split(" ");
//					TxDataLine[check_count] = coords;
					TxDataLine.append(qt_str);
					check_count = check_count + 1;
				}
			}
			TxMode = 0;
			IntervalCount = check_count;
			DisplayTime = (ui.txtDisplayTime->text()).toUInt(0,10);
			TimerCount = 1;
			WriteTimer->start(TimerCount);
		}
	}

}

// tblTxData_CellDoubleClickd
void TxData::tblTxData_CellDoubleClicked(int row_gen, int column_gen)
{
	int lp_row;
	int lp_col;
	int index;
	QString qt_str;
	QStringList coords;
	QTableWidgetItem * pItem;

	TxRow = row_gen;
	TxRowSelect = row_gen;
	ui.tblTxData->selectRow(ui.tblTxData->currentRow());
	DoubleClickFlag = 1;

	// Data DoubleClick
	if( column_gen == 5 ){
		for( lp_col = 0; lp_col < 7; lp_col=lp_col+1 ){
			pItem = ui.tblTxData->item(row_gen, lp_col);
			qt_str = pItem->text();
			if( lp_col == 0 ){
				ui.txtTxTimerCount->setText(qt_str);
			} else if( lp_col == 1 ){
				if( qt_str == "EXT" ){
					ui.chbTxExtended->setChecked(true);
				} else {
					ui.chbTxExtended->setChecked(false);
				}
			} else if( lp_col == 2 ){
				ui.txtTxCobId->setText(qt_str);
			} else if( lp_col == 3 ){
				ui.txtTxId->setText(qt_str);
			} else if( lp_col == 4 ){
				if( qt_str == "8" ){ index = 0;
				} else if( qt_str == "7" ){ index = 1;
				} else if( qt_str == "6" ){ index = 2;
				} else if( qt_str == "5" ){ index = 3;
				} else if( qt_str == "4" ){ index = 4;
				} else if( qt_str == "3" ){ index = 5;
				} else if( qt_str == "2" ){ index = 6;
				} else { index = 7;
				}
				ui.cbbTxLength->setCurrentIndex(index); 
				if( index <= 0 ){ ui.txtTxData7->show(); } else { ui.txtTxData7->hide(); }
				if( index <= 1 ){ ui.txtTxData6->show(); } else { ui.txtTxData6->hide(); }
				if( index <= 2 ){ ui.txtTxData5->show(); } else { ui.txtTxData5->hide(); }
				if( index <= 3 ){ ui.txtTxData4->show(); } else { ui.txtTxData4->hide(); }
				if( index <= 4 ){ ui.txtTxData3->show(); } else { ui.txtTxData3->hide(); }
				if( index <= 5 ){ ui.txtTxData2->show(); } else { ui.txtTxData2->hide(); }
				if( index <= 6 ){ ui.txtTxData1->show(); } else { ui.txtTxData1->hide(); }
				if( index <= 7 ){ ui.txtTxData0->show(); } else { ui.txtTxData0->hide(); }
			} else if( lp_col == 5 ){
				index = ui.cbbTxLength->currentIndex(); 
				if( qt_str == "RTR" ){
					ui.chbRemoteRequest->setChecked(true);
					ui.txtTxData7->hide();
					ui.txtTxData6->hide();
					ui.txtTxData5->hide();
					ui.txtTxData4->hide();
					ui.txtTxData3->hide();
					ui.txtTxData2->hide();
					ui.txtTxData1->hide();
					ui.txtTxData0->hide();
				} else {
					ui.chbRemoteRequest->setChecked(false);
					coords = qt_str.split(" ");
					if( index <= 0 ){ ui.txtTxData7->setText(coords[7]); }
					if( index <= 1 ){ ui.txtTxData6->setText(coords[6]); }
					if( index <= 2 ){ ui.txtTxData5->setText(coords[5]); }
					if( index <= 3 ){ ui.txtTxData4->setText(coords[4]); }
					if( index <= 4 ){ ui.txtTxData3->setText(coords[3]); }
					if( index <= 5 ){ ui.txtTxData2->setText(coords[2]); }
					if( index <= 6 ){ ui.txtTxData1->setText(coords[1]); }
					if( index <= 7 ){ ui.txtTxData0->setText(coords[0]); }
				}
			}
		}
	}

	// CobID or NodeID DoubleClick
	if( column_gen == 2 || column_gen == 3 ){
		TxDataWrite();
	}

}
// TaDataInit
QString TxData::TxDataInit(int mode, QString line)
{
	int i;
	int count;
	int row_max;
	QString qt_str;
	QStringList coords;
	QTableWidgetItem * pItem;

	qt_str = "";

	if( mode == 0 ){
		// Load Initialize Mode 
		coords = line.split(",");
		if( coords[0] == "###" ){
		} else {
			row_max = coords.size() / 7;
			for( i = 0; i < row_max; ++i ){
				ui.tblTxData->setRowCount(i+1);
				for(count = 0; count < 7; count=count+1 ){
					pItem = new QTableWidgetItem();
					ui.tblTxData->setItem(i, count, pItem);
					if( count == 0 ){
						pItem->setCheckState(Qt::Unchecked);
						pItem->setText(coords[(i*7)+count]);
					} else {
						pItem->setText(coords[(i*7)+count]);
					}
				}
			}
			ui.tblTxData->resizeColumnsToContents();
			ui.tblTxData->resizeRowsToContents();
		}
	} else {
		// Save Initialize Mode 
		row_max = ui.tblTxData->rowCount();
		if( row_max == 0 ){
			qt_str = "###,###";
		} else {
			for( i = 0; i < row_max; ++i ){
				for(count = 0; count < 7; count=count+1 ){
					pItem = ui.tblTxData->item(i, count);
					if( count == 6 ){
						if(( i+1 ) == row_max ){
//							qt_str = qt_str + "0\n,";
							qt_str = qt_str + "0,";
						} else {
							qt_str = qt_str + "0,";
						}
					} else {
						qt_str = qt_str + pItem->text() + ",";
					}
				}
			}
		}
	}

	return qt_str;

}
int TxData::ValueCheck(QString ValueString)
{
	int error_flag;
	int loop;
	int ValueLength;
	QString GetValue;

	error_flag = 1;
	ValueLength = ValueString.length();
	for( loop=0; loop<ValueLength; loop=loop+1 ){
		GetValue = ValueString[loop];
		if( "0" == GetValue ){        error_flag = 0;
		} else if( "1" == GetValue ){ error_flag = 0;
		} else if( "2" == GetValue ){ error_flag = 0;
		} else if( "3" == GetValue ){ error_flag = 0;
		} else if( "4" == GetValue ){ error_flag = 0;
		} else if( "5" == GetValue ){ error_flag = 0;
		} else if( "6" == GetValue ){ error_flag = 0;
		} else if( "7" == GetValue ){ error_flag = 0;
		} else if( "8" == GetValue ){ error_flag = 0;
		} else if( "9" == GetValue ){ error_flag = 0;
		} else if( "a" == GetValue ){ error_flag = 0;
		} else if( "b" == GetValue ){ error_flag = 0;
		} else if( "c" == GetValue ){ error_flag = 0;
		} else if( "d" == GetValue ){ error_flag = 0;
		} else if( "e" == GetValue ){ error_flag = 0;
		} else if( "f" == GetValue ){ error_flag = 0;
		} else if( "A" == GetValue ){ error_flag = 0;
		} else if( "B" == GetValue ){ error_flag = 0;
		} else if( "C" == GetValue ){ error_flag = 0;
		} else if( "D" == GetValue ){ error_flag = 0;
		} else if( "E" == GetValue ){ error_flag = 0;
		} else if( "F" == GetValue ){ error_flag = 0;
		} else {
			error_flag = 1;
			break;
		}
	}
	return error_flag;

}
////////////////////////////////////////
// Setting Menu
////////////////////////////////////////
void TxData::createMenus()
{
	QMenu   * pMenu;

	//File Menu
	pMenu = ui.menuBar->addMenu( tr("File") );
	SettingMenu.pMenu = pMenu;
    connect(pMenu, SIGNAL(aboutToShow()), this, SLOT(menu_triggered()));

	createMenuActions();

}
void TxData::createMenuActions()
{
	QAction * pAction;
	QString qt_str;

	/* Clear */
	SettingMenu.pMenu->clear( );
	
	/* Load File */
	pAction = new QAction( tr("Open Write Message"), this );
	pAction->setShortcut(tr("Ctrl+O"));
	SettingMenu.pLoadFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_loadfile()));

	/* Save File */
	pAction = new QAction( tr("Save Write Message"), this );
	pAction->setShortcut(tr("Ctrl+S"));
	SettingMenu.pSaveFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_savefile()));

}

////////////////////////////////////////
// Menu Action
////////////////////////////////////////
void TxData::menu_triggered()
{
	createMenuActions();
}
void TxData::menu_loadfile()
{
	DWORD loop;
	QString qt_str;
	QString line;
	QString qt_ret;

	// File Select
	QString fileName = QFileDialog::getOpenFileName(
														this,
					   									tr("Load File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile LoadFile(fileName);

	// File Read
	if (LoadFile.open(QIODevice::ReadOnly)) {
		QTextStream in(&LoadFile);
		qt_str = "";
		while (!in.atEnd()) {
			line = in.readLine();
			if( line[0] != '#' ){
				qt_str = qt_str + line + ",";
			}
		}
		// Load Setting
		qt_ret = TxDataInit(0, qt_str);
		// File Close
		LoadFile.close();
		// File Close
		pInformation->Information_append("Load File successfully");
	} else {
		pInformation->Information_append("Can not open load file");
	}

}
void TxData::menu_savefile()
{
	DWORD loop;
	DWORD loop_max;
	QString qt_str;
	QString line;
	QString qt_ret;

	// File Select
	QString fileName = QFileDialog::getSaveFileName(
														this,
					   									tr("Save File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile SaveFile(fileName);

	// File Write
	if(SaveFile.open(QIODevice::WriteOnly)) {
		QTextStream outputfile(&SaveFile);
		line = TxDataInit(1,qt_str);
		QStringList coords = line.split(",");
		loop_max = coords.size() / 7;
		for( loop = 0; loop < loop_max; loop=loop+1 ){
			qt_str = "";
			qt_str = qt_str + coords[loop*7]   + ",";
			qt_str = qt_str + coords[loop*7+1] + ",";
			qt_str = qt_str + coords[loop*7+2] + ",";
			qt_str = qt_str + coords[loop*7+3] + ",";
			qt_str = qt_str + coords[loop*7+4] + ",";
			qt_str = qt_str + coords[loop*7+5] + ",";
			qt_str = qt_str + coords[loop*7+6] + "\n";
			outputfile << qt_str;
		}
		// File Close
		SaveFile.close();
		// File Close
		pInformation->Information_append("Save File successfully");
	} else {
		pInformation->Information_append("Can not open save file");
	}

}

