#ifndef TXDATA_H
#define TXDATA_H

#include <QtGui>
#include <QWidget>
#include <qtimer.h>
#include "ui_txdata.h"
#include "hardware.h"
#include "information.h"
#include "PCANBasic.h"

//#define	cTxDataBufferMax	10000000

class FCAN_View;

class TxData : public QWidget
{
	Q_OBJECT

public:
	TxData(QWidget *parent = 0);
	~TxData();

	void HardwareSet( Hardware * hardware );
	void InformationSet( Information * information );
	void FcanViewSet( FCAN_View * fcanview );
	QString TxDataInit(int mode, QString line);

private slots:
	// btnWrite
	void btnWrite_Click();
	// btnWriteFile
	void btnWriteFile_Click();
	// Write Messages File
	void btnWriteFileFind_Click();
	// btnSetMessage
	void btnSetMessage_Click();
	// btnOverWriteMessage
	void btnOverWriteMessage_Click();
	// btnDelMessage
	void btnDelMessage_Click();
	// chbTxExtended
	void chbTxExtended_Toggled();
	// cbbTxLength
	void cbbTxLength_Changed( const QString &s );
	// chbRemoteRequest
	void chbRemoteRequest_Toggled();
	// chbDisplay
	void chbDisplay_Toggled();
	// Timer
	void timWrite();
	// tblTxData_CellClickd
	void tblTxData_CellClicked(int row, int column);
	// tblTxData_CellDoubleClickd
	void tblTxData_CellDoubleClicked(int row, int column);
	// File Menu
	void menu_triggered( );
	// Load File
	void menu_loadfile( );
	// Save File
	void menu_savefile( );
	// Close
	void closeEvent( QCloseEvent * event );
	// resizeEvent
    void resizeEvent(QResizeEvent *event);
	// keyPressEvent
    void keyPressEvent(QKeyEvent *event);

private:
	Ui::TxData ui;

	Hardware * pHardware;
	Information * pInformation;
	FCAN_View * pFcanView;

	// TxDataWrite
	void TxDataWrite();
	// Write Messages
	TPCANStatus Write_Message(TPCANMsg* MessageBuffer);

	// Timer
	QTimer	*WriteTimer;

	void DelMessage();
	void SetMessage();
	void createMenus();
	void createMenuActions();
	int ValueCheck(QString ValueString);

	int WriteFileLine;
	int WriteFileLineMax;
	int MessageCount;
	int TxMode;
	int TxRow;
	int TxRowSelect;
	int IntervalCount;
	int RemoteRequestMode;
	int DoubleClickFlag;
	int OverWriteFlag;
	int TimerCountCycle;
	int DisplayTime;
//	QStringList TxDataLine[cTxDataBufferMax];
	QStringList TxDataLine;

	struct {
		QMenu * pMenu;
		QAction * pLoadFile;
		QAction * pSaveFile;
	} SettingMenu;

};

#endif // TXDATA_H
