fcf.module({
  name: "fcfControls:templates/language-selector.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArgLanguage (a_value) {
        let languageIdentification = this.getArg("languageIdentification");
        let languages              = this.getArg("languages");
        fcf.getContext().set("language", a_value);

        let url = window.location.href;
        url = url.split("#")[0];
        if (languageIdentification.byPrefix){
          let pathArr = fcf.trim(window.location.pathname, "/").split("/");
          let prefix = pathArr[0];
          if (prefix.length == 2 && prefix in languages){
            let newPathArr = fcf.clone(pathArr);
            newPathArr[0] = a_value;
            url = url.replace("/" + pathArr.join("/"), "/" + newPathArr.join("/"))
          }
        }

        if (languageIdentification.byParameter){
          let urlInfo = fcf.parseUrl(url);
          urlInfo.args[languageIdentification.parameter] = a_value;
          url = fcf.buildUrl(urlInfo.referer, urlInfo.args);
        }

        window.location.href = url;
      }

    };
  }
});
