fcf.module({
  name: "fcfManagement:NController/InnerFSQL.js",
  dependencies: ["fcf:NServer/NControllers/Controller.js"],
  module: function(Controller) {
    var NController = fcf.prepareObject(fcf, "packages.fcfManagement.NController");

    NController.InnerFSQL = class InnerFSQL extends  Controller{
      constructor(a_options){
        super(a_options);
        this._externalMode = true;
        this.userImportance = true;
      }
      action(a_request) {
        let self = this;
        let result = {};
        let query = a_request.getRoute().args.query;
        let args  = a_request.getRoute().args.args;

        if (!fcf.access("root")) {
          a_request.sendError(new fcf.Exception("ERROR_ACCESS", {resource: "/fcfpackages/fcfManagement/fsql"}));
          return;
        }

        fcf.application.getStorage().query({ query: query, args: args, external: this._externalMode}, function(a_error, a_data){
          if (a_error){
            a_request.sendError(a_error);
            return;
          }
          a_request.send(a_data);
        })
      }
    }

    return NController.InnerFSQL;
  }
});
