fcf.module({
  name: "fcf:NFSQL/NDetails/AutomateInsert.js",
  dependencies: ["fcf:NFSQL/NDetails/AutomateSingleField.js", "fcf:NFSQL/NDetails/AutomateSingleValue.js", "fcf:NFSQL/NDetails/AutomateLanguageItem.js"],
  module: function(AutomateSingleField, AutomateSingleValue, AutomateLanguageItem) {
    var Automate = fcf.prepareObject(fcf, "NFSQL.NDetails.Automate");


    Automate.StepInsert_StartSkipSpace = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepInsert_Into", skipFirst: false};

      this.actionSwitch = function() {
        this.state.details.insert = {
          fields: [],
          values: [],
        };
      }
    }

    Automate.StepInsert_Into = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = {map:{ "into": { factory: "StepSingleField", exit: "StepInsert_WaitFields", dstValue: "from", skipFirst: false}, }};
    }

    Automate.StepInsert_WaitFields = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["("] = { factory: "StepSingleField", exit: "StepInsert_FieldsWaitNext", dstValue: "details.insert.fields", skipFirst: true};
    }

    Automate.StepInsert_FieldsWaitNext = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map[","] = { factory: "StepSingleField", exit: "StepInsert_FieldsWaitNext", dstValue: "details.insert.fields", skipFirst: true};
      this.map[")"] = { factory: "StepInsert_WaitValues", skipFirst: true};
    }

    Automate.StepInsert_WaitValues = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepInsert_ReadValues", skipFirst: false};
    }

    Automate.StepInsert_ReadValues = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = { map: { "values": { factory: "StepInsert_Values_WaitArr", skipFirst: false} } };
    }

    Automate.StepInsert_Values_WaitArr = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["("] = {
                        factory: "StepSingleValue",
                        exit: "StepInsert_Values_Next",
                        dstValue: "details.insert.values",
                        skipFirst: true,
                        path: `values[${this.state.details.insert.values.length}].value`,
                      };
    }

    Automate.StepInsert_Values_Next = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map[","] = {
                        factory: "StepSingleValue",
                        exit: "StepInsert_Values_Next",
                        dstValue: "details.insert.values",
                        skipFirst: true,
                        path: `values[${this.state.details.insert.values.length}].value`,
                      };
      this.map[")"] = { factory: "StepInsert_Values_End", skipFirst: true};
    }

    Automate.StepInsert_Values_End = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map[""]  = { factory: "StepInsert_WaitLanguage", skipFirst: false};

      this.actionSwitch = function() {
        for(var i = 0; i < this.state.details.insert.fields.length; ++i){
          this.state.values.push(fcf.append({field: this.state.details.insert.fields[i]},this.state.details.insert.values[i]));
        }
      }
    }

    Automate.StepInsert_WaitLanguage = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map[""]  = { factory: "LanguageItem_Start", skipFirst: false};
    }

    return Automate;
  }
});
