fcf.module({
  name: "fcfSimpleAuthorization:Client.js",
  dependencies: [],
  module: function(){
    var Namespace = fcf.prepareObject(fcf, "packages/fcfSimpleAuthorization");

    class Client {
      constructor() {
      }

      createSingInDialog() {
        return fcf.application.render({
          template: "@controls:dialog",
          owner:    fcf.application.getRootWrapper(),
          args: {
            title:    fcf.t("Sign in"),
            content:  fcf.argTmpl("fcfSimpleAuthorization:templates/signin-form.tmpl",
                                  {
                                    fcfAlias: "form",
                                  }),
            buttons: fcf.argVal([
              fcf.argTmpl("@controls:button", {fcfAlias: "ok", title: fcf.t("Sign in"), fcfEventClick: "fcf.packages.fcfSimpleAuthorization.Client.closeSignInDialog(event, parent)" }),
              fcf.argTmpl("@controls:button", {fcfAlias: "cancel", title: fcf.t("Cancel"),  fcfEventClick: "parent.close('cancel')" })
            ]),
          }
        });
      }

      closeSignInDialog(a_event, a_dialog){
        a_event.preventDefault();

        a_dialog.getChild("ok").setArg("enable", false);
        a_dialog.getChild("cancel").setArg("enable", false);
        a_dialog.getChild("form").signin()
        .then(()=>{
          a_dialog.destroy();
          location.reload();
        })
        .catch(()=>{
          a_dialog.getChild("ok").setArg("enable", true);
          a_dialog.getChild("cancel").setArg("enable", true);
          a_dialog.update();
        });
      }

      createRegistrationDialog() {
        return fcf.application.render({
          template: "@controls:dialog",
          owner:    fcf.application.getRootWrapper(),
          args: {
            title:    fcf.t("Registration"),
            content:  fcf.argTmpl("fcfSimpleAuthorization:templates/registration-form.tmpl",
                                  {
                                    fcfAlias: "form",
                                  }),
            buttons: fcf.argVal([
              fcf.argTmpl("@controls:button", {fcfAlias: "ok", title: fcf.t("Registration"), fcfEventClick: "fcf.packages.fcfSimpleAuthorization.Client.closeRegistrationDialog(event, parent)" }),
              fcf.argTmpl("@controls:button", {fcfAlias: "cancel", title: fcf.t("Cancel"),  fcfEventClick: "parent.close('cancel')" })
            ]),
          }
        });
      }

      closeRegistrationDialog(a_event, a_dialog){
        a_event.preventDefault();

        a_dialog.getChild("ok").setArg("enable", false);
        a_dialog.getChild("cancel").setArg("enable", false);

        let email =  a_dialog.getChild("form").getArg("value.email");
        a_dialog.getChild("form").registration()
        .then(()=>{
          return fcf.application.render({
            template: "@controls:dialog",
            owner:    fcf.application.getRootWrapper(),
            args: {
              title:    fcf.t("Registration"),
              content:  fcf.argTmpl("fcfSimpleAuthorization:templates/confirm-registration-form.tmpl",
                                    {
                                      fcfAlias: "form",
                                      email:    email
                                    }),
              buttons: fcf.argVal([
                fcf.argTmpl("@controls:button", {title: fcf.t("Ok"),  fcfEventClick: "parent.close('ok')" })
              ]),
            }
          });
        })
        .then(()=>{
          a_dialog.destroy();
        })
        .catch(()=>{
          a_dialog.getChild("ok").setArg("enable", true);
          a_dialog.getChild("cancel").setArg("enable", true);

        })
      }


      logout(){
        fcf.getContext().set("session", undefined);
        location.reload();
      }

    };

    Namespace.Client = new Client();

    return Namespace.Client;
  }
});
