fcf.module({
  name: "fcf:NFSQL/NDetails/Errors.js",
  dependencies: [],
  module: function() {
    fcf.addException("ERROR_NFSQL_EXTERNAL_ACCESS_DENIED", "External access is denied for projection '${{projection}}$'. Mode: ${{mode}}$");

    fcf.addException("ERROR_NFSQL_UNKNOWN_FUNCTION", "The request uses an unknown function '${{function}}$'");
    fcf.addException("ERROR_NFSQL_UNKNOWN_PROJECTION_IN_QUERY", "The projection ${{1}}$ specified was not found in the request");
    fcf.addException("ERROR_NFSQL_UNKNOWN_CLIENT_GROUP_IN_QUERY", "DB connection client not found for connection group ${{1}}$");

    fcf.addException("ERROR_NFSQL_UNKNOWN_PROJECTION_IN_REF", "The projection ${{refproj}}$ of the reference field ${{field}}$ is not available");
    fcf.addException("ERROR_NFSQL_UNKNOWN_FIELD_IN_REF", "The ${{reffield}}$ field does not exist for the reference field ${{field}}$");

    fcf.addException("ERROR_NFSQL_MISSING_FIELD_HANDLER", "The '${{projection}}$.${{field}}$' field does not have a handler for '${{handlerName}}$'");
    fcf.addException("ERROR_NFSQL_UNKNOWN_PROJECTION_IN_FIELD", "The projection ${{projection}}$ for the field ${{field}}$ is not available");
    fcf.addException("ERROR_NFSQL_UNKNOWN_FIELD_IN_QUERY", "The field ${{field}}$ is missing in the projection ${{projection}}$");
    fcf.addException("ERROR_NFSQL_UNKNOWN_FUNCTION_IN_QUERY", "The ${{function}}$ function specified in the request is not available");


    fcf.addException("ERROR_NFSQL_FIELD_SINGLE_REF_INCORECT_SUBFIELD", "An invalid subfield ${{subfield}}$ was specified for the field '${{projection}}$.${{field}}$'");
    fcf.addException("ERROR_NFSQL_FIELD_SINGLE_REF_INCORECT_MODE",     "Invalid mode specified in the ${{mode}}$ for the '${{projection}}$.${{field}}$' field");

    fcf.addException("ERROR_NFSQL_FIELD_MAX_LENGTH",     "The length of the field '${{projection}}$.${{field}}$' exceeds the maximum length of ${{length}}$");
    fcf.addException("ERROR_NFSQL_FIELD_MIN_LENGTH",     "The length of the field '${{projection}}$.${{field}}$' is less than the minimum length ${{length}}$");

    fcf.addException("ERROR_NFSQL_NOTNULL_FIELD_NOTNULL",  "The field '${{projection}}$.${{field}}$' marked as NOT NULL is not specified");
    fcf.addException("ERROR_NFSQL_NOTNULL_FIELD_NOTCREATE", "The field '${{projection}}$.${{field}}$' cannot be set when creating a record");
    fcf.addException("ERROR_NFSQL_INCORRECT_INTEGER_TYPE", "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' does not match the int type");
    fcf.addException("ERROR_NFSQL_INCORRECT_INTEGER_MIN",  "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' is less than the minimum value ${{min}}$");
    fcf.addException("ERROR_NFSQL_INCORRECT_INTEGER_MAX",  "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' is greater than the maximum value ${{max}}$");
    fcf.addException("ERROR_NFSQL_INCORRECT_FLOAT_TYPE",   "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' does not match the float type");
    fcf.addException("ERROR_NFSQL_INCORRECT_FLOAT_MIN",    "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' is less than the minimum value ${{min}}$");
    fcf.addException("ERROR_NFSQL_INCORRECT_FLOAT_MAX",    "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' is greater than the maximum value ${{max}}$");
    fcf.addException("ERROR_NFSQL_INCORRECT_BOOLEAN_TYPE", "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' does not match the boolean type");
    fcf.addException("ERROR_NFSQL_INCORRECT_DATETIME_TYPE", "The value ${{value}}$ of the field '${{projection}}$.${{field}}$' does not match the datetime type");



    fcf.addException("ERROR_NFSQL_FIELD_EXTERNREF_INCORRECT_PROJECTION", "The '${{refprojection}}$' projection of an external link is not available for the '${{projection}}$.${{field}}$' field");
    fcf.addException("ERROR_NFSQL_FIELD_EXTERNREF_INCORRECT_SELFFIELD",  "The selfField parameter for the field '${{projection}}$.${{field}}$' refers to the invalid field '${{refprojection}}$.${{reffield}}$'");
    fcf.addException("ERROR_NFSQL_FIELD_EXTERNREF_INCORRECT_REFFIELD",   "The refField parameter for the field '${{projection}}$.${{field}}$' refers to the invalid field '${{refprojection}}$.${{reffield}}$'");
    fcf.addException("ERROR_NFSQL_FIELD_EXTERNREF_INCORRECT_SELFFIELD_NOTREF",  "The selfField parameter for the field '${{projection}}$.${{field}}$' refers to the field '${{refprojection}}$.${{reffield}}$' which is not a singleref type");
    fcf.addException("ERROR_NFSQL_FIELD_EXTERNREF_INCORRECT_REFFIELD_NOTREF",   "The refField parameter for the field '${{projection}}$.${{field}}$' refers to the field '${{refprojection}}$.${{reffield}}$' which is not a single red type");
    fcf.addException("ERROR_NFSQL_FIELD_EXTERNREF_INCORRECT_SUBFIELD",          "The field '${{projection}}$.${{field}}$' does not support the subfield '${{subfield}}$'");


    fcf.addException("ERROR_NFSQL_INCORRECT_QUERY_OBJECT",  "Invalid object request format");
    fcf.addException("ERROR_NFSQL_INCORRECT_TYPE_QUERY",    "Invalid object request type ${{type}}$");
    fcf.addException("ERROR_NFSQL_FIELDS_NOT_SET",          "The fields property is not specified in the request");
  }
});
