fcf.module({
  name: "fcfControls:templates/float-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class FloatWrapper extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._lastValue = this.getArg("displayValue");
        this._lastSelection = undefined;
      }

      getActionDomElement(){
        return fcf.first(fcf.select(this.getDomElement(), "input"));
      }

      onArgValue(a_value, a_editor, a_ignoreRedrawing, a_innerCall, a_suffix){
        if (a_innerCall)
          return;
        this.setArg("displayValue", a_value);
        this._lastValue = a_value;
        this._lastSelection = undefined;
      }

      onKeyDown(a_event){
        if (a_event.key == "ArrowLeft" ||
            a_event.key == "ArrowRight" ||
            a_event.key == "ArrowTop" ||
            a_event.key == "ArrowBottom"){
          this._lastSelection = undefined;
        }
      }

      onMouseDown(a_event){
        this._lastSelection = undefined;
      }

      onInput(a_event) {
        var dotCount = 0;
        var charCode0 = "0".charCodeAt(0);
        var charCode9 = "9".charCodeAt(0);
        var incorrect = false;
        fcf.each(this.getActionDomElement().value, function(a_key, a_char){
          var cc = a_char.charCodeAt()
          if (a_char == ".")
            ++dotCount;
          if ( (cc >= charCode0 && cc <= charCode9) ||
               (a_key == 0 && a_char == "-") ||
               (dotCount == 1 && a_char == ".")
              ) {
            return;
          } else {
            incorrect = true;
            return false;
          }
        });

        if (incorrect) {
          this.getActionDomElement().value = fcf.str(this._lastValue);
          return;
        }

        let value = fcf.trim(this.getActionDomElement().value);
        if (value == "-" || value == ""){
          value = this.getArg("emptyValue");
        } else {
          if (isNaN(parseFloat(value))){
            incorrect = true;
          } else {
            value = parseFloat(value);
          }
        }

        if (!incorrect && typeof this.getArg("min") == "number"){
          if (fcf.empty(value) || value < this.getArg("min")){
            value =  this.getArg("min");
            if (this.getActionDomElement().value != value) {
              let element = this.getActionDomElement();
              element.value = value.toString();
              if (this._lastSelection === 0 || this._lastSelection === 1){
                this._lastSelection = undefined;
                element.setSelectionRange(0, 0);
              } else if (this._lastSelection !== undefined){
                element.setSelectionRange(this._lastSelection-1, this._lastSelection);
                --this._lastSelection;
              } else {
                element.setSelectionRange(element.value.length-1, element.value.length-1);
                this._lastSelection = element.value.length-1;
              }
            }
          } else {
            this._lastSelection = undefined;
          }
        }

        if (!incorrect && !fcf.empty(value) && typeof this.getArg("max") == "number"){
          if (value > this.getArg("max")){
            value = this.getArg("max");
            this.getActionDomElement().value = value;
          }
        }

        if (!incorrect){
          this._lastValue = this.getActionDomElement().value;
          this._setArg("value", value);
          this._setArg("displayValue", this._lastValue);
        } else {
          this.getActionDomElement().value = fcf.str(this._lastValue);
        }
      }

    };
  }
});
