fcf.module({
  name: "fcfManagement:templates/pages/system/sitemap+body.hooks.js",
  dependencies: ["fcf:NSystem/Sitemap.js"],
  module: function(Sitemap){
    return {
      //
      // void hookBeforeBuild(a_taskInfo)
      // The hook is executed before assembling the template arguments
      //
      // hookBeforeBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after assembling the template arguments
      //
      // hookAfterBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after building the template's system arguments
      //
      // hookAfterSystemBuild: function(a_taskInfo) {
      // },

      //
      // Object of hooks for programmatically populated arguments
      //
      hooksProgramableArgument: {
        enableMultilingual: ()=>{
          let sitemap = new Sitemap();
          return sitemap.resulutionMultilingual();
        },
        settings: async (a_taskInfo)=>{
          let sitemap = new Sitemap();
          let items = await sitemap.getItems();
          let sitemapSettings = await fcf.application.getSystemVariable("fcf", "sitemapSettings");
          sitemapSettings = typeof sitemapSettings == "object" ? sitemapSettings : {};
          sitemapSettings.sitemapItems = items;
          sitemapSettings.multilingual = sitemap.getMultilingual();
          return sitemapSettings;
        }
      },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   ARG_NAME: (a_taskInfo)=>{
      //   }
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      // hooksAfterArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   ARG_NAME: (a_taskInfo)=>{
      //   }
      // },
    };
  }
});
