fcf.module({
  name: "fcf:tests/tokenize.test.js",
  dependencies: ["fcf:NTest/uniTest.js"],
  module: function(uniTest) {
    uniTest.add("005 base" , "Tokenize", function(a_tester) {
      uniTest.equal(fcf.tokenize("-${{args}}$-", {args: 1}), "-1-");
      uniTest.equal(fcf.tokenize("${{args}}$-", {args: 1}), "1-");
      uniTest.equal(fcf.tokenize("-${{args}}$", {args: 1}), "-1");
      uniTest.equal(fcf.tokenize("-${{a}}$-${{b}}$-", {a: 1, b: 2}), "-1-2-");
      uniTest.equal(fcf.tokenize("-${{a}}$${{b}}$-", {a: 1, b: 2}), "-12-");
      uniTest.equal(fcf.tokenize("-${{a}}$-${{b}}$", {a: 1, b: 2}), "-1-2");
      uniTest.equal(fcf.tokenize("${{a}}$${{b}}$", {a: 1, b: 2}), "12");

      uniTest.equal(fcf.tokenize("#{{a}}#", {a: {val:1}}), {val:1});
      uniTest.equal(fcf.tokenize("-#{{a}}#", {a: {val:1}}), '-[object Object]');
      uniTest.equal(fcf.tokenize("-#{{a}}#-", {a: {val:1}}), '-[object Object]-');

      uniTest.equal(fcf.tokenize("-@{{a/2}}@-", {a: 2}), '-1-');
      uniTest.equal(fcf.tokenize("-@{{a.substr(0,1)}}@-", {a: "test"}), '-t-');
    });
  }
});
