fcf.module({
  name: "fcf:NSystem/NPackage/ThemePackage.js",
  dependencies: ["fcf:NSystem/NPackage/Package.js", "fcf:NSystem/NPackage/Theme.js", "fcf:NSystem/NPackage/tools.js"],
  lazy:         ["fcf:NSystem/NPackage/packageLoader.js"],
  module: function(Package, Theme, tools){
    var NPackage = fcf.prepareObject(fcf, "NSystem/NPackage");

    let initEventListenerFlag = false;

    function initEventListener(){
      if (initEventListenerFlag)
        return;
      initEventListenerFlag = true;
      fcf.application.getEventChannel().on("fcf_load_package", (a_event)=>{
        let configuration = fcf.filter(fcf.application.getConfiguration(), (a_key, a_item)=>{ return typeof a_item != "function" });
        fcf.each(NPackage.packageLoader.getThemes(), (a_key, a_theme)=>{
          a_theme.rebuild();
        })
      });
    }


    class ThemePackage extends Package {
      constructor(a_name, a_directory, a_configuration){
        super(a_name, a_directory, a_configuration);
        this._handlerFile = "theme.js";
        this._theme = new Theme(a_name, a_configuration);
        initEventListener();
      }

      isTheme() {
        return true;
      }

      rebuild(){
        this._theme.rebuild();
      }

      getDecor(){
        return this._theme.getDecor();
      }

      getInfo(){
        return this._theme.getInfo();
      }

      resolveAlias(a_path){
        return this._theme.resolveAlias(a_path);
      }

      getAliases(){
        return this._theme.getAliases();
      }

      setAliases(a_aliases){
        return this._theme.setAliases(a_aliases);
      }

      getConfiguration(){
        return this._theme.getConfiguration();
      }

      async _setConfiguration() {
        if (!fcf.empty(this._configuration.extends)) {
          await NPackage.packageLoader.load(this._configuration.extends);
          let extendsTheme = NPackage.packageLoader.getThemes()[this._configuration.extends];
          tools.mergeConfiguration(this._configuration, extendsTheme.getInfo(), false);
        }

        let configuration = fcf.append({}, this._configuration);
        delete configuration.html;
        delete configuration.aliases;
        delete configuration.usageViews;
        fcf.application.getConfiguration().appendConfiguration(configuration);
      }

    };



    NPackage.ThemePackage = ThemePackage;

    return NPackage.ThemePackage;
  }
});
