fcf.module({
  name: "fcf:tests/NFSQL/Parser.insert.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/NDetails/SingleParser.js"],
  module: function(uniTest, Parser) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");
    var parser = new Parser();

    uniTest.add("001 FSQL", "Parser (INSERT)", function(a_tester) {
      var data = parser.parse("INSERT INTO proj ( name1 , f2 ) VALUES ( ${1} , ${2} )", [1, 2]);
      uniTest.equalObject(
        data,
        {
          type: 'insert',
          from: 'proj',
          values: [{field: "name1", value: 1}, {field: "f2", value: 2}],
          args: {"values[0].value": 1, "values[1].value": 2}
        },
        "");

      var data = parser.parse("INSERT INTO proj(name1,f2)VALUES(${1},${2})", [5, 8]);
      uniTest.equalObject(
        data,
        {
          type: 'insert',
          from: 'proj',
          values: [{field: "name1", value: 5}, {field: "f2", value: 8}],
          args: {"values[0].value": 1, "values[1].value": 2}
        },
        "");


      var data = parser.parse("INSERT INTO \"proj\" ( \"name1\", \"f2\" ) VALUES ( ${1} , ${2} ) ", [1, 2]);
      uniTest.equalObject(
        data,
        {
          type: 'insert',
          from: 'proj',
          values: [{field: "name1", value: 1}, {field: "f2", value: 2}],
          args: {"values[0].value": 1, "values[1].value": 2}
        },
        "");

      var data = parser.parse("INSERT INTO\"proj\"(\"name1\",\"f2\")VALUES(${1},${2}) ", [1, 2]);
      uniTest.equalObject(
        data,
        {
          type: 'insert',
          from: 'proj',
          values: [{field: "name1", value: 1}, {field: "f2", value: 2}],
          args: {"values[0].value": 1, "values[1].value": 2}
        },
        "");

      var data = parser.parse("INSERT INTO\"proj\"(\"name1\",\"f2\")VALUES(${1},${2}) LANGUAGE ru", [1, 2]);
      uniTest.equalObject(
        data,
        {
          type: 'insert',
          from: 'proj',
          values: [{field: "name1", value: 1}, {field: "f2", value: 2}],
          language: "ru",
          args: {"values[0].value": 1, "values[1].value": 2}
        },
        "");

        var data = parser.parse("INSERT INTO\"proj\"(\"name1\",\"f2\")VALUES(${1},${2}) LANGUAGE ${3}", [1, 2, "en"]);
        uniTest.equalObject(
          data,
          {
            type: 'insert',
            from: 'proj',
            values: [{field: "name1", value: 1}, {field: "f2", value: 2}],
            language: "en",
            args: {"values[0].value": 1, "values[1].value": 2, "language": 3}
          },
          "");

    });

    return NTests;
  }
});
