var libFS = require("fs");
var libPath = require("path");
var libUtil = require("util");

fcf.module({
  name:         "fcf:NSystem/NDetails/fsEvents.js",
  dependencies: [],
  lazy:         [],
  module: function(){

    fcf.application.getEventChannel().on("_fcf_copy_file_write_part", {active: true}, (a_event)=>{
      return fcf.actions()
      .then((a_res, a_act)=>{
        if (!(a_event.eventItems[0] instanceof Buffer)) {
          a_act.error(new fcf.Exception("ERROR_WRITE_FILE",
                                        {
                                          file: a_event.file,
                                          error: `server: ${fcf.application.getConfiguration().serverName}; handler: ${fcf.application.getConfiguration().handlerName}; error: Invalid event format`
                                        }
                                      )
                     );
          return;
        }
        let filePath = fcf.getPath(`:cache/tmp/fs-operations/${fcf.application.getConfiguration().serverName}-${a_event.id}`);
        libFS.appendFile(filePath, a_event.eventItems[0], (a_error)=>{
          if (a_error){
            a_act.error(new fcf.Exception("ERROR_WRITE_FILE",
                                          {
                                            file: a_event.file,
                                            error: `server: ${fcf.application.getConfiguration().serverName}; handler: ${fcf.application.getConfiguration().handlerName}; error: ${a_error}`
                                          }
                                        )
                       );
          } else {
            a_act.complete();
          }
        });
      });
    });

    fcf.application.getEventChannel().on("_fcf_file_fix_change", {active: true}, (a_event)=>{
      let filePath = fcf.getPath(a_event.file);
      if (a_event.action == "copy") {
        let tmpFilePath = fcf.getPath(`:cache/tmp/fs-operations/${fcf.application.getConfiguration().serverName}-${a_event.id}`);
        return fcf.application.getSystemActions()
        .then((a_res, a_act)=>{
          libFS.rename(tmpFilePath, filePath, (a_error)=>{
            if (a_error){

              a_act.error(new fcf.Exception("ERROR_WRITE_FILE",
                                            {
                                              file: a_event.file,
                                              error: `server: ${fcf.application.getConfiguration().serverName}; handler: ${fcf.application.getConfiguration().handlerName}; error: ${a_error}`
                                            }
                                          )
                         );
            } else {
              a_act.complete();
            }
          });
        });
      } else if (a_event.action == "delete") {
        return fcf.application.getSystemActions()
        .then((a_res, a_act)=>{
          libFS.unlink(filePath, function(a_error) {
            a_act.complete();
          })
        });
      }

    });

    return;
  }
});
