fcf.module({
  name:         "fcfControls:templates/menu.receive.js",
  dependencies: ["fcfControls:templates/menu.helper.js"],
  lazy:         [],
  module: function(menuHelper) {
    return class Handler {
      async receive(a_fields, a_files){
        if (a_fields.command === "extend") {
          let result = {};
          await fcf.each(a_fields.items, async (a_key, a_uri)=>{
            let node = await fcf.application.getRouter().getMenuNode(a_uri, 1);
            result[a_uri] = [];
            fcf.each(node.childsOrder, (a_key, a_uriChild)=>{
              result[a_uri].push({
                uri:   a_uriChild,
                title: node.childs[a_uriChild].title,
              });
            });
          })
          return result;
        } else if (a_fields.command === "get_items") {
          let items = [];
          let current   = await menuHelper.getCurrentTree(a_fields.current, a_fields.root, true);
          if (current){
            current = menuHelper.findItem(current, a_fields.root);
            let treeInfo  = await fcf.application.getRouter().getMenuNode(a_fields.root, 0, false);
            let tree      = menuHelper.nodeToTree(treeInfo,
                                                  current,
                                                  true,
                                                  0,
                                                  1);
            items         = menuHelper.treeToList(tree, a_fields.enableRoot);
          }
          return items;
        }
      }
    }
  }
});
