fcf.module({
  name: "fcf:NSystem/Configuration.js",
  dependencies: ["fcf:NSystem/NPackage/tools.js"],
  module: function(libTools) {
    var NServer = fcf.prepareObject(fcf, "NServer");

    NServer.Configuration = function() {
      var self = this;

      this._defaultConfiguration    = {
        restart:                      false,
        port:                         8080,
        controlPort:                  undefined,
        innerControlPort:            undefined,
        host:                         undefined,
        fileСaching:                  true,
        projectionReloadingTimeout:   2000,
        disableWeb:                   false,
        disableSys:                   false,
        disableCron:                  false,
        master:                       true,
        leading:                      true,
        handlerName:                  "",
        processIndex:                 undefined,
        keepAliveTimeout:             5,
        logFile:                      "log/node-log-",
        userProjectionName:           "___fcf___users",
        packages:                     [],
        packageDirectories:           ["fcf:packages", "fcf:themes"],
        sessionLifetime:              30,
        sharedUserFileds:             [],
        aliases:                      {},
        usageViews:                   {},
        html:                         { include: {} },
        inheritanceModes:             {},
        filters:                      {},
        functions:                    {},
        defaultTheme:                 "defaultTheme",
      };
      this._userConfigurationsArr      = [];
      this._overwriteConfigurationsArr = [];
      this._packageConfigurationsArr   = [];
      this._userConfiguration          = fcf.append(true, {}, this._defaultConfiguration);;
      fcf.append(true, this, this._defaultConfiguration);

      this.getUserConfiguration = function(){
        return this._userConfiguration;
      }

      this.appendOverwriteConfiguration = function(a_overwriteConfigurationsArr) {
        this._overwriteConfigurationsArr.push(a_overwriteConfigurationsArr);
        this._build();
      }

      this.appendUserConfiguration = function(a_userConfiguration){
        this._userConfigurationsArr.push(a_userConfiguration);
        this._build();
      }

      this.appendConfiguration = function(a_data){
        this._packageConfigurationsArr.push(a_data);
        this._build();
      }

      this._build = function(){
        let realConfiguration = fcf.append(true, {}, this._defaultConfiguration);
        for(let i = 0; i < this._packageConfigurationsArr.length; ++i)
          libTools.mergeConfiguration(realConfiguration, this._packageConfigurationsArr[i], true);
        for(let i = 0; i < this._userConfigurationsArr.length; ++i)
          libTools.mergeConfiguration(realConfiguration, this._userConfigurationsArr[i], true);
        for(let i = 0; i < this._overwriteConfigurationsArr.length; ++i)
          libTools.mergeConfiguration(realConfiguration, this._overwriteConfigurationsArr[i], true);
        fcf.append(this, realConfiguration);

        this._userConfiguration = fcf.append(true, {}, this._defaultConfiguration);
        for(let i = 0; i < this._userConfigurationsArr.length; ++i)
          libTools.mergeConfiguration(this._userConfiguration, this._userConfigurationsArr[i], true);
        for(let i = 0; i < this._overwriteConfigurationsArr.length; ++i)
          libTools.mergeConfiguration(this._userConfiguration, this._overwriteConfigurationsArr[i], true);
      }


    }


    return NServer.Configuration;
  }
});
