fcf.module({
  name: "fcfControls:templates/text-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper {

      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      async initialize(){
        await super.initialize();
        let element = fcf.select(this.getDomElement(), "input")[0];
        if (element){
          if (fcf.str(this.getArg("value")) != fcf.str(element.value))
            this._setArg("value", element.value);
        }
      }

      getActionDomElement() {
        return fcf.select(this.getDomElement(), "input")[0];
      }

      onInput(a_event){
        if (this.getArg("enable"))
          this._setArg("value", this.getActionDomElement().value);
        else
          this.getActionDomElement().value = this.getArg("value");
      }
    };
  }
});
