# wstyle.rb
# The wondow styles of controls
#
# Programmed by yukimi_sake@mbi.nifty.com
# Copyright 2001-2003 Yukio Sakaue

$Style =
{:win => {
  "WS_BORDER" =>           0x800000,
#  "WS_CAPTION" =>          0xc00000,
#  "WS_CHILD" =>          0x40000000,
#  "WS_CHILDWINDOW" =>    0x40000000,
#  "WS_CLIPCHILDREN" =>    0x2000000,
  "WS_CLIPSIBLINGS" =>    0x4000000,
  "WS_DISABLED" =>        0x8000000,
#  "WS_DLGFRAME" =>         0x400000,
  "WS_GROUP" =>             0x20000,
  "WS_HSCROLL" =>          0x100000,
#  "WS_ICONIC" =>         0x20000000,
#  "WS_MAXIMIZE" =>        0x1000000,
#  "WS_MAXIMIZEBOX" =>       0x10000,
#  "WS_MINIMIZE" =>       0x20000000,
#  "WS_MINIMIZEBOX" =>       0x20000,
#  "WS_OVERLAPPED" =>              0,
#  "WS_OVERLAPPEDWINDOW" => 0xcf0000,
#  "WS_POPUP" =>          0x80000000,
#  "WS_POPUPWINDOW" =>    0x80880000,
#  "WS_SIZEBOX" =>           0x40000,
#  "WS_SYSMENU" =>           0x80000,
  "WS_TABSTOP" =>           0x10000,
  "WS_THICKFRAME" =>        0x40000,
#  "WS_TILED" =>                   0,
#  "WS_TILEDWINDOW" =>      0xcf0000,
#  "WS_VISIBLE" =>        0x10000000,
  "WS_VSCROLL" =>          0x200000},
:ccs => {
"CCS_TOP" => 1,
"CCS_NOMOVEY" => 2,
"CCS_BOTTOM" => 3,
"CCS_NORESIZE" => 4,
"CCS_NOPARENTALIGN" => 8,
"CCS_ADJUSTABLE" => 32,
"CCS_NODIVIDER" => 64
},
VRButton => {
  :style=>{
  "BS_DEFPUSHBUTTON"  => 0x01,
#  "BS_OWNERDRAW" => 0x0b,
  "BS_BITMAP" => 128,
  "BS_BOTTOM" => 0x800,
  "BS_CENTER" => 0x300,
  "BS_LEFT" => 256,
  "BS_RIGHT" => 512,
  "BS_TOP" => 0x400,
  "BS_VCENTER" => 0xc00,
  "BS_FLAT" => 0x8000,
  "BS_MULTILINE" => 0x2000
  },
  :option =>{}
  },
VREdit => {
  :style=>{
  "ES_AUTOHSCROLL" => 128,
  "ES_AUTOVSCROLL" => 64,
  "ES_CENTER" => 1,
  "ES_LOWERCASE" => 16,
# "ES_MULTILINE" => 4,
  "ES_NOHIDESEL" => 256,
  "ES_NUMBER" => 0x2000,
  "ES_OEMCONVERT" => 0x400,
  "ES_PASSWORD" => 32,
  "ES_READONLY" => 0x800,
  "ES_RIGHT" => 2,
  "ES_UPPERCASE" => 8,
  "ES_WANTRETURN" => 4096,
  },
  :option =>{}
  },
VRText => {
  :style=>{
  "ES_AUTOHSCROLL" => 128,
  "ES_AUTOVSCROLL" => 64,
# "ES_CENTER" => 1,
  "ES_LOWERCASE" => 16,
# "ES_MULTILINE" => 4,
  "ES_NOHIDESEL" => 256,
  "ES_NUMBER" => 0x2000,
  "ES_OEMCONVERT" => 0x400,
  "ES_PASSWORD" => 32,
  "ES_READONLY" => 0x800,
# "ES_RIGHT" => 2,
  "ES_UPPERCASE" => 8,
  "ES_WANTRETURN" => 4096,
  },
  :option =>{}
  },
VRCheckbox => {
  :style=>{
  "BS_RIGHTBUTTON" => 32
  },
  :option =>{}
  },
VRRadiobutton => {
  :style=>{
  "BS_RIGHTBUTTON" => 32
  },
  :option =>{}
  },
VRStatic => {
  :style=>{
  "SS_NOPREFIX" => 128,
  "SS_NOTIFY" => 256,
  "SS_CENTERIMAGE" => 512,
  "SS_RIGHTJUST" => 0x400,
  "SS_REALSIZEIMAGE" => 0x800,
  "SS_SUNKEN" => 4096,
  },
  :option =>{
  "SS_LEFT" => 0,
  "SS_CENTER" => 1,
  "SS_RIGHT" => 2,
  "SS_ICON" => 3,
  "SS_BLACKRECT" => 4,
  "SS_GRAYRECT" => 5,
  "SS_WHITERECT" => 6,
  "SS_BLACKFRAME" => 7,
  "SS_GRAYFRAME" => 8,
  "SS_WHITEFRAME" => 9,
  "SS_USERITEM" => 10,
  "SS_SIMPLE" => 11,
  "SS_LEFTNOWORDWRAP" => 12,
  "SS_OWNERDRAW" => 13,
  "SS_BITMAP" => 14,
  "SS_ENHMETAFILE" => 15,
  "SS_ETCHEDHORZ" => 16,
  "SS_ETCHEDVERT" => 17,
  "SS_ETCHEDFRAME" => 18,
  }
  },
VRListbox => {
  :style=>{
#  "LBS_NOTIFY" => 1,
  "LBS_SORT" => 2,
  "LBS_NOREDRAW" => 4,
  "LBS_MULTIPLESEL" => 8,
#  "LBS_OWNERDRAWFIXED" => 16,
#  "LBS_OWNERDRAWVARIABLE" => 32,
  "LBS_HASSTRINGS" => 64,
  "LBS_USETABSTOPS" => 128,
  "LBS_NOINTEGRALHEIGHT" => 256,
  "LBS_MULTICOLUMN" => 512,
  "LBS_WANTKEYBOARDINPUT" => 0x400,
  "LBS_EXTENDEDSEL" => 0x800,
  "LBS_DISABLENOSCROLL" => 4096,
  "LBS_NODATA" => 0x2000,
  "LBS_NOSEL" => 0x4000,
#  "LBS_STANDARD" => 0xa00003,
  },
  :option =>{}
  },
VRCombobox => {
  :style=>{
#  "CBS_SIMPLE" => 1,
#  "CBS_DROPDOWN" => 2,
#  "CBS_DROPDOWNLIST" => 3,
#  "CBS_OWNERDRAWFIXED" => 16,
#  "CBS_OWNERDRAWVARIABLE" => 32,
  "CBS_AUTOHSCROLL" => 64,
  "CBS_OEMCONVERT" => 128,
  "CBS_SORT" => 256,
  "CBS_HASSTRINGS" => 512,
  "CBS_NOINTEGRALHEIGHT" => 0x400,
  "CBS_DISABLENOSCROLL" => 0x800,
  "CBS_UPPERCASE" => 0x2000,
  "CBS_LOWERCASE" => 0x4000,
  },
  :option =>{}
},

VREditCombobox => {
  :style=>{
#  "CBS_SIMPLE" => 1,
#  "CBS_DROPDOWN" => 2,
#  "CBS_DROPDOWNLIST" => 3,
#  "CBS_OWNERDRAWFIXED" => 16,
#  "CBS_OWNERDRAWVARIABLE" => 32,
  "CBS_AUTOHSCROLL" => 64,
  "CBS_OEMCONVERT" => 128,
  "CBS_SORT" => 256,
  "CBS_HASSTRINGS" => 512,
  "CBS_NOINTEGRALHEIGHT" => 0x400,
  "CBS_DISABLENOSCROLL" => 0x800,
  "CBS_UPPERCASE" => 0x2000,
  "CBS_LOWERCASE" => 0x4000,
  },
  :option =>{}
},

VRGroupbox => {
  :style=>{
  },
  :option =>{}
  },

VRRichedit => {
  :style => {
  "ES_DISABLENOSCROLL" => 8192,
  "ES_EX_NOCALLOLEINIT" =>16777216,
  "ES_NOIME" =>524288,
  "ES_SAVESEL" =>32768,
  "ES_SELFIME" =>262144,
  "ES_SUNKEN" =>16384,
  "ES_VERTICAL" =>4194304,
  "ES_SELECTIONBAR" =>16777216,
  "ES_AUTOHSCROLL" => 128,
  "ES_AUTOVSCROLL" => 64,
  "ES_CENTER" => 1,
  "ES_MULTILINE" => 4,
  "ES_NOHIDESEL" => 256,
  "ES_READONLY" => 0x800,
  "ES_RIGHT" => 2,
  "ES_WANTRETURN" => 4096
  },
  :option => {
  }
},

VRToolbar => {
  :style=>{
    "TBSTYLE_TOOLTIPS" => 256,
    "TBSTYLE_WRAPABLE" => 512,
    "TBSTYLE_ALTDRAG" => 1024,
    "TBSTYLE_FLAT" => 2048,    
  },
  :option =>{
    "CCS_TOP" => 1,
    "CCS_NOMOVEY" => 2,
    "CCS_BOTTOM" => 3,
    "CCS_NORESIZE" => 4,
    "CCS_NOPARENTALIGN" => 8,
    "CCS_ADJUSTABLE" => 32,
    "CCS_NODIVIDER" => 64
  }
},
VRRebar => {
  :style=>{
    "RBS_TOOLTIPS" => 256,
    "RBS_VARHEIGHT" => 512,
    "RBS_BANDBORDERS" => 1024,
    "RBS_FIXEDORDER" => 2048,
  },
  :option =>{
    "CCS_TOP" => 1,
    "CCS_NOMOVEY" => 2,
    "CCS_BOTTOM" => 3,
    "CCS_NORESIZE" => 4,
    "CCS_NOPARENTALIGN" => 8,
    "CCS_ADJUSTABLE" => 32,
    "CCS_NODIVIDER" => 64
  }
},
VRListview => {
  :style=>{
#"LVS_TYPEMASK" => 3,
"LVS_SINGLESEL" => 4,
"LVS_SHOWSELALWAYS" => 8,
"LVS_SORTASCENDING" => 16,
"LVS_SORTDESCENDING" => 32,
"LVS_SHAREIMAGELISTS" => 64,
"LVS_NOLABELWRAP" => 128,
"LVS_AUTOARRANGE" => 256,
"LVS_EDITLABELS" => 512,
"LVS_NOSCROLL" => 0x2000,
"LVS_TYPESTYLEMASK" => 0xfc00,
#"LVS_ALIGNTOP" => 0,
"LVS_ALIGNLEFT" => 0x800,
"LVS_ALIGNMASK" => 0xc00,
#"LVS_OWNERDRAWFIXED" => 0x400,
"LVS_NOCOLUMNHEADER" => 0x4000,
"LVS_NOSORTHEADER" => 0x8000
},
  :option =>{
    "LVS_ICON" => 0,
    "LVS_REPORT" => 1,
    "LVS_SMALLICON" => 2,
    "LVS_LIST" => 3
    }
  },

VRTreeview => {
  :style => {
"TVS_HASLINES" => 2,
"TVS_LINESATROOT" => 4,
"TVS_EDITLABELS" => 8,
"TVS_DISABLEDRAGDROP" => 16,
"TVS_SHOWSELALWAYS" => 32
},
  :option =>{}
  },

VRProgressbar => {
  :style=>{
  },
  :option =>{}
  },

VRTrackbar => {
  :style=>{
"TBS_VERT" => 2,
"TBS_HORZ" => 0,
"TBS_TOP" => 4,
"TBS_BOTTOM" => 0,
"TBS_LEFT" => 4,
"TBS_RIGHT" => 0,
"TBS_BOTH" => 8,
"TBS_NOTICKS" => 16,
"TBS_ENABLESELRANGE" => 32,
"TBS_FIXEDLENGTH" => 64,
"TBS_NOTHUMB" => 128
  },
  :option =>{}
  },

VRUpdown => {
  :style=>{
"UDS_WRAP" => 1,
"UDS_SETBUDDYINT" => 2,
"UDS_ALIGNRIGHT" => 4,
"UDS_ALIGNLEFT" => 8,
"UDS_AUTOBUDDY" => 16,
"UDS_ARROWKEYS" => 32,
"UDS_HORZ" => 64,
"UDS_NOTHOUSANDS" => 128
  },
  :option =>{}
  },

VRStatusbar => {
  :style=>{
"SBARS_SIZEGRIP" => 256
},
  :option =>{    
    "CCS_TOP" => 1,
    "CCS_NOMOVEY" => 2,
    "CCS_BOTTOM" => 3,
    "CCS_NORESIZE" => 4,
    "CCS_NOPARENTALIGN" => 8,
    "CCS_ADJUSTABLE" => 32,
    "CCS_NODIVIDER" => 64
  }
},

VRTabControl => {
  :style=>{
"TCS_FORCEICONLEFT" => 16,
"TCS_FORCELABELLEFT" => 32,
"TCS_TABS" => 0,
"TCS_BUTTONS" => 256,
"TCS_SINGLELINE" => 0,
"TCS_MULTILINE" => 512,
"TCS_RIGHTJUSTIFY" => 0,
"TCS_FIXEDWIDTH" => 1024,
"TCS_RAGGEDRIGHT" => 2048,
"TCS_FOCUSONBUTTONDOWN" => 0x1000,
#"TCS_OWNERDRAWFIXED" => 0x2000,
"TCS_TOOLTIPS" => 0x4000,
"TCS_FOCUSNEVER" => 0x8000,
"TCS_BOTTOM" => 2,
"TCS_RIGHT" => 2,
"TCS_VERTICAL" => 128,
"TCS_HOTTRACK" => 0x0040
  },
  :option =>{}
  },

VRTabbedPanel => {
  :style=>{
"TCS_FORCEICONLEFT" => 16,
"TCS_FORCELABELLEFT" => 32,
"TCS_TABS" => 0,
#"TCS_BUTTONS" => 256,
"TCS_SINGLELINE" => 0,
"TCS_MULTILINE" => 512,
"TCS_RIGHTJUSTIFY" => 0,
"TCS_FIXEDWIDTH" => 1024,
"TCS_RAGGEDRIGHT" => 2048,
"TCS_FOCUSONBUTTONDOWN" => 0x1000,
#"TCS_OWNERDRAWFIXED" => 0x2000,
"TCS_TOOLTIPS" => 0x4000,
"TCS_FOCUSNEVER" => 0x8000,
"TCS_BOTTOM" => 2,
"TCS_RIGHT" => 2,
"TCS_VERTICAL" => 128,
"TCS_HOTTRACK" => 0x0040
  },
  :option =>{}
}}

module FDOwnerDraw
  ODConst={
    VRButton=>{'use'=>0x0b},
    VRListbox=>{'fixed'=>16,'variable'=>32},
    VRCombobox=>{'fixed'=>16,'variable'=>32},
    VREditCombobox=>{'fixed'=>16,'variable'=>32},
    VRListview=>{'fixed'=>0x400},
    VRTabControl=>{'fixed'=>0x2000},
    VRTabbedPanel=>{'fixed'=>0x2000}
  }
end

