/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jibx.extras.DocumentModelMapperBase;
import org.jibx.runtime.JiBXException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomMapperBase
extends DocumentModelMapperBase {
    protected Document m_document;
    protected String m_defaultNamespaceURI;
    protected int m_defaultNamespaceIndex;

    protected DomMapperBase() throws JiBXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            this.m_document = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new JiBXException("Unable to create DOM document", e);
        }
    }

    private int findNamespaceIndex(String prefix, String uri) {
        if ("".equals(prefix) && "".equals(uri)) {
            return 0;
        }
        if ("xml".equals(prefix) && "http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return 1;
        }
        if (prefix == null) {
            if (this.m_defaultNamespaceURI == null) {
                int index = this.m_xmlWriter.getPrefixIndex("");
                if (index >= 0) {
                    this.m_defaultNamespaceURI = this.getNamespaceUri(index);
                    this.m_defaultNamespaceIndex = index;
                    if (this.m_defaultNamespaceURI.equals(uri)) {
                        return index;
                    }
                    return -1;
                }
                return -1;
            }
            return this.m_defaultNamespaceURI.equals(uri) ? this.m_defaultNamespaceIndex : -1;
        }
        int index = this.m_xmlWriter.getPrefixIndex(prefix);
        if (index >= 0) {
            return this.getNamespaceUri(index).equals(uri) ? index : -1;
        }
        return -1;
    }

    protected void marshalNode(Node node) throws JiBXException, IOException {
        switch (node.getNodeType()) {
            case 4: {
                this.m_xmlWriter.writeCData(node.getNodeValue());
                break;
            }
            case 8: {
                this.m_xmlWriter.writeComment(node.getNodeValue());
                break;
            }
            case 1: {
                this.marshalElement((Element)node);
                break;
            }
            case 5: {
                this.m_xmlWriter.writeEntityRef(node.getNodeName());
                break;
            }
            case 7: {
                this.m_xmlWriter.writePI(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 3: {
                this.m_xmlWriter.writeTextContent(node.getNodeValue());
                break;
            }
        }
    }

    protected void marshalContent(NodeList content) throws JiBXException, IOException {
        int size = content.getLength();
        for (int i = 0; i < size; ++i) {
            this.marshalNode(content.item(i));
        }
    }

    protected void marshalElement(Element element) throws JiBXException, IOException {
        String prefix = element.getPrefix();
        String uri = element.getNamespaceURI();
        int nsi = this.findNamespaceIndex(prefix, uri);
        ArrayList<String> nss = null;
        int defind = -1;
        String defuri = null;
        NamedNodeMap attrs = element.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            String decluri;
            Attr attr = (Attr)attrs.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            String declpref = attr.getLocalName();
            if ("xmlns".equals(declpref)) {
                declpref = null;
            }
            if (this.findNamespaceIndex(declpref, decluri = attr.getValue()) >= 0) continue;
            if (nss == null) {
                nss = new ArrayList<String>();
            }
            nss.add(declpref == null ? "" : declpref);
            nss.add(decluri == null ? "" : decluri);
            if (declpref == null) {
                defind = nss.size() / 2 - 1;
                defuri = decluri;
            }
            if (uri != decluri) continue;
            nsi = defind;
        }
        String[] uris = null;
        if (nss == null) {
            this.m_xmlWriter.startTagOpen(nsi, element.getLocalName());
        } else {
            int base = this.getNextNamespaceIndex();
            if (defind >= 0) {
                this.m_defaultNamespaceIndex = base + defind;
                this.m_defaultNamespaceURI = defuri;
            }
            int length = nss.size() / 2;
            uris = new String[length];
            int[] nums = new int[length];
            String[] prefs = new String[length];
            for (int i = 0; i < length; ++i) {
                prefs[i] = (String)nss.get(i * 2);
                uris[i] = (String)nss.get(i * 2 + 1);
                nums[i] = base + i;
                if (nsi >= 0 || !uri.equals(uris[i]) || (prefix != null || prefs[i] != "") && (prefix == null || !prefix.equals(prefs[i]))) continue;
                nsi = base + i;
            }
            this.m_xmlWriter.pushExtensionNamespaces(uris);
            this.m_xmlWriter.startTagNamespaces(nsi, element.getLocalName(), nums, prefs);
            if (defind >= 0) {
                this.m_defaultNamespaceIndex = defind;
                this.m_defaultNamespaceURI = defuri;
            }
        }
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)attrs.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            int index = 0;
            String apref = attr.getPrefix();
            if (apref != null) {
                index = this.findNamespaceIndex(apref, attr.getNamespaceURI());
            }
            this.m_xmlWriter.addAttribute(index, attr.getLocalName(), attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        size = nodes.getLength();
        if (size > 0) {
            this.m_xmlWriter.closeStartTag();
            this.marshalContent(element.getChildNodes());
            this.m_xmlWriter.endTag(nsi, element.getLocalName());
        } else {
            this.m_xmlWriter.closeEmptyTag();
        }
        if (nss != null) {
            this.m_xmlWriter.popExtensionNamespaces();
            if (defind >= 0) {
                this.m_defaultNamespaceURI = null;
            }
        }
    }

    protected Node unmarshalNode() throws JiBXException, IOException {
        while (true) {
            int cev = this.m_unmarshalContext.currentEvent();
            switch (cev) {
                case 5: {
                    String text = this.m_unmarshalContext.getText();
                    this.m_unmarshalContext.nextToken();
                    return this.m_document.createCDATASection(text);
                }
                case 9: {
                    String text = this.m_unmarshalContext.getText();
                    this.m_unmarshalContext.nextToken();
                    return this.m_document.createComment(text);
                }
                case 3: {
                    return null;
                }
                case 6: {
                    if (this.m_unmarshalContext.getText() == null) {
                        String name = this.m_unmarshalContext.getName();
                        this.m_unmarshalContext.nextToken();
                        return this.m_document.createEntityReference(name);
                    }
                    String text = this.accumulateText();
                    return this.m_document.createTextNode(text);
                }
                case 8: {
                    String text = this.m_unmarshalContext.getText();
                    this.m_unmarshalContext.nextToken();
                    int index = 0;
                    while (++index < text.length() && !this.isWhitespace(text.charAt(index))) {
                    }
                    if (index < text.length()) {
                        String target = text.substring(0, index);
                        while (++index < text.length() && this.isWhitespace(text.charAt(index))) {
                        }
                        String data = text.substring(index);
                        return this.m_document.createProcessingInstruction(target, data);
                    }
                    return this.m_document.createProcessingInstruction(text, "");
                }
                case 2: {
                    return this.unmarshalElement();
                }
                case 4: {
                    return this.m_document.createTextNode(this.accumulateText());
                }
            }
            this.m_unmarshalContext.nextToken();
        }
    }

    protected void unmarshalContent(Node parent) throws JiBXException, IOException {
        Node node;
        while ((node = this.unmarshalNode()) != null) {
            parent.appendChild(node);
        }
    }

    protected Element unmarshalElement() throws JiBXException, IOException {
        String uri = this.m_unmarshalContext.getNamespace();
        String prefix = this.m_unmarshalContext.getPrefix();
        String name = this.m_unmarshalContext.getName();
        if (prefix != null) {
            name = prefix + ':' + name;
        }
        Element element = this.m_document.createElementNS(uri, name);
        int ncount = this.m_unmarshalContext.getNamespaceCount();
        for (int i = 0; i < ncount; ++i) {
            prefix = this.m_unmarshalContext.getNamespacePrefix(i);
            uri = this.m_unmarshalContext.getNamespaceUri(i);
            if (prefix == null) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
                continue;
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        int acount = this.m_unmarshalContext.getAttributeCount();
        for (int i = 0; i < acount; ++i) {
            prefix = this.m_unmarshalContext.getAttributePrefix(i);
            uri = this.m_unmarshalContext.getAttributeNamespace(i);
            name = this.m_unmarshalContext.getAttributeName(i);
            if (prefix != null) {
                name = prefix + ':' + name;
            }
            String value = this.m_unmarshalContext.getAttributeValue(i);
            element.setAttributeNS(uri, name, value);
        }
        int event = this.m_unmarshalContext.nextToken();
        if (event != 3) {
            this.unmarshalContent(element);
        }
        this.m_unmarshalContext.nextToken();
        return element;
    }
}

