/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.classfile.Utility;
import org.jibx.binding.classes.ClassFile;
import org.jibx.runtime.JiBXException;

public class ClassCache {
    protected static ClassCache s_instance;
    protected String[] m_paths;
    protected File[] m_roots;
    protected HashMap m_classMap;

    private ClassCache(String[] paths) {
        String path;
        int i;
        ArrayList<String> keepers = new ArrayList<String>();
        for (i = 0; i < paths.length; ++i) {
            path = paths[i];
            int mark = path.lastIndexOf(46);
            if (mark >= 0 && "jar".equalsIgnoreCase(path.substring(mark + 1))) continue;
            keepers.add(paths[i]);
        }
        this.m_paths = new String[keepers.size()];
        this.m_roots = new File[keepers.size()];
        for (i = 0; i < keepers.size(); ++i) {
            path = (String)keepers.get(i);
            int length = path.length();
            if (length > 0 && path.charAt(length - 1) != File.separatorChar) {
                path = path + File.separator;
            }
            this.m_paths[i] = path;
            this.m_roots[i] = new File(path);
        }
        this.m_classMap = new HashMap();
    }

    private ClassFile getClassFileImpl(String name) throws JiBXException {
        Object match = this.m_classMap.get(name);
        if (match != null) {
            return (ClassFile)match;
        }
        if (name.endsWith("[]")) {
            ClassFile cf = new ClassFile(name, Utility.getSignature(name));
            this.m_classMap.put(name, cf);
            return cf;
        }
        try {
            ClassFile cf = null;
            String path = name.replace('.', File.separatorChar) + ".class";
            for (int i = 0; i < this.m_paths.length; ++i) {
                File file = new File(this.m_paths[i], path);
                if (!file.exists()) continue;
                cf = new ClassFile(name, this.m_roots[i], file);
                break;
            }
            if (cf == null) {
                cf = new ClassFile(name);
            }
            if (cf != null) {
                String sname = cf.getSuperName();
                if (!name.equals(sname) && sname != null) {
                    ClassFile sf = this.getClassFileImpl(sname);
                    if (sf == null) {
                        throw new JiBXException("Superclass " + sname + " of class " + name + " not found");
                    }
                    cf.setSuperFile(sf);
                }
                this.m_classMap.put(name, cf);
            }
            return cf;
        }
        catch (IOException ex) {
            throw new JiBXException("Error loading class " + name);
        }
    }

    public static ClassFile getClassFile(String name) throws JiBXException {
        return s_instance.getClassFileImpl(name);
    }

    static void addClassFile(ClassFile cf) {
        ClassCache.s_instance.m_classMap.put(cf.getName(), cf);
    }

    public static void setPaths(String[] paths) {
        s_instance = new ClassCache(paths);
    }
}

