/*
 * $Id: BasicFileLocator.java,v 1.4 2005/05/04 15:59:33 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/4/3
 */

package feat.v1.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * t@C̏ꏊ\NXB
 */
public class BasicFileLocator implements FileLocator {

    private File file;
    private FileLocator rootLocation;

    /**
     *
     * @param file
     * @throws IllegalArgumentException null
     */
    public BasicFileLocator(File file) throws IllegalArgumentException {
        if ( file == null )
            throw new IllegalArgumentException("file:null");
        this.file = file;
        this.rootLocation = this;
    }

    protected BasicFileLocator(File file, FileLocator rootLocation) {
        this(file);
        if ( rootLocation == null )
            this.rootLocation = this;
        else
            this.rootLocation = rootLocation;
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(file);
    }

    public String getURIString() {
        return file.toURI().toASCIIString();
    }

    public FileLocator newLocation(String relativePath) throws IllegalArgumentException {
        if ( relativePath == null )
            return this;

        if ( relativePath.startsWith("/") )
            throw new IllegalArgumentException("\""+relativePath+"\" '/'Ŏn܂pX͎włȂ");
        if ( relativePath.startsWith(".") )
        	throw new IllegalArgumentException("\""+relativePath+"\" fBNg̐擪'.'͎gpłȂ");
        if ( relativePath.indexOf("..") > -1 )
            throw new IllegalArgumentException("\""+relativePath+"\" ʂ̃fBNg͎włȂ");

        if ( file.isFile() ) {
            return new BasicFileLocator(new File(file.getParentFile(), relativePath), rootLocation);
        }
        else {
            return new BasicFileLocator(new File(file, relativePath), rootLocation);
        }

    }

    public FileLocator rootLocation() {
        return rootLocation;
    }

    public boolean exists() {
        return file.exists();
    }

    public String getFilename() {
        if ( file.isFile() )
            return file.getName();
        else
        	return null;
    }

    public long getLastModified() {
        return file.lastModified();
    }

    public boolean equals(Object o) {
        BasicFileLocator loc = (BasicFileLocator)o;
        boolean ret = file.equals(loc.file);
        if ( rootLocation != this )
            ret = ret && rootLocation.equals(loc.rootLocation);
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if ( rootLocation != this ) {
            buf.append("<").append(rootLocation.toString()).append(">");
        }
        buf.append(file.getPath());
        return buf.toString();
    }
}
